/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file DispFormula_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_DISPFORMULA_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_DISPFORMULA_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CMath;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CDispFormula_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CDispFormula_Base(void);
    // destructor
    virtual ~CDispFormula_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CMath TMath;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_math
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CMath TMath
    ///  Check whether the Math data member has been assigned a value.
    bool IsSetMath(void) const;
    /// Check whether it is safe or not to call GetMath method.
    bool CanGetMath(void) const;
    void ResetMath(void);
    const TMath& GetMath(void) const;
    void SetMath(TMath& value);
    TMath& SetMath(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CDispFormula_Base(const CDispFormula_Base&);
    CDispFormula_Base& operator=(const CDispFormula_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TMath > m_Math;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CDispFormula_Base::IsSetMath(void) const
{
    return m_Math.NotEmpty();
}

inline
bool CDispFormula_Base::CanGetMath(void) const
{
    return true;
}

inline
const CDispFormula_Base::TMath& CDispFormula_Base::GetMath(void) const
{
    if ( !m_Math ) {
        const_cast<CDispFormula_Base*>(this)->ResetMath();
    }
    return (*m_Math);
}

inline
CDispFormula_Base::TMath& CDispFormula_Base::SetMath(void)
{
    if ( !m_Math ) {
        ResetMath();
    }
    return (*m_Math);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_DISPFORMULA_BASE_HPP
