/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Declare_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_DECLARE_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_DECLARE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <objtools/eutils/efetch/ContExp.hpp>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CDeclare_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CDeclare_Base(void);
    // destructor
    virtual ~CDeclare_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_occurrence {
            eAttlist_occurrence_prefix         = 1,
            eAttlist_occurrence_infix          = 2,
            eAttlist_occurrence_function_model = 3
        };
        
        /// Access to EAttlist_occurrence's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_occurrence)(void);
        
        // types
        typedef NCBI_NS_STD::string TType;
        typedef NCBI_NS_STD::string TScope;
        typedef NCBI_NS_STD::string TNargs;
        typedef EAttlist_occurrence TOccurrence;
        typedef NCBI_NS_STD::string TEncoding;
        typedef NCBI_NS_STD::string TDefinitionURL;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_type,
            e_scope,
            e_nargs,
            e_occurrence,
            e_encoding,
            e_definitionURL
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 7> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef NCBI_NS_STD::string TType
        ///  Check whether the Type data member has been assigned a value.
        bool IsSetType(void) const;
        /// Check whether it is safe or not to call GetType method.
        bool CanGetType(void) const;
        void ResetType(void);
        const TType& GetType(void) const;
        void SetType(const TType& value);
        void SetType(TType&& value);
        TType& SetType(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TScope
        ///  Check whether the Scope data member has been assigned a value.
        bool IsSetScope(void) const;
        /// Check whether it is safe or not to call GetScope method.
        bool CanGetScope(void) const;
        void ResetScope(void);
        const TScope& GetScope(void) const;
        void SetScope(const TScope& value);
        void SetScope(TScope&& value);
        TScope& SetScope(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TNargs
        ///  Check whether the Nargs data member has been assigned a value.
        bool IsSetNargs(void) const;
        /// Check whether it is safe or not to call GetNargs method.
        bool CanGetNargs(void) const;
        void ResetNargs(void);
        const TNargs& GetNargs(void) const;
        void SetNargs(const TNargs& value);
        void SetNargs(TNargs&& value);
        TNargs& SetNargs(void);
    
        /// optional
        /// typedef EAttlist_occurrence TOccurrence
        ///  Check whether the Occurrence data member has been assigned a value.
        bool IsSetOccurrence(void) const;
        /// Check whether it is safe or not to call GetOccurrence method.
        bool CanGetOccurrence(void) const;
        void ResetOccurrence(void);
        TOccurrence GetOccurrence(void) const;
        void SetOccurrence(TOccurrence value);
        TOccurrence& SetOccurrence(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TEncoding
        ///  Check whether the Encoding data member has been assigned a value.
        bool IsSetEncoding(void) const;
        /// Check whether it is safe or not to call GetEncoding method.
        bool CanGetEncoding(void) const;
        void ResetEncoding(void);
        const TEncoding& GetEncoding(void) const;
        void SetEncoding(const TEncoding& value);
        void SetEncoding(TEncoding&& value);
        TEncoding& SetEncoding(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TDefinitionURL
        ///  Check whether the DefinitionURL data member has been assigned a value.
        bool IsSetDefinitionURL(void) const;
        /// Check whether it is safe or not to call GetDefinitionURL method.
        bool CanGetDefinitionURL(void) const;
        void ResetDefinitionURL(void);
        const TDefinitionURL& GetDefinitionURL(void) const;
        void SetDefinitionURL(const TDefinitionURL& value);
        void SetDefinitionURL(TDefinitionURL&& value);
        TDefinitionURL& SetDefinitionURL(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::string m_Type;
        NCBI_NS_STD::string m_Scope;
        NCBI_NS_STD::string m_Nargs;
        EAttlist_occurrence m_Occurrence;
        NCBI_NS_STD::string m_Encoding;
        NCBI_NS_STD::string m_DefinitionURL;
    };
    /////////////////////////////////////////////////////////////////////////////
    class C_E_ContExp : public CContExp
    {
        typedef CContExp Tparent;
    public:
        C_E_ContExp(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    };
    // types
    typedef C_Attlist TAttlist;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_ContExp > > TContExp;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_ContExp
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_ContExp > > TContExp
    ///  Check whether the ContExp data member has been assigned a value.
    bool IsSetContExp(void) const;
    /// Check whether it is safe or not to call GetContExp method.
    bool CanGetContExp(void) const;
    void ResetContExp(void);
    const TContExp& GetContExp(void) const;
    TContExp& SetContExp(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CDeclare_Base(const CDeclare_Base&);
    CDeclare_Base& operator=(const CDeclare_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_ContExp > > m_ContExp;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CDeclare_Base::C_Attlist::IsSetType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CDeclare_Base::C_Attlist::CanGetType(void) const
{
    return IsSetType();
}

inline
const CDeclare_Base::C_Attlist::TType& CDeclare_Base::C_Attlist::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(0);
    }
    return m_Type;
}

inline
void CDeclare_Base::C_Attlist::SetType(const CDeclare_Base::C_Attlist::TType& value)
{
    m_Type = value;
    m_set_State[0] |= 0x3;
}

inline
void CDeclare_Base::C_Attlist::SetType(CDeclare_Base::C_Attlist::TType&& value)
{
    m_Type = std::forward<CDeclare_Base::C_Attlist::TType>(value);
    m_set_State[0] |= 0x3;
}

inline
CDeclare_Base::C_Attlist::TType& CDeclare_Base::C_Attlist::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        m_Type = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Type;
}

inline
bool CDeclare_Base::C_Attlist::IsSetScope(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CDeclare_Base::C_Attlist::CanGetScope(void) const
{
    return IsSetScope();
}

inline
const CDeclare_Base::C_Attlist::TScope& CDeclare_Base::C_Attlist::GetScope(void) const
{
    if (!CanGetScope()) {
        ThrowUnassigned(1);
    }
    return m_Scope;
}

inline
void CDeclare_Base::C_Attlist::SetScope(const CDeclare_Base::C_Attlist::TScope& value)
{
    m_Scope = value;
    m_set_State[0] |= 0xc;
}

inline
void CDeclare_Base::C_Attlist::SetScope(CDeclare_Base::C_Attlist::TScope&& value)
{
    m_Scope = std::forward<CDeclare_Base::C_Attlist::TScope>(value);
    m_set_State[0] |= 0xc;
}

inline
CDeclare_Base::C_Attlist::TScope& CDeclare_Base::C_Attlist::SetScope(void)
{
#ifdef _DEBUG
    if (!IsSetScope()) {
        m_Scope = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Scope;
}

inline
bool CDeclare_Base::C_Attlist::IsSetNargs(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CDeclare_Base::C_Attlist::CanGetNargs(void) const
{
    return IsSetNargs();
}

inline
const CDeclare_Base::C_Attlist::TNargs& CDeclare_Base::C_Attlist::GetNargs(void) const
{
    if (!CanGetNargs()) {
        ThrowUnassigned(2);
    }
    return m_Nargs;
}

inline
void CDeclare_Base::C_Attlist::SetNargs(const CDeclare_Base::C_Attlist::TNargs& value)
{
    m_Nargs = value;
    m_set_State[0] |= 0x30;
}

inline
void CDeclare_Base::C_Attlist::SetNargs(CDeclare_Base::C_Attlist::TNargs&& value)
{
    m_Nargs = std::forward<CDeclare_Base::C_Attlist::TNargs>(value);
    m_set_State[0] |= 0x30;
}

inline
CDeclare_Base::C_Attlist::TNargs& CDeclare_Base::C_Attlist::SetNargs(void)
{
#ifdef _DEBUG
    if (!IsSetNargs()) {
        m_Nargs = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Nargs;
}

inline
bool CDeclare_Base::C_Attlist::IsSetOccurrence(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CDeclare_Base::C_Attlist::CanGetOccurrence(void) const
{
    return IsSetOccurrence();
}

inline
void CDeclare_Base::C_Attlist::ResetOccurrence(void)
{
    m_Occurrence = (EAttlist_occurrence)(0);
    m_set_State[0] &= ~0xc0;
}

inline
CDeclare_Base::C_Attlist::TOccurrence CDeclare_Base::C_Attlist::GetOccurrence(void) const
{
    if (!CanGetOccurrence()) {
        ThrowUnassigned(3);
    }
    return m_Occurrence;
}

inline
void CDeclare_Base::C_Attlist::SetOccurrence(CDeclare_Base::C_Attlist::TOccurrence value)
{
    m_Occurrence = value;
    m_set_State[0] |= 0xc0;
}

inline
CDeclare_Base::C_Attlist::TOccurrence& CDeclare_Base::C_Attlist::SetOccurrence(void)
{
#ifdef _DEBUG
    if (!IsSetOccurrence()) {
        memset(&m_Occurrence,UnassignedByte(),sizeof(m_Occurrence));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Occurrence;
}

inline
bool CDeclare_Base::C_Attlist::IsSetEncoding(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CDeclare_Base::C_Attlist::CanGetEncoding(void) const
{
    return IsSetEncoding();
}

inline
const CDeclare_Base::C_Attlist::TEncoding& CDeclare_Base::C_Attlist::GetEncoding(void) const
{
    if (!CanGetEncoding()) {
        ThrowUnassigned(4);
    }
    return m_Encoding;
}

inline
void CDeclare_Base::C_Attlist::SetEncoding(const CDeclare_Base::C_Attlist::TEncoding& value)
{
    m_Encoding = value;
    m_set_State[0] |= 0x300;
}

inline
void CDeclare_Base::C_Attlist::SetEncoding(CDeclare_Base::C_Attlist::TEncoding&& value)
{
    m_Encoding = std::forward<CDeclare_Base::C_Attlist::TEncoding>(value);
    m_set_State[0] |= 0x300;
}

inline
CDeclare_Base::C_Attlist::TEncoding& CDeclare_Base::C_Attlist::SetEncoding(void)
{
#ifdef _DEBUG
    if (!IsSetEncoding()) {
        m_Encoding = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Encoding;
}

inline
bool CDeclare_Base::C_Attlist::IsSetDefinitionURL(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CDeclare_Base::C_Attlist::CanGetDefinitionURL(void) const
{
    return IsSetDefinitionURL();
}

inline
const CDeclare_Base::C_Attlist::TDefinitionURL& CDeclare_Base::C_Attlist::GetDefinitionURL(void) const
{
    if (!CanGetDefinitionURL()) {
        ThrowUnassigned(5);
    }
    return m_DefinitionURL;
}

inline
void CDeclare_Base::C_Attlist::SetDefinitionURL(const CDeclare_Base::C_Attlist::TDefinitionURL& value)
{
    m_DefinitionURL = value;
    m_set_State[0] |= 0xc00;
}

inline
void CDeclare_Base::C_Attlist::SetDefinitionURL(CDeclare_Base::C_Attlist::TDefinitionURL&& value)
{
    m_DefinitionURL = std::forward<CDeclare_Base::C_Attlist::TDefinitionURL>(value);
    m_set_State[0] |= 0xc00;
}

inline
CDeclare_Base::C_Attlist::TDefinitionURL& CDeclare_Base::C_Attlist::SetDefinitionURL(void)
{
#ifdef _DEBUG
    if (!IsSetDefinitionURL()) {
        m_DefinitionURL = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_DefinitionURL;
}

inline
CDeclare_Base::C_E_ContExp::C_E_ContExp(void)
{
}

inline
bool CDeclare_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CDeclare_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CDeclare_Base::TAttlist& CDeclare_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CDeclare_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CDeclare_Base::TAttlist& CDeclare_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CDeclare_Base::IsSetContExp(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CDeclare_Base::CanGetContExp(void) const
{
    return true;
}

inline
const CDeclare_Base::TContExp& CDeclare_Base::GetContExp(void) const
{
    return m_ContExp;
}

inline
CDeclare_Base::TContExp& CDeclare_Base::SetContExp(void)
{
    m_set_State[0] |= 0x4;
    return m_ContExp;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_DECLARE_BASE_HPP
