/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file trackmgr_client_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'trackmgr.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_TRACKMGR_TRACKMGR_CLIENT_BASE_HPP
#define OBJECTS_TRACKMGR_TRACKMGR_CLIENT_BASE_HPP

// extra headers
#include <objects/trackmgr/trackmgr_export.h>

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/trackmgr/TMgr_Reply.hpp>
#include <objects/trackmgr/TMgr_Request.hpp>
#include <serial/rpcbase.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_TRACKMGR_EXPORT CTrackMgrClient_Base : public CRPCClient<CTMgr_Request, CTMgr_Reply>
{
    typedef CRPCClient<CTMgr_Request, CTMgr_Reply> Tparent;
public:
    // constructor
    CTrackMgrClient_Base(void);
    // destructor
    virtual ~CTrackMgrClient_Base(void);

    typedef CTMgr_Request TRequest;
    typedef CTMgr_Reply TReply;
    typedef TRequest TRequestChoice;
    typedef TReply TReplyChoice;

    virtual void Ask(const TRequest& request, TReply& reply);
    virtual void Ask(const TRequest& request, TReply& reply,
                     TReplyChoice::E_Choice wanted);

    virtual CRef<CTMgr_DisplayTrackReply> AskDisplay_tracks
        (const CTMgr_DisplayTrackRequest& req, TReply* reply = 0);

    virtual CRef<CTMgr_SwitchTrackContextReply> AskSwitch_display_tracks
        (const CTMgr_SwitchTrackContextRequest& req, TReply* reply = 0);

    virtual CRef<CTMgr_TrackAttrValueReply> AskTrack_attr_values
        (const CTMgr_TrackAttrValueRequest& req, TReply* reply = 0);

    virtual CRef<CTMgr_BlastRIDReply> AskBlast_tracks
        (const CTMgr_BlastRIDRequest& req, TReply* reply = 0);

    virtual CRef<CTMgr_CreateUserTrackReply> AskCreate_user_tracks
        (const CTMgr_CreateUserTrackRequest& req, TReply* reply = 0);

    virtual CRef<CTMgr_CreateRemoteTrackReply> AskCreate_remote_tracks
        (const CTMgr_CreateRemoteTrackRequest& req, TReply* reply = 0);

    virtual CRef<CTMgr_ItemResolverReply> AskResolve_track_items
        (const CTMgr_ItemResolverRequest& req, TReply* reply = 0);

    virtual CRef<CTMgr_RemoveUserTrackReply> AskRemove_user_tracks
        (const CTMgr_RemoveUserTrackRequest& req, TReply* reply = 0);

    virtual CRef<CTMgr_RetrieveTracksetReply> AskRetrieve_tracksets
        (const CTMgr_RetrieveTracksetRequest& req, TReply* reply = 0);

    virtual CRef<CTMgr_CreateTracksetReply> AskCreate_trackset
        (const CTMgr_CreateTracksetRequest& req, TReply* reply = 0);

    virtual CRef<CTMgr_RenameMyNCBICollectionReply> AskRename_trackset
        (const CTMgr_RenameMyNCBICollectionRequest& req, TReply* reply = 0);

    virtual CRef<CTMgr_SupportedAssembliesReply> AskSupported_assemblies
        (const CTMgr_SupportedAssembliesRequest& req, TReply* reply = 0);


private:
    TReplyChoice& x_Choice(TReply& reply);
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CTrackMgrClient_Base::TReplyChoice& CTrackMgrClient_Base::x_Choice(CTrackMgrClient_Base::TReply& reply)
{
    return reply;
}

inline
void CTrackMgrClient_Base::Ask(const CTrackMgrClient_Base::TRequest& request, CTrackMgrClient_Base::TReply& reply)
{
    Tparent::Ask(request, reply);
}


///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_TRACKMGR_TRACKMGR_CLIENT_BASE_HPP
