/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file TMgr_Hub_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'trackmgr.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_TRACKMGR_TMGR_HUB_BASE_HPP
#define OBJECTS_TRACKMGR_TMGR_HUB_BASE_HPP

// extra headers
#include <objects/trackmgr/trackmgr_export.h>

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_TRACKMGR_EXPORT CTMgr_Hub_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTMgr_Hub_Base(void);
    // destructor
    virtual ~CTMgr_Hub_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string THub;
    typedef string TShort_label;
    typedef string TLong_label;
    typedef list< string > TAssembly_db_name;
    typedef string TTrackdb_url;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_hub,
        e_short_label,
        e_long_label,
        e_assembly_db_name,
        e_trackdb_url
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// hub entry from hub.txt file
    /// mandatory
    /// typedef string THub
    ///  Check whether the Hub data member has been assigned a value.
    bool IsSetHub(void) const;
    /// Check whether it is safe or not to call GetHub method.
    bool CanGetHub(void) const;
    void ResetHub(void);
    const THub& GetHub(void) const;
    void SetHub(const THub& value);
    void SetHub(THub&& value);
    THub& SetHub(void);

    /// shortLabel entry from hub.txt file
    /// mandatory
    /// typedef string TShort_label
    ///  Check whether the Short_label data member has been assigned a value.
    bool IsSetShort_label(void) const;
    /// Check whether it is safe or not to call GetShort_label method.
    bool CanGetShort_label(void) const;
    void ResetShort_label(void);
    const TShort_label& GetShort_label(void) const;
    void SetShort_label(const TShort_label& value);
    void SetShort_label(TShort_label&& value);
    TShort_label& SetShort_label(void);

    /// longLabel entry from hub.txt file
    /// mandatory
    /// typedef string TLong_label
    ///  Check whether the Long_label data member has been assigned a value.
    bool IsSetLong_label(void) const;
    /// Check whether it is safe or not to call GetLong_label method.
    bool CanGetLong_label(void) const;
    void ResetLong_label(void);
    const TLong_label& GetLong_label(void) const;
    void SetLong_label(const TLong_label& value);
    void SetLong_label(TLong_label&& value);
    TLong_label& SetLong_label(void);

    ///- genome entries in genomes.txt file
    /// mandatory
    /// typedef list< string > TAssembly_db_name
    ///  Check whether the Assembly_db_name data member has been assigned a value.
    bool IsSetAssembly_db_name(void) const;
    /// Check whether it is safe or not to call GetAssembly_db_name method.
    bool CanGetAssembly_db_name(void) const;
    void ResetAssembly_db_name(void);
    const TAssembly_db_name& GetAssembly_db_name(void) const;
    TAssembly_db_name& SetAssembly_db_name(void);

    ///- trackDb entry in genomes.txt file associated with assembly_acc
    /// optional
    /// typedef string TTrackdb_url
    ///  Check whether the Trackdb_url data member has been assigned a value.
    bool IsSetTrackdb_url(void) const;
    /// Check whether it is safe or not to call GetTrackdb_url method.
    bool CanGetTrackdb_url(void) const;
    void ResetTrackdb_url(void);
    const TTrackdb_url& GetTrackdb_url(void) const;
    void SetTrackdb_url(const TTrackdb_url& value);
    void SetTrackdb_url(TTrackdb_url&& value);
    TTrackdb_url& SetTrackdb_url(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTMgr_Hub_Base(const CTMgr_Hub_Base&);
    CTMgr_Hub_Base& operator=(const CTMgr_Hub_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Hub;
    string m_Short_label;
    string m_Long_label;
    list< string > m_Assembly_db_name;
    string m_Trackdb_url;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTMgr_Hub_Base::IsSetHub(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CTMgr_Hub_Base::CanGetHub(void) const
{
    return IsSetHub();
}

inline
const CTMgr_Hub_Base::THub& CTMgr_Hub_Base::GetHub(void) const
{
    if (!CanGetHub()) {
        ThrowUnassigned(0);
    }
    return m_Hub;
}

inline
void CTMgr_Hub_Base::SetHub(const CTMgr_Hub_Base::THub& value)
{
    m_Hub = value;
    m_set_State[0] |= 0x3;
}

inline
void CTMgr_Hub_Base::SetHub(CTMgr_Hub_Base::THub&& value)
{
    m_Hub = std::forward<CTMgr_Hub_Base::THub>(value);
    m_set_State[0] |= 0x3;
}

inline
CTMgr_Hub_Base::THub& CTMgr_Hub_Base::SetHub(void)
{
#ifdef _DEBUG
    if (!IsSetHub()) {
        m_Hub = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Hub;
}

inline
bool CTMgr_Hub_Base::IsSetShort_label(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CTMgr_Hub_Base::CanGetShort_label(void) const
{
    return IsSetShort_label();
}

inline
const CTMgr_Hub_Base::TShort_label& CTMgr_Hub_Base::GetShort_label(void) const
{
    if (!CanGetShort_label()) {
        ThrowUnassigned(1);
    }
    return m_Short_label;
}

inline
void CTMgr_Hub_Base::SetShort_label(const CTMgr_Hub_Base::TShort_label& value)
{
    m_Short_label = value;
    m_set_State[0] |= 0xc;
}

inline
void CTMgr_Hub_Base::SetShort_label(CTMgr_Hub_Base::TShort_label&& value)
{
    m_Short_label = std::forward<CTMgr_Hub_Base::TShort_label>(value);
    m_set_State[0] |= 0xc;
}

inline
CTMgr_Hub_Base::TShort_label& CTMgr_Hub_Base::SetShort_label(void)
{
#ifdef _DEBUG
    if (!IsSetShort_label()) {
        m_Short_label = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Short_label;
}

inline
bool CTMgr_Hub_Base::IsSetLong_label(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CTMgr_Hub_Base::CanGetLong_label(void) const
{
    return IsSetLong_label();
}

inline
const CTMgr_Hub_Base::TLong_label& CTMgr_Hub_Base::GetLong_label(void) const
{
    if (!CanGetLong_label()) {
        ThrowUnassigned(2);
    }
    return m_Long_label;
}

inline
void CTMgr_Hub_Base::SetLong_label(const CTMgr_Hub_Base::TLong_label& value)
{
    m_Long_label = value;
    m_set_State[0] |= 0x30;
}

inline
void CTMgr_Hub_Base::SetLong_label(CTMgr_Hub_Base::TLong_label&& value)
{
    m_Long_label = std::forward<CTMgr_Hub_Base::TLong_label>(value);
    m_set_State[0] |= 0x30;
}

inline
CTMgr_Hub_Base::TLong_label& CTMgr_Hub_Base::SetLong_label(void)
{
#ifdef _DEBUG
    if (!IsSetLong_label()) {
        m_Long_label = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Long_label;
}

inline
bool CTMgr_Hub_Base::IsSetAssembly_db_name(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CTMgr_Hub_Base::CanGetAssembly_db_name(void) const
{
    return true;
}

inline
const CTMgr_Hub_Base::TAssembly_db_name& CTMgr_Hub_Base::GetAssembly_db_name(void) const
{
    return m_Assembly_db_name;
}

inline
CTMgr_Hub_Base::TAssembly_db_name& CTMgr_Hub_Base::SetAssembly_db_name(void)
{
    m_set_State[0] |= 0x40;
    return m_Assembly_db_name;
}

inline
bool CTMgr_Hub_Base::IsSetTrackdb_url(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CTMgr_Hub_Base::CanGetTrackdb_url(void) const
{
    return IsSetTrackdb_url();
}

inline
const CTMgr_Hub_Base::TTrackdb_url& CTMgr_Hub_Base::GetTrackdb_url(void) const
{
    if (!CanGetTrackdb_url()) {
        ThrowUnassigned(4);
    }
    return m_Trackdb_url;
}

inline
void CTMgr_Hub_Base::SetTrackdb_url(const CTMgr_Hub_Base::TTrackdb_url& value)
{
    m_Trackdb_url = value;
    m_set_State[0] |= 0x300;
}

inline
void CTMgr_Hub_Base::SetTrackdb_url(CTMgr_Hub_Base::TTrackdb_url&& value)
{
    m_Trackdb_url = std::forward<CTMgr_Hub_Base::TTrackdb_url>(value);
    m_set_State[0] |= 0x300;
}

inline
CTMgr_Hub_Base::TTrackdb_url& CTMgr_Hub_Base::SetTrackdb_url(void)
{
#ifdef _DEBUG
    if (!IsSetTrackdb_url()) {
        m_Trackdb_url = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Trackdb_url;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_TRACKMGR_TMGR_HUB_BASE_HPP
