/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Seq_interval_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqloc.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQLOC_SEQ_INTERVAL_BASE_HPP
#define OBJECTS_SEQLOC_SEQ_INTERVAL_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/seqloc/Na_strand.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CInt_fuzz;
class CSeq_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQLOC_EXPORT CSeq_interval_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSeq_interval_Base(void);
    // destructor
    virtual ~CSeq_interval_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef TSeqPos TFrom;
    typedef TSeqPos TTo;
    typedef ENa_strand TStrand;
    typedef CSeq_id TId;
    typedef CInt_fuzz TFuzz_from;
    typedef CInt_fuzz TFuzz_to;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_from,
        e_to,
        e_strand,
        e_id,
        e_fuzz_from,
        e_fuzz_to
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 7> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef TSeqPos TFrom
    ///  Check whether the From data member has been assigned a value.
    bool IsSetFrom(void) const;
    /// Check whether it is safe or not to call GetFrom method.
    bool CanGetFrom(void) const;
    void ResetFrom(void);
    TFrom GetFrom(void) const;
    void SetFrom(TFrom value);
    TFrom& SetFrom(void);

    /// mandatory
    /// typedef TSeqPos TTo
    ///  Check whether the To data member has been assigned a value.
    bool IsSetTo(void) const;
    /// Check whether it is safe or not to call GetTo method.
    bool CanGetTo(void) const;
    void ResetTo(void);
    TTo GetTo(void) const;
    void SetTo(TTo value);
    TTo& SetTo(void);

    /// optional
    /// typedef ENa_strand TStrand
    ///  Check whether the Strand data member has been assigned a value.
    bool IsSetStrand(void) const;
    /// Check whether it is safe or not to call GetStrand method.
    bool CanGetStrand(void) const;
    void ResetStrand(void);
    TStrand GetStrand(void) const;
    void SetStrand(TStrand value);
    TStrand& SetStrand(void);

    /// WARNING: this used to be optional
    /// mandatory
    /// typedef CSeq_id TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(TId& value);
    TId& SetId(void);

    /// optional
    /// typedef CInt_fuzz TFuzz_from
    ///  Check whether the Fuzz_from data member has been assigned a value.
    bool IsSetFuzz_from(void) const;
    /// Check whether it is safe or not to call GetFuzz_from method.
    bool CanGetFuzz_from(void) const;
    void ResetFuzz_from(void);
    const TFuzz_from& GetFuzz_from(void) const;
    void SetFuzz_from(TFuzz_from& value);
    TFuzz_from& SetFuzz_from(void);

    /// optional
    /// typedef CInt_fuzz TFuzz_to
    ///  Check whether the Fuzz_to data member has been assigned a value.
    bool IsSetFuzz_to(void) const;
    /// Check whether it is safe or not to call GetFuzz_to method.
    bool CanGetFuzz_to(void) const;
    void ResetFuzz_to(void);
    const TFuzz_to& GetFuzz_to(void) const;
    void SetFuzz_to(TFuzz_to& value);
    TFuzz_to& SetFuzz_to(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSeq_interval_Base(const CSeq_interval_Base&);
    CSeq_interval_Base& operator=(const CSeq_interval_Base&);

    // data
    Uint4 m_set_State[1];
    TSeqPos m_From;
    TSeqPos m_To;
    ENa_strand m_Strand;
    CRef< TId > m_Id;
    CRef< TFuzz_from > m_Fuzz_from;
    CRef< TFuzz_to > m_Fuzz_to;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSeq_interval_Base::IsSetFrom(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CSeq_interval_Base::CanGetFrom(void) const
{
    return IsSetFrom();
}

inline
void CSeq_interval_Base::ResetFrom(void)
{
    m_From = 0;
    m_set_State[0] &= ~0x3;
}

inline
CSeq_interval_Base::TFrom CSeq_interval_Base::GetFrom(void) const
{
    if (!CanGetFrom()) {
        ThrowUnassigned(0);
    }
    return m_From;
}

inline
void CSeq_interval_Base::SetFrom(CSeq_interval_Base::TFrom value)
{
    m_From = value;
    m_set_State[0] |= 0x3;
}

inline
CSeq_interval_Base::TFrom& CSeq_interval_Base::SetFrom(void)
{
#ifdef _DEBUG
    if (!IsSetFrom()) {
        memset(&m_From,UnassignedByte(),sizeof(m_From));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_From;
}

inline
bool CSeq_interval_Base::IsSetTo(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CSeq_interval_Base::CanGetTo(void) const
{
    return IsSetTo();
}

inline
void CSeq_interval_Base::ResetTo(void)
{
    m_To = 0;
    m_set_State[0] &= ~0xc;
}

inline
CSeq_interval_Base::TTo CSeq_interval_Base::GetTo(void) const
{
    if (!CanGetTo()) {
        ThrowUnassigned(1);
    }
    return m_To;
}

inline
void CSeq_interval_Base::SetTo(CSeq_interval_Base::TTo value)
{
    m_To = value;
    m_set_State[0] |= 0xc;
}

inline
CSeq_interval_Base::TTo& CSeq_interval_Base::SetTo(void)
{
#ifdef _DEBUG
    if (!IsSetTo()) {
        memset(&m_To,UnassignedByte(),sizeof(m_To));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_To;
}

inline
bool CSeq_interval_Base::IsSetStrand(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CSeq_interval_Base::CanGetStrand(void) const
{
    return IsSetStrand();
}

inline
void CSeq_interval_Base::ResetStrand(void)
{
    m_Strand = (ncbi::objects::ENa_strand)(0);
    m_set_State[0] &= ~0x30;
}

inline
CSeq_interval_Base::TStrand CSeq_interval_Base::GetStrand(void) const
{
    if (!CanGetStrand()) {
        ThrowUnassigned(2);
    }
    return m_Strand;
}

inline
void CSeq_interval_Base::SetStrand(CSeq_interval_Base::TStrand value)
{
    m_Strand = value;
    m_set_State[0] |= 0x30;
}

inline
CSeq_interval_Base::TStrand& CSeq_interval_Base::SetStrand(void)
{
#ifdef _DEBUG
    if (!IsSetStrand()) {
        memset(&m_Strand,UnassignedByte(),sizeof(m_Strand));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Strand;
}

inline
bool CSeq_interval_Base::IsSetId(void) const
{
    return m_Id.NotEmpty();
}

inline
bool CSeq_interval_Base::CanGetId(void) const
{
    return true;
}

inline
const CSeq_interval_Base::TId& CSeq_interval_Base::GetId(void) const
{
    if ( !m_Id ) {
        const_cast<CSeq_interval_Base*>(this)->ResetId();
    }
    return (*m_Id);
}

inline
CSeq_interval_Base::TId& CSeq_interval_Base::SetId(void)
{
    if ( !m_Id ) {
        ResetId();
    }
    return (*m_Id);
}

inline
bool CSeq_interval_Base::IsSetFuzz_from(void) const
{
    return m_Fuzz_from.NotEmpty();
}

inline
bool CSeq_interval_Base::CanGetFuzz_from(void) const
{
    return IsSetFuzz_from();
}

inline
const CSeq_interval_Base::TFuzz_from& CSeq_interval_Base::GetFuzz_from(void) const
{
    if (!CanGetFuzz_from()) {
        ThrowUnassigned(4);
    }
    return (*m_Fuzz_from);
}

inline
bool CSeq_interval_Base::IsSetFuzz_to(void) const
{
    return m_Fuzz_to.NotEmpty();
}

inline
bool CSeq_interval_Base::CanGetFuzz_to(void) const
{
    return IsSetFuzz_to();
}

inline
const CSeq_interval_Base::TFuzz_to& CSeq_interval_Base::GetFuzz_to(void) const
{
    if (!CanGetFuzz_to()) {
        ThrowUnassigned(5);
    }
    return (*m_Fuzz_to);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQLOC_SEQ_INTERVAL_BASE_HPP
