/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file SeqFeatSupport_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqfeat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQFEAT_SEQFEATSUPPORT_BASE_HPP
#define OBJECTS_SEQFEAT_SEQFEATSUPPORT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CExperimentSupport;
class CInferenceSupport;
class CModelEvidenceSupport;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQFEAT_EXPORT CSeqFeatSupport_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSeqFeatSupport_Base(void);
    // destructor
    virtual ~CSeqFeatSupport_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef list< CRef< CExperimentSupport > > TExperiment;
    typedef list< CRef< CInferenceSupport > > TInference;
    typedef list< CRef< CModelEvidenceSupport > > TModel_evidence;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_experiment,
        e_inference,
        e_model_evidence
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef list< CRef< CExperimentSupport > > TExperiment
    ///  Check whether the Experiment data member has been assigned a value.
    bool IsSetExperiment(void) const;
    /// Check whether it is safe or not to call GetExperiment method.
    bool CanGetExperiment(void) const;
    void ResetExperiment(void);
    const TExperiment& GetExperiment(void) const;
    TExperiment& SetExperiment(void);

    /// optional
    /// typedef list< CRef< CInferenceSupport > > TInference
    ///  Check whether the Inference data member has been assigned a value.
    bool IsSetInference(void) const;
    /// Check whether it is safe or not to call GetInference method.
    bool CanGetInference(void) const;
    void ResetInference(void);
    const TInference& GetInference(void) const;
    TInference& SetInference(void);

    /// optional
    /// typedef list< CRef< CModelEvidenceSupport > > TModel_evidence
    ///  Check whether the Model_evidence data member has been assigned a value.
    bool IsSetModel_evidence(void) const;
    /// Check whether it is safe or not to call GetModel_evidence method.
    bool CanGetModel_evidence(void) const;
    void ResetModel_evidence(void);
    const TModel_evidence& GetModel_evidence(void) const;
    TModel_evidence& SetModel_evidence(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSeqFeatSupport_Base(const CSeqFeatSupport_Base&);
    CSeqFeatSupport_Base& operator=(const CSeqFeatSupport_Base&);

    // data
    Uint4 m_set_State[1];
    list< CRef< CExperimentSupport > > m_Experiment;
    list< CRef< CInferenceSupport > > m_Inference;
    list< CRef< CModelEvidenceSupport > > m_Model_evidence;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSeqFeatSupport_Base::IsSetExperiment(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CSeqFeatSupport_Base::CanGetExperiment(void) const
{
    return true;
}

inline
const CSeqFeatSupport_Base::TExperiment& CSeqFeatSupport_Base::GetExperiment(void) const
{
    return m_Experiment;
}

inline
CSeqFeatSupport_Base::TExperiment& CSeqFeatSupport_Base::SetExperiment(void)
{
    m_set_State[0] |= 0x1;
    return m_Experiment;
}

inline
bool CSeqFeatSupport_Base::IsSetInference(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CSeqFeatSupport_Base::CanGetInference(void) const
{
    return true;
}

inline
const CSeqFeatSupport_Base::TInference& CSeqFeatSupport_Base::GetInference(void) const
{
    return m_Inference;
}

inline
CSeqFeatSupport_Base::TInference& CSeqFeatSupport_Base::SetInference(void)
{
    m_set_State[0] |= 0x4;
    return m_Inference;
}

inline
bool CSeqFeatSupport_Base::IsSetModel_evidence(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CSeqFeatSupport_Base::CanGetModel_evidence(void) const
{
    return true;
}

inline
const CSeqFeatSupport_Base::TModel_evidence& CSeqFeatSupport_Base::GetModel_evidence(void) const
{
    return m_Model_evidence;
}

inline
CSeqFeatSupport_Base::TModel_evidence& CSeqFeatSupport_Base::SetModel_evidence(void)
{
    m_set_State[0] |= 0x10;
    return m_Model_evidence;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQFEAT_SEQFEATSUPPORT_BASE_HPP
