/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Population_data_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqfeat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQFEAT_POPULATION_DATA_BASE_HPP
#define OBJECTS_SEQFEAT_POPULATION_DATA_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CObject_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQFEAT_EXPORT CPopulation_data_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPopulation_data_Base(void);
    // destructor
    virtual ~CPopulation_data_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /// This field is an explicit bit-field
    /// Valid values should be a bitwise combination (= simple sum)
    /// of any of the values below
    enum EFlags {
        eFlags_is_default_population = 1,
        eFlags_is_minor_allele       = 2,
        eFlags_is_rare_allele        = 4
    };
    
    /// Access to EFlags's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EFlags)(void);
    
    // types
    typedef string TPopulation;
    typedef double TGenotype_frequency;
    typedef int TChromosomes_tested;
    typedef list< CRef< CObject_id > > TSample_ids;
    typedef double TAllele_frequency;
    typedef int TFlags;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_population,
        e_genotype_frequency,
        e_chromosomes_tested,
        e_sample_ids,
        e_allele_frequency,
        e_flags
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 7> TmemberIndex;

    // getters
    // setters

    /// assayed population (e.g. HAPMAP-CEU)
    /// mandatory
    /// typedef string TPopulation
    ///  Check whether the Population data member has been assigned a value.
    bool IsSetPopulation(void) const;
    /// Check whether it is safe or not to call GetPopulation method.
    bool CanGetPopulation(void) const;
    void ResetPopulation(void);
    const TPopulation& GetPopulation(void) const;
    void SetPopulation(const TPopulation& value);
    void SetPopulation(TPopulation&& value);
    TPopulation& SetPopulation(void);

    /// optional
    /// typedef double TGenotype_frequency
    ///  Check whether the Genotype_frequency data member has been assigned a value.
    bool IsSetGenotype_frequency(void) const;
    /// Check whether it is safe or not to call GetGenotype_frequency method.
    bool CanGetGenotype_frequency(void) const;
    void ResetGenotype_frequency(void);
    TGenotype_frequency GetGenotype_frequency(void) const;
    void SetGenotype_frequency(TGenotype_frequency value);
    TGenotype_frequency& SetGenotype_frequency(void);

    /// optional
    /// typedef int TChromosomes_tested
    ///  Check whether the Chromosomes_tested data member has been assigned a value.
    bool IsSetChromosomes_tested(void) const;
    /// Check whether it is safe or not to call GetChromosomes_tested method.
    bool CanGetChromosomes_tested(void) const;
    void ResetChromosomes_tested(void);
    TChromosomes_tested GetChromosomes_tested(void) const;
    void SetChromosomes_tested(TChromosomes_tested value);
    TChromosomes_tested& SetChromosomes_tested(void);

    /// optional
    /// typedef list< CRef< CObject_id > > TSample_ids
    ///  Check whether the Sample_ids data member has been assigned a value.
    bool IsSetSample_ids(void) const;
    /// Check whether it is safe or not to call GetSample_ids method.
    bool CanGetSample_ids(void) const;
    void ResetSample_ids(void);
    const TSample_ids& GetSample_ids(void) const;
    TSample_ids& SetSample_ids(void);

    /// optional
    /// typedef double TAllele_frequency
    ///  Check whether the Allele_frequency data member has been assigned a value.
    bool IsSetAllele_frequency(void) const;
    /// Check whether it is safe or not to call GetAllele_frequency method.
    bool CanGetAllele_frequency(void) const;
    void ResetAllele_frequency(void);
    TAllele_frequency GetAllele_frequency(void) const;
    void SetAllele_frequency(TAllele_frequency value);
    TAllele_frequency& SetAllele_frequency(void);

    /// optional
    /// typedef int TFlags
    ///  Check whether the Flags data member has been assigned a value.
    bool IsSetFlags(void) const;
    /// Check whether it is safe or not to call GetFlags method.
    bool CanGetFlags(void) const;
    void ResetFlags(void);
    TFlags GetFlags(void) const;
    void SetFlags(TFlags value);
    TFlags& SetFlags(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPopulation_data_Base(const CPopulation_data_Base&);
    CPopulation_data_Base& operator=(const CPopulation_data_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Population;
    double m_Genotype_frequency;
    int m_Chromosomes_tested;
    list< CRef< CObject_id > > m_Sample_ids;
    double m_Allele_frequency;
    int m_Flags;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPopulation_data_Base::IsSetPopulation(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPopulation_data_Base::CanGetPopulation(void) const
{
    return IsSetPopulation();
}

inline
const CPopulation_data_Base::TPopulation& CPopulation_data_Base::GetPopulation(void) const
{
    if (!CanGetPopulation()) {
        ThrowUnassigned(0);
    }
    return m_Population;
}

inline
void CPopulation_data_Base::SetPopulation(const CPopulation_data_Base::TPopulation& value)
{
    m_Population = value;
    m_set_State[0] |= 0x3;
}

inline
void CPopulation_data_Base::SetPopulation(CPopulation_data_Base::TPopulation&& value)
{
    m_Population = std::forward<CPopulation_data_Base::TPopulation>(value);
    m_set_State[0] |= 0x3;
}

inline
CPopulation_data_Base::TPopulation& CPopulation_data_Base::SetPopulation(void)
{
#ifdef _DEBUG
    if (!IsSetPopulation()) {
        m_Population = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Population;
}

inline
bool CPopulation_data_Base::IsSetGenotype_frequency(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPopulation_data_Base::CanGetGenotype_frequency(void) const
{
    return IsSetGenotype_frequency();
}

inline
void CPopulation_data_Base::ResetGenotype_frequency(void)
{
    m_Genotype_frequency = 0;
    m_set_State[0] &= ~0xc;
}

inline
CPopulation_data_Base::TGenotype_frequency CPopulation_data_Base::GetGenotype_frequency(void) const
{
    if (!CanGetGenotype_frequency()) {
        ThrowUnassigned(1);
    }
    return m_Genotype_frequency;
}

inline
void CPopulation_data_Base::SetGenotype_frequency(CPopulation_data_Base::TGenotype_frequency value)
{
    m_Genotype_frequency = value;
    m_set_State[0] |= 0xc;
}

inline
CPopulation_data_Base::TGenotype_frequency& CPopulation_data_Base::SetGenotype_frequency(void)
{
#ifdef _DEBUG
    if (!IsSetGenotype_frequency()) {
        memset(&m_Genotype_frequency,UnassignedByte(),sizeof(m_Genotype_frequency));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Genotype_frequency;
}

inline
bool CPopulation_data_Base::IsSetChromosomes_tested(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CPopulation_data_Base::CanGetChromosomes_tested(void) const
{
    return IsSetChromosomes_tested();
}

inline
void CPopulation_data_Base::ResetChromosomes_tested(void)
{
    m_Chromosomes_tested = 0;
    m_set_State[0] &= ~0x30;
}

inline
CPopulation_data_Base::TChromosomes_tested CPopulation_data_Base::GetChromosomes_tested(void) const
{
    if (!CanGetChromosomes_tested()) {
        ThrowUnassigned(2);
    }
    return m_Chromosomes_tested;
}

inline
void CPopulation_data_Base::SetChromosomes_tested(CPopulation_data_Base::TChromosomes_tested value)
{
    m_Chromosomes_tested = value;
    m_set_State[0] |= 0x30;
}

inline
CPopulation_data_Base::TChromosomes_tested& CPopulation_data_Base::SetChromosomes_tested(void)
{
#ifdef _DEBUG
    if (!IsSetChromosomes_tested()) {
        memset(&m_Chromosomes_tested,UnassignedByte(),sizeof(m_Chromosomes_tested));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Chromosomes_tested;
}

inline
bool CPopulation_data_Base::IsSetSample_ids(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CPopulation_data_Base::CanGetSample_ids(void) const
{
    return true;
}

inline
const CPopulation_data_Base::TSample_ids& CPopulation_data_Base::GetSample_ids(void) const
{
    return m_Sample_ids;
}

inline
CPopulation_data_Base::TSample_ids& CPopulation_data_Base::SetSample_ids(void)
{
    m_set_State[0] |= 0x40;
    return m_Sample_ids;
}

inline
bool CPopulation_data_Base::IsSetAllele_frequency(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CPopulation_data_Base::CanGetAllele_frequency(void) const
{
    return IsSetAllele_frequency();
}

inline
void CPopulation_data_Base::ResetAllele_frequency(void)
{
    m_Allele_frequency = 0;
    m_set_State[0] &= ~0x300;
}

inline
CPopulation_data_Base::TAllele_frequency CPopulation_data_Base::GetAllele_frequency(void) const
{
    if (!CanGetAllele_frequency()) {
        ThrowUnassigned(4);
    }
    return m_Allele_frequency;
}

inline
void CPopulation_data_Base::SetAllele_frequency(CPopulation_data_Base::TAllele_frequency value)
{
    m_Allele_frequency = value;
    m_set_State[0] |= 0x300;
}

inline
CPopulation_data_Base::TAllele_frequency& CPopulation_data_Base::SetAllele_frequency(void)
{
#ifdef _DEBUG
    if (!IsSetAllele_frequency()) {
        memset(&m_Allele_frequency,UnassignedByte(),sizeof(m_Allele_frequency));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Allele_frequency;
}

inline
bool CPopulation_data_Base::IsSetFlags(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CPopulation_data_Base::CanGetFlags(void) const
{
    return IsSetFlags();
}

inline
void CPopulation_data_Base::ResetFlags(void)
{
    m_Flags = (EFlags)(0);
    m_set_State[0] &= ~0xc00;
}

inline
CPopulation_data_Base::TFlags CPopulation_data_Base::GetFlags(void) const
{
    if (!CanGetFlags()) {
        ThrowUnassigned(5);
    }
    return m_Flags;
}

inline
void CPopulation_data_Base::SetFlags(CPopulation_data_Base::TFlags value)
{
    m_Flags = value;
    m_set_State[0] |= 0xc00;
}

inline
CPopulation_data_Base::TFlags& CPopulation_data_Base::SetFlags(void)
{
#ifdef _DEBUG
    if (!IsSetFlags()) {
        memset(&m_Flags,UnassignedByte(),sizeof(m_Flags));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Flags;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQFEAT_POPULATION_DATA_BASE_HPP
