/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PIR_block_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqblock.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQBLOCK_PIR_BLOCK_BASE_HPP
#define OBJECTS_SEQBLOCK_PIR_BLOCK_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSeq_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// PIR specific descriptions
class NCBI_SEQBLOCK_EXPORT CPIR_block_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPIR_block_Base(void);
    // destructor
    virtual ~CPIR_block_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef bool THad_punct;
    typedef string THost;
    typedef string TSource;
    typedef string TSummary;
    typedef string TGenetic;
    typedef string TIncludes;
    typedef string TPlacement;
    typedef string TSuperfamily;
    typedef list< string > TKeywords;
    typedef string TCross_reference;
    typedef string TDate;
    typedef string TSeq_raw;
    typedef list< CRef< CSeq_id > > TSeqref;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_had_punct,
        e_host,
        e_source,
        e_summary,
        e_genetic,
        e_includes,
        e_placement,
        e_superfamily,
        e_keywords,
        e_cross_reference,
        e_date,
        e_seq_raw,
        e_seqref
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 14> TmemberIndex;

    // getters
    // setters

    /// had punctuation in sequence ?
    /// optional
    /// typedef bool THad_punct
    ///  Check whether the Had_punct data member has been assigned a value.
    bool IsSetHad_punct(void) const;
    /// Check whether it is safe or not to call GetHad_punct method.
    bool CanGetHad_punct(void) const;
    void ResetHad_punct(void);
    THad_punct GetHad_punct(void) const;
    void SetHad_punct(THad_punct value);
    THad_punct& SetHad_punct(void);

    /// optional
    /// typedef string THost
    ///  Check whether the Host data member has been assigned a value.
    bool IsSetHost(void) const;
    /// Check whether it is safe or not to call GetHost method.
    bool CanGetHost(void) const;
    void ResetHost(void);
    const THost& GetHost(void) const;
    void SetHost(const THost& value);
    void SetHost(THost&& value);
    THost& SetHost(void);

    /// source line
    /// optional
    /// typedef string TSource
    ///  Check whether the Source data member has been assigned a value.
    bool IsSetSource(void) const;
    /// Check whether it is safe or not to call GetSource method.
    bool CanGetSource(void) const;
    void ResetSource(void);
    const TSource& GetSource(void) const;
    void SetSource(const TSource& value);
    void SetSource(TSource&& value);
    TSource& SetSource(void);

    /// optional
    /// typedef string TSummary
    ///  Check whether the Summary data member has been assigned a value.
    bool IsSetSummary(void) const;
    /// Check whether it is safe or not to call GetSummary method.
    bool CanGetSummary(void) const;
    void ResetSummary(void);
    const TSummary& GetSummary(void) const;
    void SetSummary(const TSummary& value);
    void SetSummary(TSummary&& value);
    TSummary& SetSummary(void);

    /// optional
    /// typedef string TGenetic
    ///  Check whether the Genetic data member has been assigned a value.
    bool IsSetGenetic(void) const;
    /// Check whether it is safe or not to call GetGenetic method.
    bool CanGetGenetic(void) const;
    void ResetGenetic(void);
    const TGenetic& GetGenetic(void) const;
    void SetGenetic(const TGenetic& value);
    void SetGenetic(TGenetic&& value);
    TGenetic& SetGenetic(void);

    /// optional
    /// typedef string TIncludes
    ///  Check whether the Includes data member has been assigned a value.
    bool IsSetIncludes(void) const;
    /// Check whether it is safe or not to call GetIncludes method.
    bool CanGetIncludes(void) const;
    void ResetIncludes(void);
    const TIncludes& GetIncludes(void) const;
    void SetIncludes(const TIncludes& value);
    void SetIncludes(TIncludes&& value);
    TIncludes& SetIncludes(void);

    /// optional
    /// typedef string TPlacement
    ///  Check whether the Placement data member has been assigned a value.
    bool IsSetPlacement(void) const;
    /// Check whether it is safe or not to call GetPlacement method.
    bool CanGetPlacement(void) const;
    void ResetPlacement(void);
    const TPlacement& GetPlacement(void) const;
    void SetPlacement(const TPlacement& value);
    void SetPlacement(TPlacement&& value);
    TPlacement& SetPlacement(void);

    /// optional
    /// typedef string TSuperfamily
    ///  Check whether the Superfamily data member has been assigned a value.
    bool IsSetSuperfamily(void) const;
    /// Check whether it is safe or not to call GetSuperfamily method.
    bool CanGetSuperfamily(void) const;
    void ResetSuperfamily(void);
    const TSuperfamily& GetSuperfamily(void) const;
    void SetSuperfamily(const TSuperfamily& value);
    void SetSuperfamily(TSuperfamily&& value);
    TSuperfamily& SetSuperfamily(void);

    /// optional
    /// typedef list< string > TKeywords
    ///  Check whether the Keywords data member has been assigned a value.
    bool IsSetKeywords(void) const;
    /// Check whether it is safe or not to call GetKeywords method.
    bool CanGetKeywords(void) const;
    void ResetKeywords(void);
    const TKeywords& GetKeywords(void) const;
    TKeywords& SetKeywords(void);

    /// optional
    /// typedef string TCross_reference
    ///  Check whether the Cross_reference data member has been assigned a value.
    bool IsSetCross_reference(void) const;
    /// Check whether it is safe or not to call GetCross_reference method.
    bool CanGetCross_reference(void) const;
    void ResetCross_reference(void);
    const TCross_reference& GetCross_reference(void) const;
    void SetCross_reference(const TCross_reference& value);
    void SetCross_reference(TCross_reference&& value);
    TCross_reference& SetCross_reference(void);

    /// optional
    /// typedef string TDate
    ///  Check whether the Date data member has been assigned a value.
    bool IsSetDate(void) const;
    /// Check whether it is safe or not to call GetDate method.
    bool CanGetDate(void) const;
    void ResetDate(void);
    const TDate& GetDate(void) const;
    void SetDate(const TDate& value);
    void SetDate(TDate&& value);
    TDate& SetDate(void);

    /// seq with punctuation
    /// optional
    /// typedef string TSeq_raw
    ///  Check whether the Seq_raw data member has been assigned a value.
    bool IsSetSeq_raw(void) const;
    /// Check whether it is safe or not to call GetSeq_raw method.
    bool CanGetSeq_raw(void) const;
    void ResetSeq_raw(void);
    const TSeq_raw& GetSeq_raw(void) const;
    void SetSeq_raw(const TSeq_raw& value);
    void SetSeq_raw(TSeq_raw&& value);
    TSeq_raw& SetSeq_raw(void);

    /// xref to other sequences
    /// optional
    /// typedef list< CRef< CSeq_id > > TSeqref
    ///  Check whether the Seqref data member has been assigned a value.
    bool IsSetSeqref(void) const;
    /// Check whether it is safe or not to call GetSeqref method.
    bool CanGetSeqref(void) const;
    void ResetSeqref(void);
    const TSeqref& GetSeqref(void) const;
    TSeqref& SetSeqref(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPIR_block_Base(const CPIR_block_Base&);
    CPIR_block_Base& operator=(const CPIR_block_Base&);

    // data
    Uint4 m_set_State[1];
    bool m_Had_punct;
    string m_Host;
    string m_Source;
    string m_Summary;
    string m_Genetic;
    string m_Includes;
    string m_Placement;
    string m_Superfamily;
    list< string > m_Keywords;
    string m_Cross_reference;
    string m_Date;
    string m_Seq_raw;
    list< CRef< CSeq_id > > m_Seqref;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPIR_block_Base::IsSetHad_punct(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPIR_block_Base::CanGetHad_punct(void) const
{
    return IsSetHad_punct();
}

inline
void CPIR_block_Base::ResetHad_punct(void)
{
    m_Had_punct = 0;
    m_set_State[0] &= ~0x3;
}

inline
CPIR_block_Base::THad_punct CPIR_block_Base::GetHad_punct(void) const
{
    if (!CanGetHad_punct()) {
        ThrowUnassigned(0);
    }
    return m_Had_punct;
}

inline
void CPIR_block_Base::SetHad_punct(CPIR_block_Base::THad_punct value)
{
    m_Had_punct = value;
    m_set_State[0] |= 0x3;
}

inline
CPIR_block_Base::THad_punct& CPIR_block_Base::SetHad_punct(void)
{
#ifdef _DEBUG
    if (!IsSetHad_punct()) {
        memset(&m_Had_punct,UnassignedByte(),sizeof(m_Had_punct));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Had_punct;
}

inline
bool CPIR_block_Base::IsSetHost(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPIR_block_Base::CanGetHost(void) const
{
    return IsSetHost();
}

inline
const CPIR_block_Base::THost& CPIR_block_Base::GetHost(void) const
{
    if (!CanGetHost()) {
        ThrowUnassigned(1);
    }
    return m_Host;
}

inline
void CPIR_block_Base::SetHost(const CPIR_block_Base::THost& value)
{
    m_Host = value;
    m_set_State[0] |= 0xc;
}

inline
void CPIR_block_Base::SetHost(CPIR_block_Base::THost&& value)
{
    m_Host = std::forward<CPIR_block_Base::THost>(value);
    m_set_State[0] |= 0xc;
}

inline
CPIR_block_Base::THost& CPIR_block_Base::SetHost(void)
{
#ifdef _DEBUG
    if (!IsSetHost()) {
        m_Host = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Host;
}

inline
bool CPIR_block_Base::IsSetSource(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CPIR_block_Base::CanGetSource(void) const
{
    return IsSetSource();
}

inline
const CPIR_block_Base::TSource& CPIR_block_Base::GetSource(void) const
{
    if (!CanGetSource()) {
        ThrowUnassigned(2);
    }
    return m_Source;
}

inline
void CPIR_block_Base::SetSource(const CPIR_block_Base::TSource& value)
{
    m_Source = value;
    m_set_State[0] |= 0x30;
}

inline
void CPIR_block_Base::SetSource(CPIR_block_Base::TSource&& value)
{
    m_Source = std::forward<CPIR_block_Base::TSource>(value);
    m_set_State[0] |= 0x30;
}

inline
CPIR_block_Base::TSource& CPIR_block_Base::SetSource(void)
{
#ifdef _DEBUG
    if (!IsSetSource()) {
        m_Source = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Source;
}

inline
bool CPIR_block_Base::IsSetSummary(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CPIR_block_Base::CanGetSummary(void) const
{
    return IsSetSummary();
}

inline
const CPIR_block_Base::TSummary& CPIR_block_Base::GetSummary(void) const
{
    if (!CanGetSummary()) {
        ThrowUnassigned(3);
    }
    return m_Summary;
}

inline
void CPIR_block_Base::SetSummary(const CPIR_block_Base::TSummary& value)
{
    m_Summary = value;
    m_set_State[0] |= 0xc0;
}

inline
void CPIR_block_Base::SetSummary(CPIR_block_Base::TSummary&& value)
{
    m_Summary = std::forward<CPIR_block_Base::TSummary>(value);
    m_set_State[0] |= 0xc0;
}

inline
CPIR_block_Base::TSummary& CPIR_block_Base::SetSummary(void)
{
#ifdef _DEBUG
    if (!IsSetSummary()) {
        m_Summary = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Summary;
}

inline
bool CPIR_block_Base::IsSetGenetic(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CPIR_block_Base::CanGetGenetic(void) const
{
    return IsSetGenetic();
}

inline
const CPIR_block_Base::TGenetic& CPIR_block_Base::GetGenetic(void) const
{
    if (!CanGetGenetic()) {
        ThrowUnassigned(4);
    }
    return m_Genetic;
}

inline
void CPIR_block_Base::SetGenetic(const CPIR_block_Base::TGenetic& value)
{
    m_Genetic = value;
    m_set_State[0] |= 0x300;
}

inline
void CPIR_block_Base::SetGenetic(CPIR_block_Base::TGenetic&& value)
{
    m_Genetic = std::forward<CPIR_block_Base::TGenetic>(value);
    m_set_State[0] |= 0x300;
}

inline
CPIR_block_Base::TGenetic& CPIR_block_Base::SetGenetic(void)
{
#ifdef _DEBUG
    if (!IsSetGenetic()) {
        m_Genetic = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Genetic;
}

inline
bool CPIR_block_Base::IsSetIncludes(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CPIR_block_Base::CanGetIncludes(void) const
{
    return IsSetIncludes();
}

inline
const CPIR_block_Base::TIncludes& CPIR_block_Base::GetIncludes(void) const
{
    if (!CanGetIncludes()) {
        ThrowUnassigned(5);
    }
    return m_Includes;
}

inline
void CPIR_block_Base::SetIncludes(const CPIR_block_Base::TIncludes& value)
{
    m_Includes = value;
    m_set_State[0] |= 0xc00;
}

inline
void CPIR_block_Base::SetIncludes(CPIR_block_Base::TIncludes&& value)
{
    m_Includes = std::forward<CPIR_block_Base::TIncludes>(value);
    m_set_State[0] |= 0xc00;
}

inline
CPIR_block_Base::TIncludes& CPIR_block_Base::SetIncludes(void)
{
#ifdef _DEBUG
    if (!IsSetIncludes()) {
        m_Includes = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Includes;
}

inline
bool CPIR_block_Base::IsSetPlacement(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CPIR_block_Base::CanGetPlacement(void) const
{
    return IsSetPlacement();
}

inline
const CPIR_block_Base::TPlacement& CPIR_block_Base::GetPlacement(void) const
{
    if (!CanGetPlacement()) {
        ThrowUnassigned(6);
    }
    return m_Placement;
}

inline
void CPIR_block_Base::SetPlacement(const CPIR_block_Base::TPlacement& value)
{
    m_Placement = value;
    m_set_State[0] |= 0x3000;
}

inline
void CPIR_block_Base::SetPlacement(CPIR_block_Base::TPlacement&& value)
{
    m_Placement = std::forward<CPIR_block_Base::TPlacement>(value);
    m_set_State[0] |= 0x3000;
}

inline
CPIR_block_Base::TPlacement& CPIR_block_Base::SetPlacement(void)
{
#ifdef _DEBUG
    if (!IsSetPlacement()) {
        m_Placement = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Placement;
}

inline
bool CPIR_block_Base::IsSetSuperfamily(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CPIR_block_Base::CanGetSuperfamily(void) const
{
    return IsSetSuperfamily();
}

inline
const CPIR_block_Base::TSuperfamily& CPIR_block_Base::GetSuperfamily(void) const
{
    if (!CanGetSuperfamily()) {
        ThrowUnassigned(7);
    }
    return m_Superfamily;
}

inline
void CPIR_block_Base::SetSuperfamily(const CPIR_block_Base::TSuperfamily& value)
{
    m_Superfamily = value;
    m_set_State[0] |= 0xc000;
}

inline
void CPIR_block_Base::SetSuperfamily(CPIR_block_Base::TSuperfamily&& value)
{
    m_Superfamily = std::forward<CPIR_block_Base::TSuperfamily>(value);
    m_set_State[0] |= 0xc000;
}

inline
CPIR_block_Base::TSuperfamily& CPIR_block_Base::SetSuperfamily(void)
{
#ifdef _DEBUG
    if (!IsSetSuperfamily()) {
        m_Superfamily = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Superfamily;
}

inline
bool CPIR_block_Base::IsSetKeywords(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CPIR_block_Base::CanGetKeywords(void) const
{
    return true;
}

inline
const CPIR_block_Base::TKeywords& CPIR_block_Base::GetKeywords(void) const
{
    return m_Keywords;
}

inline
CPIR_block_Base::TKeywords& CPIR_block_Base::SetKeywords(void)
{
    m_set_State[0] |= 0x10000;
    return m_Keywords;
}

inline
bool CPIR_block_Base::IsSetCross_reference(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CPIR_block_Base::CanGetCross_reference(void) const
{
    return IsSetCross_reference();
}

inline
const CPIR_block_Base::TCross_reference& CPIR_block_Base::GetCross_reference(void) const
{
    if (!CanGetCross_reference()) {
        ThrowUnassigned(9);
    }
    return m_Cross_reference;
}

inline
void CPIR_block_Base::SetCross_reference(const CPIR_block_Base::TCross_reference& value)
{
    m_Cross_reference = value;
    m_set_State[0] |= 0xc0000;
}

inline
void CPIR_block_Base::SetCross_reference(CPIR_block_Base::TCross_reference&& value)
{
    m_Cross_reference = std::forward<CPIR_block_Base::TCross_reference>(value);
    m_set_State[0] |= 0xc0000;
}

inline
CPIR_block_Base::TCross_reference& CPIR_block_Base::SetCross_reference(void)
{
#ifdef _DEBUG
    if (!IsSetCross_reference()) {
        m_Cross_reference = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Cross_reference;
}

inline
bool CPIR_block_Base::IsSetDate(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CPIR_block_Base::CanGetDate(void) const
{
    return IsSetDate();
}

inline
const CPIR_block_Base::TDate& CPIR_block_Base::GetDate(void) const
{
    if (!CanGetDate()) {
        ThrowUnassigned(10);
    }
    return m_Date;
}

inline
void CPIR_block_Base::SetDate(const CPIR_block_Base::TDate& value)
{
    m_Date = value;
    m_set_State[0] |= 0x300000;
}

inline
void CPIR_block_Base::SetDate(CPIR_block_Base::TDate&& value)
{
    m_Date = std::forward<CPIR_block_Base::TDate>(value);
    m_set_State[0] |= 0x300000;
}

inline
CPIR_block_Base::TDate& CPIR_block_Base::SetDate(void)
{
#ifdef _DEBUG
    if (!IsSetDate()) {
        m_Date = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100000;
    return m_Date;
}

inline
bool CPIR_block_Base::IsSetSeq_raw(void) const
{
    return ((m_set_State[0] & 0xc00000) != 0);
}

inline
bool CPIR_block_Base::CanGetSeq_raw(void) const
{
    return IsSetSeq_raw();
}

inline
const CPIR_block_Base::TSeq_raw& CPIR_block_Base::GetSeq_raw(void) const
{
    if (!CanGetSeq_raw()) {
        ThrowUnassigned(11);
    }
    return m_Seq_raw;
}

inline
void CPIR_block_Base::SetSeq_raw(const CPIR_block_Base::TSeq_raw& value)
{
    m_Seq_raw = value;
    m_set_State[0] |= 0xc00000;
}

inline
void CPIR_block_Base::SetSeq_raw(CPIR_block_Base::TSeq_raw&& value)
{
    m_Seq_raw = std::forward<CPIR_block_Base::TSeq_raw>(value);
    m_set_State[0] |= 0xc00000;
}

inline
CPIR_block_Base::TSeq_raw& CPIR_block_Base::SetSeq_raw(void)
{
#ifdef _DEBUG
    if (!IsSetSeq_raw()) {
        m_Seq_raw = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400000;
    return m_Seq_raw;
}

inline
bool CPIR_block_Base::IsSetSeqref(void) const
{
    return ((m_set_State[0] & 0x3000000) != 0);
}

inline
bool CPIR_block_Base::CanGetSeqref(void) const
{
    return true;
}

inline
const CPIR_block_Base::TSeqref& CPIR_block_Base::GetSeqref(void) const
{
    return m_Seqref;
}

inline
CPIR_block_Base::TSeqref& CPIR_block_Base::SetSeqref(void)
{
    m_set_State[0] |= 0x1000000;
    return m_Seqref;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQBLOCK_PIR_BLOCK_BASE_HPP
