/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file GIBB_mod_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seq.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQ_GIBB_MOD_BASE_HPP
#define OBJECTS_SEQ_GIBB_MOD_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/// GenInfo Backbone modifiers
enum EGIBB_mod {
    eGIBB_mod_dna           =   0,
    eGIBB_mod_rna           =   1,
    eGIBB_mod_extrachrom    =   2,
    eGIBB_mod_plasmid       =   3,
    eGIBB_mod_mitochondrial =   4,
    eGIBB_mod_chloroplast   =   5,
    eGIBB_mod_kinetoplast   =   6,
    eGIBB_mod_cyanelle      =   7,
    eGIBB_mod_synthetic     =   8,
    eGIBB_mod_recombinant   =   9,
    eGIBB_mod_partial       =  10,
    eGIBB_mod_complete      =  11,
    eGIBB_mod_mutagen       =  12,  ///< subject of mutagenesis ?
    eGIBB_mod_natmut        =  13,  ///< natural mutant ?
    eGIBB_mod_transposon    =  14,
    eGIBB_mod_insertion_seq =  15,
    eGIBB_mod_no_left       =  16,  ///< missing left end (5' for na, NH2 for aa)
    eGIBB_mod_no_right      =  17,  ///< missing right end (3' or COOH)
    eGIBB_mod_macronuclear  =  18,
    eGIBB_mod_proviral      =  19,
    eGIBB_mod_est           =  20,  ///< expressed sequence tag
    eGIBB_mod_sts           =  21,  ///< sequence tagged site
    eGIBB_mod_survey        =  22,  ///< one pass survey sequence
    eGIBB_mod_chromoplast   =  23,
    eGIBB_mod_genemap       =  24,  ///< is a genetic map
    eGIBB_mod_restmap       =  25,  ///< is an ordered restriction map
    eGIBB_mod_physmap       =  26,  ///< is a physical map (not ordered restriction map)
    eGIBB_mod_other         = 255
};

/// Access to EGIBB_mod's attributes (values, names) as defined in spec
NCBI_SEQ_EXPORT const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EGIBB_mod)(void);


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQ_GIBB_MOD_BASE_HPP
