/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Remap_request_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'remap.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_REMAP_REMAP_REQUEST_BASE_HPP
#define OBJECTS_REMAP_REMAP_REQUEST_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CRMRequest;


// generated classes

/////////////////////////////////////////////////////////////////////////////
///***************************************
///  Remap Request types
///***************************************
///****************************************
/// The basic request wrapper leaves space for a version which
///   allow the server to support older clients
/// The tool parameter allows us to log the client types for
///   debugging and tuning
///****************************************
/// a standard request
class NCBI_REMAP_EXPORT CRemap_request_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CRemap_request_Base(void);
    // destructor
    virtual ~CRemap_request_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CRMRequest TRequest;
    typedef int TVersion;
    typedef string TTool;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_request,
        e_version,
        e_tool
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// the actual request
    /// mandatory
    /// typedef CRMRequest TRequest
    ///  Check whether the Request data member has been assigned a value.
    bool IsSetRequest(void) const;
    /// Check whether it is safe or not to call GetRequest method.
    bool CanGetRequest(void) const;
    void ResetRequest(void);
    const TRequest& GetRequest(void) const;
    void SetRequest(TRequest& value);
    TRequest& SetRequest(void);

    /// ASN1 spec version
    /// mandatory
    /// typedef int TVersion
    ///  Check whether the Version data member has been assigned a value.
    bool IsSetVersion(void) const;
    /// Check whether it is safe or not to call GetVersion method.
    bool CanGetVersion(void) const;
    void ResetVersion(void);
    TVersion GetVersion(void) const;
    void SetVersion(TVersion value);
    TVersion& SetVersion(void);

    /// tool making request
    /// optional
    /// typedef string TTool
    ///  Check whether the Tool data member has been assigned a value.
    bool IsSetTool(void) const;
    /// Check whether it is safe or not to call GetTool method.
    bool CanGetTool(void) const;
    void ResetTool(void);
    const TTool& GetTool(void) const;
    void SetTool(const TTool& value);
    void SetTool(TTool&& value);
    TTool& SetTool(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CRemap_request_Base(const CRemap_request_Base&);
    CRemap_request_Base& operator=(const CRemap_request_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TRequest > m_Request;
    int m_Version;
    string m_Tool;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CRemap_request_Base::IsSetRequest(void) const
{
    return m_Request.NotEmpty();
}

inline
bool CRemap_request_Base::CanGetRequest(void) const
{
    return true;
}

inline
const CRemap_request_Base::TRequest& CRemap_request_Base::GetRequest(void) const
{
    if ( !m_Request ) {
        const_cast<CRemap_request_Base*>(this)->ResetRequest();
    }
    return (*m_Request);
}

inline
CRemap_request_Base::TRequest& CRemap_request_Base::SetRequest(void)
{
    if ( !m_Request ) {
        ResetRequest();
    }
    return (*m_Request);
}

inline
bool CRemap_request_Base::IsSetVersion(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CRemap_request_Base::CanGetVersion(void) const
{
    return IsSetVersion();
}

inline
void CRemap_request_Base::ResetVersion(void)
{
    m_Version = 0;
    m_set_State[0] &= ~0xc;
}

inline
CRemap_request_Base::TVersion CRemap_request_Base::GetVersion(void) const
{
    if (!CanGetVersion()) {
        ThrowUnassigned(1);
    }
    return m_Version;
}

inline
void CRemap_request_Base::SetVersion(CRemap_request_Base::TVersion value)
{
    m_Version = value;
    m_set_State[0] |= 0xc;
}

inline
CRemap_request_Base::TVersion& CRemap_request_Base::SetVersion(void)
{
#ifdef _DEBUG
    if (!IsSetVersion()) {
        memset(&m_Version,UnassignedByte(),sizeof(m_Version));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Version;
}

inline
bool CRemap_request_Base::IsSetTool(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CRemap_request_Base::CanGetTool(void) const
{
    return IsSetTool();
}

inline
const CRemap_request_Base::TTool& CRemap_request_Base::GetTool(void) const
{
    if (!CanGetTool()) {
        ThrowUnassigned(2);
    }
    return m_Tool;
}

inline
void CRemap_request_Base::SetTool(const CRemap_request_Base::TTool& value)
{
    m_Tool = value;
    m_set_State[0] |= 0x30;
}

inline
void CRemap_request_Base::SetTool(CRemap_request_Base::TTool&& value)
{
    m_Tool = std::forward<CRemap_request_Base::TTool>(value);
    m_set_State[0] |= 0x30;
}

inline
CRemap_request_Base::TTool& CRemap_request_Base::SetTool(void)
{
#ifdef _DEBUG
    if (!IsSetTool()) {
        m_Tool = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Tool;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_REMAP_REMAP_REQUEST_BASE_HPP
