/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_StereoTetrahedral_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcsubstance.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCSUBSTANCE_PC_STEREOTETRAHEDRAL_BASE_HPP
#define OBJECTS_PCSUBSTANCE_PC_STEREOTETRAHEDRAL_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// SP3 Tetrahedral StereoCenter, Trigonal Pyramid Stereogenic Center,
///   Cumulenic StereoCenter (Linear systems of an even number of double bonds),
///   or Hindered biaryl stereocenter (All biaryls have hindered rotation that
///   to some extent the ortho-hydrogens prevent coplanarity)
///   [Using IUPAC Stereogenic Center recommendations and terminology]
///   [Note: "-1" can be used for the Atom Identifier to represent a lone-pair or implicit hydrogen]
class NCBI_PCSUBSTANCE_EXPORT CPC_StereoTetrahedral_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPC_StereoTetrahedral_Base(void);
    // destructor
    virtual ~CPC_StereoTetrahedral_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /// StereoCenter Designation
    enum EParity {
        eParity_clockwise        =   1,
        eParity_counterclockwise =   2,
        eParity_any              =   3,
        eParity_unknown          = 255
    };
    
    /// Access to EParity's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EParity)(void);
    
    /// Type of StereoCenter, Tetrahedral, if not specified
    enum EType {
        eType_tetrahedral = 1,  ///< Tetrahedral StereoCenter
        eType_cumulenic   = 2,  ///< Cumulenic StereoCenter
        eType_biaryl      = 3  ///< Biaryl StereoCenter
    };
    
    /// Access to EType's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EType)(void);
    
    // types
    typedef int TCenter;
    typedef int TAbove;
    typedef int TTop;
    typedef int TBottom;
    typedef int TBelow;
    typedef int TParity;
    typedef int TType;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_center,
        e_above,
        e_top,
        e_bottom,
        e_below,
        e_parity,
        e_type
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 8> TmemberIndex;

    // getters
    // setters

    /// Atom Identifier of Atom Center
    ///   Note: Atom ID's must be greater than "0"
    /// mandatory
    /// typedef int TCenter
    ///  Check whether the Center data member has been assigned a value.
    bool IsSetCenter(void) const;
    /// Check whether it is safe or not to call GetCenter method.
    bool CanGetCenter(void) const;
    void ResetCenter(void);
    TCenter GetCenter(void) const;
    void SetCenter(TCenter value);
    TCenter& SetCenter(void);

    /// Atom Identifier of Atom Above the Plane
    ///   Note: Atom ID's must be greater than "0"
    /// mandatory
    /// typedef int TAbove
    ///  Check whether the Above data member has been assigned a value.
    bool IsSetAbove(void) const;
    /// Check whether it is safe or not to call GetAbove method.
    bool CanGetAbove(void) const;
    void ResetAbove(void);
    TAbove GetAbove(void) const;
    void SetAbove(TAbove value);
    TAbove& SetAbove(void);

    /// Atom Identifier of Atom In-Plane and at the Top
    ///   Note: Atom ID's must be greater than "0"
    /// mandatory
    /// typedef int TTop
    ///  Check whether the Top data member has been assigned a value.
    bool IsSetTop(void) const;
    /// Check whether it is safe or not to call GetTop method.
    bool CanGetTop(void) const;
    void ResetTop(void);
    TTop GetTop(void) const;
    void SetTop(TTop value);
    TTop& SetTop(void);

    /// Atom Identifier of Atom In-Plane and at the Bottom
    ///   Note: Atom ID's must be greater than "0"
    /// mandatory
    /// typedef int TBottom
    ///  Check whether the Bottom data member has been assigned a value.
    bool IsSetBottom(void) const;
    /// Check whether it is safe or not to call GetBottom method.
    bool CanGetBottom(void) const;
    void ResetBottom(void);
    TBottom GetBottom(void) const;
    void SetBottom(TBottom value);
    TBottom& SetBottom(void);

    /// Atom Identifier of Atom Below the Plane
    ///   Note: Atom ID's must be greater than "0"
    /// mandatory
    /// typedef int TBelow
    ///  Check whether the Below data member has been assigned a value.
    bool IsSetBelow(void) const;
    /// Check whether it is safe or not to call GetBelow method.
    bool CanGetBelow(void) const;
    void ResetBelow(void);
    TBelow GetBelow(void) const;
    void SetBelow(TBelow value);
    TBelow& SetBelow(void);

    /// optional
    /// typedef int TParity
    ///  Check whether the Parity data member has been assigned a value.
    bool IsSetParity(void) const;
    /// Check whether it is safe or not to call GetParity method.
    bool CanGetParity(void) const;
    void ResetParity(void);
    TParity GetParity(void) const;
    void SetParity(TParity value);
    TParity& SetParity(void);

    /// optional
    /// typedef int TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPC_StereoTetrahedral_Base(const CPC_StereoTetrahedral_Base&);
    CPC_StereoTetrahedral_Base& operator=(const CPC_StereoTetrahedral_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Center;
    int m_Above;
    int m_Top;
    int m_Bottom;
    int m_Below;
    int m_Parity;
    int m_Type;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPC_StereoTetrahedral_Base::IsSetCenter(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPC_StereoTetrahedral_Base::CanGetCenter(void) const
{
    return IsSetCenter();
}

inline
void CPC_StereoTetrahedral_Base::ResetCenter(void)
{
    m_Center = 0;
    m_set_State[0] &= ~0x3;
}

inline
CPC_StereoTetrahedral_Base::TCenter CPC_StereoTetrahedral_Base::GetCenter(void) const
{
    if (!CanGetCenter()) {
        ThrowUnassigned(0);
    }
    return m_Center;
}

inline
void CPC_StereoTetrahedral_Base::SetCenter(CPC_StereoTetrahedral_Base::TCenter value)
{
    m_Center = value;
    m_set_State[0] |= 0x3;
}

inline
CPC_StereoTetrahedral_Base::TCenter& CPC_StereoTetrahedral_Base::SetCenter(void)
{
#ifdef _DEBUG
    if (!IsSetCenter()) {
        memset(&m_Center,UnassignedByte(),sizeof(m_Center));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Center;
}

inline
bool CPC_StereoTetrahedral_Base::IsSetAbove(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPC_StereoTetrahedral_Base::CanGetAbove(void) const
{
    return IsSetAbove();
}

inline
void CPC_StereoTetrahedral_Base::ResetAbove(void)
{
    m_Above = 0;
    m_set_State[0] &= ~0xc;
}

inline
CPC_StereoTetrahedral_Base::TAbove CPC_StereoTetrahedral_Base::GetAbove(void) const
{
    if (!CanGetAbove()) {
        ThrowUnassigned(1);
    }
    return m_Above;
}

inline
void CPC_StereoTetrahedral_Base::SetAbove(CPC_StereoTetrahedral_Base::TAbove value)
{
    m_Above = value;
    m_set_State[0] |= 0xc;
}

inline
CPC_StereoTetrahedral_Base::TAbove& CPC_StereoTetrahedral_Base::SetAbove(void)
{
#ifdef _DEBUG
    if (!IsSetAbove()) {
        memset(&m_Above,UnassignedByte(),sizeof(m_Above));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Above;
}

inline
bool CPC_StereoTetrahedral_Base::IsSetTop(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CPC_StereoTetrahedral_Base::CanGetTop(void) const
{
    return IsSetTop();
}

inline
void CPC_StereoTetrahedral_Base::ResetTop(void)
{
    m_Top = 0;
    m_set_State[0] &= ~0x30;
}

inline
CPC_StereoTetrahedral_Base::TTop CPC_StereoTetrahedral_Base::GetTop(void) const
{
    if (!CanGetTop()) {
        ThrowUnassigned(2);
    }
    return m_Top;
}

inline
void CPC_StereoTetrahedral_Base::SetTop(CPC_StereoTetrahedral_Base::TTop value)
{
    m_Top = value;
    m_set_State[0] |= 0x30;
}

inline
CPC_StereoTetrahedral_Base::TTop& CPC_StereoTetrahedral_Base::SetTop(void)
{
#ifdef _DEBUG
    if (!IsSetTop()) {
        memset(&m_Top,UnassignedByte(),sizeof(m_Top));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Top;
}

inline
bool CPC_StereoTetrahedral_Base::IsSetBottom(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CPC_StereoTetrahedral_Base::CanGetBottom(void) const
{
    return IsSetBottom();
}

inline
void CPC_StereoTetrahedral_Base::ResetBottom(void)
{
    m_Bottom = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CPC_StereoTetrahedral_Base::TBottom CPC_StereoTetrahedral_Base::GetBottom(void) const
{
    if (!CanGetBottom()) {
        ThrowUnassigned(3);
    }
    return m_Bottom;
}

inline
void CPC_StereoTetrahedral_Base::SetBottom(CPC_StereoTetrahedral_Base::TBottom value)
{
    m_Bottom = value;
    m_set_State[0] |= 0xc0;
}

inline
CPC_StereoTetrahedral_Base::TBottom& CPC_StereoTetrahedral_Base::SetBottom(void)
{
#ifdef _DEBUG
    if (!IsSetBottom()) {
        memset(&m_Bottom,UnassignedByte(),sizeof(m_Bottom));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Bottom;
}

inline
bool CPC_StereoTetrahedral_Base::IsSetBelow(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CPC_StereoTetrahedral_Base::CanGetBelow(void) const
{
    return IsSetBelow();
}

inline
void CPC_StereoTetrahedral_Base::ResetBelow(void)
{
    m_Below = 0;
    m_set_State[0] &= ~0x300;
}

inline
CPC_StereoTetrahedral_Base::TBelow CPC_StereoTetrahedral_Base::GetBelow(void) const
{
    if (!CanGetBelow()) {
        ThrowUnassigned(4);
    }
    return m_Below;
}

inline
void CPC_StereoTetrahedral_Base::SetBelow(CPC_StereoTetrahedral_Base::TBelow value)
{
    m_Below = value;
    m_set_State[0] |= 0x300;
}

inline
CPC_StereoTetrahedral_Base::TBelow& CPC_StereoTetrahedral_Base::SetBelow(void)
{
#ifdef _DEBUG
    if (!IsSetBelow()) {
        memset(&m_Below,UnassignedByte(),sizeof(m_Below));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Below;
}

inline
bool CPC_StereoTetrahedral_Base::IsSetParity(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CPC_StereoTetrahedral_Base::CanGetParity(void) const
{
    return IsSetParity();
}

inline
void CPC_StereoTetrahedral_Base::ResetParity(void)
{
    m_Parity = (EParity)(0);
    m_set_State[0] &= ~0xc00;
}

inline
CPC_StereoTetrahedral_Base::TParity CPC_StereoTetrahedral_Base::GetParity(void) const
{
    if (!CanGetParity()) {
        ThrowUnassigned(5);
    }
    return m_Parity;
}

inline
void CPC_StereoTetrahedral_Base::SetParity(CPC_StereoTetrahedral_Base::TParity value)
{
    m_Parity = value;
    m_set_State[0] |= 0xc00;
}

inline
CPC_StereoTetrahedral_Base::TParity& CPC_StereoTetrahedral_Base::SetParity(void)
{
#ifdef _DEBUG
    if (!IsSetParity()) {
        memset(&m_Parity,UnassignedByte(),sizeof(m_Parity));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Parity;
}

inline
bool CPC_StereoTetrahedral_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CPC_StereoTetrahedral_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CPC_StereoTetrahedral_Base::ResetType(void)
{
    m_Type = (EType)(0);
    m_set_State[0] &= ~0x3000;
}

inline
CPC_StereoTetrahedral_Base::TType CPC_StereoTetrahedral_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(6);
    }
    return m_Type;
}

inline
void CPC_StereoTetrahedral_Base::SetType(CPC_StereoTetrahedral_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0x3000;
}

inline
CPC_StereoTetrahedral_Base::TType& CPC_StereoTetrahedral_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Type;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCSUBSTANCE_PC_STEREOTETRAHEDRAL_BASE_HPP
