/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file MSModHit_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'omssa.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_OMSSA_MSMODHIT_BASE_HPP
#define OBJECTS_OMSSA_MSMODHIT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/omssa/MSMod.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// modifications to a hit peptide
class NCBI_OMSSA_EXPORT CMSModHit_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMSModHit_Base(void);
    // destructor
    virtual ~CMSModHit_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TSite;
    typedef int TModtype;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_site,
        e_modtype
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// the position in the peptide
    /// mandatory
    /// typedef int TSite
    ///  Check whether the Site data member has been assigned a value.
    bool IsSetSite(void) const;
    /// Check whether it is safe or not to call GetSite method.
    bool CanGetSite(void) const;
    void ResetSite(void);
    TSite GetSite(void) const;
    void SetSite(TSite value);
    TSite& SetSite(void);

    /// the type of modification
    /// mandatory
    /// typedef int TModtype
    ///  Check whether the Modtype data member has been assigned a value.
    bool IsSetModtype(void) const;
    /// Check whether it is safe or not to call GetModtype method.
    bool CanGetModtype(void) const;
    void ResetModtype(void);
    TModtype GetModtype(void) const;
    void SetModtype(TModtype value);
    TModtype& SetModtype(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMSModHit_Base(const CMSModHit_Base&);
    CMSModHit_Base& operator=(const CMSModHit_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Site;
    int m_Modtype;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMSModHit_Base::IsSetSite(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMSModHit_Base::CanGetSite(void) const
{
    return IsSetSite();
}

inline
void CMSModHit_Base::ResetSite(void)
{
    m_Site = 0;
    m_set_State[0] &= ~0x3;
}

inline
CMSModHit_Base::TSite CMSModHit_Base::GetSite(void) const
{
    if (!CanGetSite()) {
        ThrowUnassigned(0);
    }
    return m_Site;
}

inline
void CMSModHit_Base::SetSite(CMSModHit_Base::TSite value)
{
    m_Site = value;
    m_set_State[0] |= 0x3;
}

inline
CMSModHit_Base::TSite& CMSModHit_Base::SetSite(void)
{
#ifdef _DEBUG
    if (!IsSetSite()) {
        memset(&m_Site,UnassignedByte(),sizeof(m_Site));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Site;
}

inline
bool CMSModHit_Base::IsSetModtype(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMSModHit_Base::CanGetModtype(void) const
{
    return IsSetModtype();
}

inline
void CMSModHit_Base::ResetModtype(void)
{
    m_Modtype = (int)(0);
    m_set_State[0] &= ~0xc;
}

inline
CMSModHit_Base::TModtype CMSModHit_Base::GetModtype(void) const
{
    if (!CanGetModtype()) {
        ThrowUnassigned(1);
    }
    return m_Modtype;
}

inline
void CMSModHit_Base::SetModtype(CMSModHit_Base::TModtype value)
{
    m_Modtype = value;
    m_set_State[0] |= 0xc;
}

inline
CMSModHit_Base::TModtype& CMSModHit_Base::SetModtype(void)
{
#ifdef _DEBUG
    if (!IsSetModtype()) {
        memset(&m_Modtype,UnassignedByte(),sizeof(m_Modtype));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Modtype;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_OMSSA_MSMODHIT_BASE_HPP
