/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Bundle_seqs_aligns_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'ncbimime.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_NCBIMIME_BUNDLE_SEQS_ALIGNS_BASE_HPP
#define OBJECTS_NCBIMIME_BUNDLE_SEQS_ALIGNS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBiostruc_annot_set;
class CCn3d_style_dictionary;
class CCn3d_user_annotations;
class CSeq_annot;
class CSeq_entry;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// generic bundle of sequence and alignment info
class NCBI_NCBIMIME_EXPORT CBundle_seqs_aligns_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBundle_seqs_aligns_Base(void);
    // destructor
    virtual ~CBundle_seqs_aligns_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef list< CRef< CSeq_entry > > TSequences;
    typedef list< CRef< CSeq_annot > > TSeqaligns;
    typedef CBiostruc_annot_set TStrucaligns;
    typedef list< CRef< CSeq_annot > > TImports;
    typedef CCn3d_style_dictionary TStyle_dictionary;
    typedef CCn3d_user_annotations TUser_annotations;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_sequences,
        e_seqaligns,
        e_strucaligns,
        e_imports,
        e_style_dictionary,
        e_user_annotations
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 7> TmemberIndex;

    // getters
    // setters

    /// sequences
    /// optional
    /// typedef list< CRef< CSeq_entry > > TSequences
    ///  Check whether the Sequences data member has been assigned a value.
    bool IsSetSequences(void) const;
    /// Check whether it is safe or not to call GetSequences method.
    bool CanGetSequences(void) const;
    void ResetSequences(void);
    const TSequences& GetSequences(void) const;
    TSequences& SetSequences(void);

    /// sequence alignments
    /// optional
    /// typedef list< CRef< CSeq_annot > > TSeqaligns
    ///  Check whether the Seqaligns data member has been assigned a value.
    bool IsSetSeqaligns(void) const;
    /// Check whether it is safe or not to call GetSeqaligns method.
    bool CanGetSeqaligns(void) const;
    void ResetSeqaligns(void);
    const TSeqaligns& GetSeqaligns(void) const;
    TSeqaligns& SetSeqaligns(void);

    /// structure alignments
    /// optional
    /// typedef CBiostruc_annot_set TStrucaligns
    ///  Check whether the Strucaligns data member has been assigned a value.
    bool IsSetStrucaligns(void) const;
    /// Check whether it is safe or not to call GetStrucaligns method.
    bool CanGetStrucaligns(void) const;
    void ResetStrucaligns(void);
    const TStrucaligns& GetStrucaligns(void) const;
    void SetStrucaligns(TStrucaligns& value);
    TStrucaligns& SetStrucaligns(void);

    /// imports (updates in Cn3D)
    /// optional
    /// typedef list< CRef< CSeq_annot > > TImports
    ///  Check whether the Imports data member has been assigned a value.
    bool IsSetImports(void) const;
    /// Check whether it is safe or not to call GetImports method.
    bool CanGetImports(void) const;
    void ResetImports(void);
    const TImports& GetImports(void) const;
    TImports& SetImports(void);

    /// Cn3D stuff
    /// optional
    /// typedef CCn3d_style_dictionary TStyle_dictionary
    ///  Check whether the Style_dictionary data member has been assigned a value.
    bool IsSetStyle_dictionary(void) const;
    /// Check whether it is safe or not to call GetStyle_dictionary method.
    bool CanGetStyle_dictionary(void) const;
    void ResetStyle_dictionary(void);
    const TStyle_dictionary& GetStyle_dictionary(void) const;
    void SetStyle_dictionary(TStyle_dictionary& value);
    TStyle_dictionary& SetStyle_dictionary(void);

    /// optional
    /// typedef CCn3d_user_annotations TUser_annotations
    ///  Check whether the User_annotations data member has been assigned a value.
    bool IsSetUser_annotations(void) const;
    /// Check whether it is safe or not to call GetUser_annotations method.
    bool CanGetUser_annotations(void) const;
    void ResetUser_annotations(void);
    const TUser_annotations& GetUser_annotations(void) const;
    void SetUser_annotations(TUser_annotations& value);
    TUser_annotations& SetUser_annotations(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBundle_seqs_aligns_Base(const CBundle_seqs_aligns_Base&);
    CBundle_seqs_aligns_Base& operator=(const CBundle_seqs_aligns_Base&);

    // data
    Uint4 m_set_State[1];
    list< CRef< CSeq_entry > > m_Sequences;
    list< CRef< CSeq_annot > > m_Seqaligns;
    CRef< TStrucaligns > m_Strucaligns;
    list< CRef< CSeq_annot > > m_Imports;
    CRef< TStyle_dictionary > m_Style_dictionary;
    CRef< TUser_annotations > m_User_annotations;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBundle_seqs_aligns_Base::IsSetSequences(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBundle_seqs_aligns_Base::CanGetSequences(void) const
{
    return true;
}

inline
const CBundle_seqs_aligns_Base::TSequences& CBundle_seqs_aligns_Base::GetSequences(void) const
{
    return m_Sequences;
}

inline
CBundle_seqs_aligns_Base::TSequences& CBundle_seqs_aligns_Base::SetSequences(void)
{
    m_set_State[0] |= 0x1;
    return m_Sequences;
}

inline
bool CBundle_seqs_aligns_Base::IsSetSeqaligns(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CBundle_seqs_aligns_Base::CanGetSeqaligns(void) const
{
    return true;
}

inline
const CBundle_seqs_aligns_Base::TSeqaligns& CBundle_seqs_aligns_Base::GetSeqaligns(void) const
{
    return m_Seqaligns;
}

inline
CBundle_seqs_aligns_Base::TSeqaligns& CBundle_seqs_aligns_Base::SetSeqaligns(void)
{
    m_set_State[0] |= 0x4;
    return m_Seqaligns;
}

inline
bool CBundle_seqs_aligns_Base::IsSetStrucaligns(void) const
{
    return m_Strucaligns.NotEmpty();
}

inline
bool CBundle_seqs_aligns_Base::CanGetStrucaligns(void) const
{
    return IsSetStrucaligns();
}

inline
const CBundle_seqs_aligns_Base::TStrucaligns& CBundle_seqs_aligns_Base::GetStrucaligns(void) const
{
    if (!CanGetStrucaligns()) {
        ThrowUnassigned(2);
    }
    return (*m_Strucaligns);
}

inline
bool CBundle_seqs_aligns_Base::IsSetImports(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CBundle_seqs_aligns_Base::CanGetImports(void) const
{
    return true;
}

inline
const CBundle_seqs_aligns_Base::TImports& CBundle_seqs_aligns_Base::GetImports(void) const
{
    return m_Imports;
}

inline
CBundle_seqs_aligns_Base::TImports& CBundle_seqs_aligns_Base::SetImports(void)
{
    m_set_State[0] |= 0x40;
    return m_Imports;
}

inline
bool CBundle_seqs_aligns_Base::IsSetStyle_dictionary(void) const
{
    return m_Style_dictionary.NotEmpty();
}

inline
bool CBundle_seqs_aligns_Base::CanGetStyle_dictionary(void) const
{
    return IsSetStyle_dictionary();
}

inline
const CBundle_seqs_aligns_Base::TStyle_dictionary& CBundle_seqs_aligns_Base::GetStyle_dictionary(void) const
{
    if (!CanGetStyle_dictionary()) {
        ThrowUnassigned(4);
    }
    return (*m_Style_dictionary);
}

inline
bool CBundle_seqs_aligns_Base::IsSetUser_annotations(void) const
{
    return m_User_annotations.NotEmpty();
}

inline
bool CBundle_seqs_aligns_Base::CanGetUser_annotations(void) const
{
    return IsSetUser_annotations();
}

inline
const CBundle_seqs_aligns_Base::TUser_annotations& CBundle_seqs_aligns_Base::GetUser_annotations(void) const
{
    if (!CanGetUser_annotations()) {
        ThrowUnassigned(5);
    }
    return (*m_User_annotations);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_NCBIMIME_BUNDLE_SEQS_ALIGNS_BASE_HPP
