/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Biostruc_feature_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb3.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB3_BIOSTRUC_FEATURE_BASE_HPP
#define OBJECTS_MMDB3_BIOSTRUC_FEATURE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <objects/mmdb3/Biostruc_feature_id.hpp>
#include <objects/mmdb3/Render_prop.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBiostruc_script;
class CCamera;
class CChem_graph_alignment;
class CChem_graph_interaction;
class CChem_graph_pntrs;
class CColor_prop;
class COther_feature;
class CRegion_pntrs;
class CRegion_similarity;
class CTransform;
class CUser_object;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// An explicitly specified type in Biostruc-feature allows for
/// efficient extraction and indexing of feature sets of a specific type. 
/// Special types are provided for coloring and rendering, as
/// as needed by molecular graphics programs.
/// new
class NCBI_MMDB3_EXPORT CBiostruc_feature_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBiostruc_feature_Base(void);
    // destructor
    virtual ~CBiostruc_feature_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum EType {
        eType_helix       =   1,
        eType_strand      =   2,
        eType_sheet       =   3,
        eType_turn        =   4,
        eType_site        =   5,
        eType_footnote    =   6,
        eType_comment     =   7,  ///< new
        eType_interaction =   8,  ///< interaction Data
        eType_subgraph    = 100,  ///< NCBI domain reserved
        eType_region      = 101,
        eType_core        = 102,  ///< user core definition
        eType_supercore   = 103,  ///< NCBI reserved
        eType_color       = 150,  ///< new
        eType_render      = 151,  ///< new
        eType_label       = 152,  ///< new
        eType_transform   = 153,  ///< new
        eType_camera      = 154,  ///< new
        eType_script      = 155,  ///< for scripts
        eType_alignment   = 200,  ///< VAST reserved 
        eType_similarity  = 201,
        eType_multalign   = 202,  ///< multiple alignment
        eType_indirect    = 203,  ///< new
        eType_cn3dstate   = 254,  ///< Cn3D reserved
        eType_other       = 255
    };
    
    /// Access to EType's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EType)(void);
    
    /////////////////////////////////////////////////////////////////////////////
    class NCBI_MMDB3_EXPORT C_Property : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Property(void);
        // destructor
        ~C_Property(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Color,
            e_Render,
            e_Transform,
            e_Camera,
            e_Script,
            e_User
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 7 ///< == e_User+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef CColor_prop TColor;
        typedef int TRender;
        typedef CTransform TTransform;
        typedef CCamera TCamera;
        typedef CBiostruc_script TScript;
        typedef CUser_object TUser;
    
        // getters
        // setters
    
        // typedef CColor_prop TColor
        bool IsColor(void) const;
        const TColor& GetColor(void) const;
        TColor& SetColor(void);
        void SetColor(TColor& value);
    
        // typedef int TRender
        bool IsRender(void) const;
        TRender GetRender(void) const;
        TRender& SetRender(void);
        void SetRender(TRender value);
    
        // typedef CTransform TTransform
        bool IsTransform(void) const;
        const TTransform& GetTransform(void) const;
        TTransform& SetTransform(void);
        void SetTransform(TTransform& value);
    
        // typedef CCamera TCamera
        bool IsCamera(void) const;
        const TCamera& GetCamera(void) const;
        TCamera& SetCamera(void);
        void SetCamera(TCamera& value);
    
        // typedef CBiostruc_script TScript
        bool IsScript(void) const;
        const TScript& GetScript(void) const;
        TScript& SetScript(void);
        void SetScript(TScript& value);
    
        // typedef CUser_object TUser
        bool IsUser(void) const;
        const TUser& GetUser(void) const;
        TUser& SetUser(void);
        void SetUser(TUser& value);
    
    
    private:
        // copy constructor and assignment operator
        C_Property(const C_Property& );
        C_Property& operator=(const C_Property& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            TRender m_Render;
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
    };
    /////////////////////////////////////////////////////////////////////////////
    class NCBI_MMDB3_EXPORT C_Location : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Location(void);
        // destructor
        ~C_Location(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Subgraph,
            e_Region,
            e_Alignment,
            e_Interaction,
            e_Similarity,
            e_Indirect
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 7 ///< == e_Indirect+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef CChem_graph_pntrs TSubgraph;
        typedef CRegion_pntrs TRegion;
        typedef CChem_graph_alignment TAlignment;
        typedef CChem_graph_interaction TInteraction;
        typedef CRegion_similarity TSimilarity;
        typedef COther_feature TIndirect;
    
        // getters
        // setters
    
        // typedef CChem_graph_pntrs TSubgraph
        bool IsSubgraph(void) const;
        const TSubgraph& GetSubgraph(void) const;
        TSubgraph& SetSubgraph(void);
        void SetSubgraph(TSubgraph& value);
    
        // typedef CRegion_pntrs TRegion
        bool IsRegion(void) const;
        const TRegion& GetRegion(void) const;
        TRegion& SetRegion(void);
        void SetRegion(TRegion& value);
    
        // typedef CChem_graph_alignment TAlignment
        bool IsAlignment(void) const;
        const TAlignment& GetAlignment(void) const;
        TAlignment& SetAlignment(void);
        void SetAlignment(TAlignment& value);
    
        // typedef CChem_graph_interaction TInteraction
        bool IsInteraction(void) const;
        const TInteraction& GetInteraction(void) const;
        TInteraction& SetInteraction(void);
        void SetInteraction(TInteraction& value);
    
        // typedef CRegion_similarity TSimilarity
        bool IsSimilarity(void) const;
        const TSimilarity& GetSimilarity(void) const;
        TSimilarity& SetSimilarity(void);
        void SetSimilarity(TSimilarity& value);
    
        // typedef COther_feature TIndirect
        bool IsIndirect(void) const;
        const TIndirect& GetIndirect(void) const;
        TIndirect& SetIndirect(void);
        void SetIndirect(TIndirect& value);
    
    
    private:
        // copy constructor and assignment operator
        C_Location(const C_Location& );
        C_Location& operator=(const C_Location& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
    // types
    typedef CBiostruc_feature_id TId;
    typedef string TName;
    typedef int TType;
    typedef C_Property TProperty;
    typedef C_Location TLocation;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_id,
        e_name,
        e_type,
        e_property,
        e_location
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef CBiostruc_feature_id TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(const TId& value);
    TId& SetId(void);

    /// optional
    /// typedef string TName
    ///  Check whether the Name data member has been assigned a value.
    bool IsSetName(void) const;
    /// Check whether it is safe or not to call GetName method.
    bool CanGetName(void) const;
    void ResetName(void);
    const TName& GetName(void) const;
    void SetName(const TName& value);
    void SetName(TName&& value);
    TName& SetName(void);

    /// optional
    /// typedef int TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// optional
    /// typedef C_Property TProperty
    ///  Check whether the Property data member has been assigned a value.
    bool IsSetProperty(void) const;
    /// Check whether it is safe or not to call GetProperty method.
    bool CanGetProperty(void) const;
    void ResetProperty(void);
    const TProperty& GetProperty(void) const;
    void SetProperty(TProperty& value);
    TProperty& SetProperty(void);

    /// optional
    /// typedef C_Location TLocation
    ///  Check whether the Location data member has been assigned a value.
    bool IsSetLocation(void) const;
    /// Check whether it is safe or not to call GetLocation method.
    bool CanGetLocation(void) const;
    void ResetLocation(void);
    const TLocation& GetLocation(void) const;
    void SetLocation(TLocation& value);
    TLocation& SetLocation(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBiostruc_feature_Base(const CBiostruc_feature_Base&);
    CBiostruc_feature_Base& operator=(const CBiostruc_feature_Base&);

    // data
    Uint4 m_set_State[1];
    CBiostruc_feature_id m_Id;
    string m_Name;
    int m_Type;
    CRef< TProperty > m_Property;
    CRef< TLocation > m_Location;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CBiostruc_feature_Base::C_Property::E_Choice CBiostruc_feature_Base::C_Property::Which(void) const
{
    return m_choice;
}

inline
void CBiostruc_feature_Base::C_Property::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBiostruc_feature_Base::C_Property::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBiostruc_feature_Base::C_Property::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBiostruc_feature_Base::C_Property::IsColor(void) const
{
    return m_choice == e_Color;
}

inline
bool CBiostruc_feature_Base::C_Property::IsRender(void) const
{
    return m_choice == e_Render;
}

inline
CBiostruc_feature_Base::C_Property::TRender CBiostruc_feature_Base::C_Property::GetRender(void) const
{
    CheckSelected(e_Render);
    return m_Render;
}

inline
CBiostruc_feature_Base::C_Property::TRender& CBiostruc_feature_Base::C_Property::SetRender(void)
{
    Select(e_Render, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Render;
}

inline
void CBiostruc_feature_Base::C_Property::SetRender(CBiostruc_feature_Base::C_Property::TRender value)
{
    Select(e_Render, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Render = value;
}

inline
bool CBiostruc_feature_Base::C_Property::IsTransform(void) const
{
    return m_choice == e_Transform;
}

inline
bool CBiostruc_feature_Base::C_Property::IsCamera(void) const
{
    return m_choice == e_Camera;
}

inline
bool CBiostruc_feature_Base::C_Property::IsScript(void) const
{
    return m_choice == e_Script;
}

inline
bool CBiostruc_feature_Base::C_Property::IsUser(void) const
{
    return m_choice == e_User;
}

inline
CBiostruc_feature_Base::C_Location::E_Choice CBiostruc_feature_Base::C_Location::Which(void) const
{
    return m_choice;
}

inline
void CBiostruc_feature_Base::C_Location::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBiostruc_feature_Base::C_Location::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBiostruc_feature_Base::C_Location::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBiostruc_feature_Base::C_Location::IsSubgraph(void) const
{
    return m_choice == e_Subgraph;
}

inline
bool CBiostruc_feature_Base::C_Location::IsRegion(void) const
{
    return m_choice == e_Region;
}

inline
bool CBiostruc_feature_Base::C_Location::IsAlignment(void) const
{
    return m_choice == e_Alignment;
}

inline
bool CBiostruc_feature_Base::C_Location::IsInteraction(void) const
{
    return m_choice == e_Interaction;
}

inline
bool CBiostruc_feature_Base::C_Location::IsSimilarity(void) const
{
    return m_choice == e_Similarity;
}

inline
bool CBiostruc_feature_Base::C_Location::IsIndirect(void) const
{
    return m_choice == e_Indirect;
}

inline
bool CBiostruc_feature_Base::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBiostruc_feature_Base::CanGetId(void) const
{
    return IsSetId();
}

inline
void CBiostruc_feature_Base::ResetId(void)
{
    m_Id = CBiostruc_feature_id(0);
    m_set_State[0] &= ~0x3;
}

inline
const CBiostruc_feature_Base::TId& CBiostruc_feature_Base::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CBiostruc_feature_Base::SetId(const CBiostruc_feature_Base::TId& value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
CBiostruc_feature_Base::TId& CBiostruc_feature_Base::SetId(void)
{
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CBiostruc_feature_Base::IsSetName(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CBiostruc_feature_Base::CanGetName(void) const
{
    return IsSetName();
}

inline
const CBiostruc_feature_Base::TName& CBiostruc_feature_Base::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(1);
    }
    return m_Name;
}

inline
void CBiostruc_feature_Base::SetName(const CBiostruc_feature_Base::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0xc;
}

inline
void CBiostruc_feature_Base::SetName(CBiostruc_feature_Base::TName&& value)
{
    m_Name = std::forward<CBiostruc_feature_Base::TName>(value);
    m_set_State[0] |= 0xc;
}

inline
CBiostruc_feature_Base::TName& CBiostruc_feature_Base::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Name;
}

inline
bool CBiostruc_feature_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CBiostruc_feature_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CBiostruc_feature_Base::ResetType(void)
{
    m_Type = (EType)(0);
    m_set_State[0] &= ~0x30;
}

inline
CBiostruc_feature_Base::TType CBiostruc_feature_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(2);
    }
    return m_Type;
}

inline
void CBiostruc_feature_Base::SetType(CBiostruc_feature_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0x30;
}

inline
CBiostruc_feature_Base::TType& CBiostruc_feature_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Type;
}

inline
bool CBiostruc_feature_Base::IsSetProperty(void) const
{
    return m_Property.NotEmpty();
}

inline
bool CBiostruc_feature_Base::CanGetProperty(void) const
{
    return IsSetProperty();
}

inline
const CBiostruc_feature_Base::TProperty& CBiostruc_feature_Base::GetProperty(void) const
{
    if (!CanGetProperty()) {
        ThrowUnassigned(3);
    }
    return (*m_Property);
}

inline
bool CBiostruc_feature_Base::IsSetLocation(void) const
{
    return m_Location.NotEmpty();
}

inline
bool CBiostruc_feature_Base::CanGetLocation(void) const
{
    return IsSetLocation();
}

inline
const CBiostruc_feature_Base::TLocation& CBiostruc_feature_Base::GetLocation(void) const
{
    if (!CanGetLocation()) {
        ThrowUnassigned(4);
    }
    return (*m_Location);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB3_BIOSTRUC_FEATURE_BASE_HPP
