/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Biostruc_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb1.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB1_BIOSTRUC_BASE_HPP
#define OBJECTS_MMDB1_BIOSTRUC_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBiostruc_descr;
class CBiostruc_feature_set;
class CBiostruc_graph;
class CBiostruc_id;
class CBiostruc_model;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// A structure report or "biostruc" describes the components of a biomolecular 
/// assembly in terms of their names and descriptions, and a chemical graph 
/// giving atomic formula, connectivity and chirality. It also gives one or more
/// three-dimensional model structures, literally a mapping of the atoms, 
/// residues and/or molecules of each component into a measured three-
/// dimensional space. Structure may also be described by named features, which 
/// associate nodes in the chemical graph, or regions in space, with text or 
/// numeric descriptors.
/// Note that a biostruc may also contain cross references to other databases,
/// including citations to relevant scientific literature. These cross 
/// references use object types from other NCBI data specifications, which are 
/// "imported" into MMDB, and not repeated in this specification. 
class NCBI_MMDB1_EXPORT CBiostruc_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBiostruc_Base(void);
    // destructor
    virtual ~CBiostruc_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef list< CRef< CBiostruc_id > > TId;
    typedef list< CRef< CBiostruc_descr > > TDescr;
    typedef CBiostruc_graph TChemical_graph;
    typedef list< CRef< CBiostruc_feature_set > > TFeatures;
    typedef list< CRef< CBiostruc_model > > TModel;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_id,
        e_descr,
        e_chemical_graph,
        e_features,
        e_model
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef list< CRef< CBiostruc_id > > TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    TId& SetId(void);

    /// optional
    /// typedef list< CRef< CBiostruc_descr > > TDescr
    ///  Check whether the Descr data member has been assigned a value.
    bool IsSetDescr(void) const;
    /// Check whether it is safe or not to call GetDescr method.
    bool CanGetDescr(void) const;
    void ResetDescr(void);
    const TDescr& GetDescr(void) const;
    TDescr& SetDescr(void);

    /// mandatory
    /// typedef CBiostruc_graph TChemical_graph
    ///  Check whether the Chemical_graph data member has been assigned a value.
    bool IsSetChemical_graph(void) const;
    /// Check whether it is safe or not to call GetChemical_graph method.
    bool CanGetChemical_graph(void) const;
    void ResetChemical_graph(void);
    const TChemical_graph& GetChemical_graph(void) const;
    void SetChemical_graph(TChemical_graph& value);
    TChemical_graph& SetChemical_graph(void);

    /// optional
    /// typedef list< CRef< CBiostruc_feature_set > > TFeatures
    ///  Check whether the Features data member has been assigned a value.
    bool IsSetFeatures(void) const;
    /// Check whether it is safe or not to call GetFeatures method.
    bool CanGetFeatures(void) const;
    void ResetFeatures(void);
    const TFeatures& GetFeatures(void) const;
    TFeatures& SetFeatures(void);

    /// optional
    /// typedef list< CRef< CBiostruc_model > > TModel
    ///  Check whether the Model data member has been assigned a value.
    bool IsSetModel(void) const;
    /// Check whether it is safe or not to call GetModel method.
    bool CanGetModel(void) const;
    void ResetModel(void);
    const TModel& GetModel(void) const;
    TModel& SetModel(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBiostruc_Base(const CBiostruc_Base&);
    CBiostruc_Base& operator=(const CBiostruc_Base&);

    // data
    Uint4 m_set_State[1];
    list< CRef< CBiostruc_id > > m_Id;
    list< CRef< CBiostruc_descr > > m_Descr;
    CRef< TChemical_graph > m_Chemical_graph;
    list< CRef< CBiostruc_feature_set > > m_Features;
    list< CRef< CBiostruc_model > > m_Model;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBiostruc_Base::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBiostruc_Base::CanGetId(void) const
{
    return true;
}

inline
const CBiostruc_Base::TId& CBiostruc_Base::GetId(void) const
{
    return m_Id;
}

inline
CBiostruc_Base::TId& CBiostruc_Base::SetId(void)
{
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CBiostruc_Base::IsSetDescr(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CBiostruc_Base::CanGetDescr(void) const
{
    return true;
}

inline
const CBiostruc_Base::TDescr& CBiostruc_Base::GetDescr(void) const
{
    return m_Descr;
}

inline
CBiostruc_Base::TDescr& CBiostruc_Base::SetDescr(void)
{
    m_set_State[0] |= 0x4;
    return m_Descr;
}

inline
bool CBiostruc_Base::IsSetChemical_graph(void) const
{
    return m_Chemical_graph.NotEmpty();
}

inline
bool CBiostruc_Base::CanGetChemical_graph(void) const
{
    return true;
}

inline
const CBiostruc_Base::TChemical_graph& CBiostruc_Base::GetChemical_graph(void) const
{
    if ( !m_Chemical_graph ) {
        const_cast<CBiostruc_Base*>(this)->ResetChemical_graph();
    }
    return (*m_Chemical_graph);
}

inline
CBiostruc_Base::TChemical_graph& CBiostruc_Base::SetChemical_graph(void)
{
    if ( !m_Chemical_graph ) {
        ResetChemical_graph();
    }
    return (*m_Chemical_graph);
}

inline
bool CBiostruc_Base::IsSetFeatures(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CBiostruc_Base::CanGetFeatures(void) const
{
    return true;
}

inline
const CBiostruc_Base::TFeatures& CBiostruc_Base::GetFeatures(void) const
{
    return m_Features;
}

inline
CBiostruc_Base::TFeatures& CBiostruc_Base::SetFeatures(void)
{
    m_set_State[0] |= 0x40;
    return m_Features;
}

inline
bool CBiostruc_Base::IsSetModel(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CBiostruc_Base::CanGetModel(void) const
{
    return true;
}

inline
const CBiostruc_Base::TModel& CBiostruc_Base::GetModel(void) const
{
    return m_Model;
}

inline
CBiostruc_Base::TModel& CBiostruc_Base::SetModel(void)
{
    m_set_State[0] |= 0x100;
    return m_Model;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB1_BIOSTRUC_BASE_HPP
