/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Mim_index_term_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mim.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MIM_MIM_INDEX_TERM_BASE_HPP
#define OBJECTS_MIM_MIM_INDEX_TERM_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_MIM_EXPORT CMim_index_term_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMim_index_term_Base(void);
    // destructor
    virtual ~CMim_index_term_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TKey;
    typedef list< string > TTerms;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_key,
        e_terms
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TKey
    ///  Check whether the Key data member has been assigned a value.
    bool IsSetKey(void) const;
    /// Check whether it is safe or not to call GetKey method.
    bool CanGetKey(void) const;
    void ResetKey(void);
    const TKey& GetKey(void) const;
    void SetKey(const TKey& value);
    void SetKey(TKey&& value);
    TKey& SetKey(void);

    /// mandatory
    /// typedef list< string > TTerms
    ///  Check whether the Terms data member has been assigned a value.
    bool IsSetTerms(void) const;
    /// Check whether it is safe or not to call GetTerms method.
    bool CanGetTerms(void) const;
    void ResetTerms(void);
    const TTerms& GetTerms(void) const;
    TTerms& SetTerms(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMim_index_term_Base(const CMim_index_term_Base&);
    CMim_index_term_Base& operator=(const CMim_index_term_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Key;
    list< string > m_Terms;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMim_index_term_Base::IsSetKey(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMim_index_term_Base::CanGetKey(void) const
{
    return IsSetKey();
}

inline
const CMim_index_term_Base::TKey& CMim_index_term_Base::GetKey(void) const
{
    if (!CanGetKey()) {
        ThrowUnassigned(0);
    }
    return m_Key;
}

inline
void CMim_index_term_Base::SetKey(const CMim_index_term_Base::TKey& value)
{
    m_Key = value;
    m_set_State[0] |= 0x3;
}

inline
void CMim_index_term_Base::SetKey(CMim_index_term_Base::TKey&& value)
{
    m_Key = std::forward<CMim_index_term_Base::TKey>(value);
    m_set_State[0] |= 0x3;
}

inline
CMim_index_term_Base::TKey& CMim_index_term_Base::SetKey(void)
{
#ifdef _DEBUG
    if (!IsSetKey()) {
        m_Key = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Key;
}

inline
bool CMim_index_term_Base::IsSetTerms(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMim_index_term_Base::CanGetTerms(void) const
{
    return true;
}

inline
const CMim_index_term_Base::TTerms& CMim_index_term_Base::GetTerms(void) const
{
    return m_Terms;
}

inline
CMim_index_term_Base::TTerms& CMim_index_term_Base::SetTerms(void)
{
    m_set_State[0] |= 0x4;
    return m_Terms;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MIM_MIM_INDEX_TERM_BASE_HPP
