/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Add_file_action_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_ADD_FILE_ACTION_BASE_HPP
#define OBJECTS_MACRO_ADD_FILE_ACTION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CApply_table_extra_data;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CAdd_file_action_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CAdd_file_action_Base(void);
    // destructor
    virtual ~CAdd_file_action_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TFilename;
    typedef CApply_table_extra_data TIn_memory_table;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_filename,
        e_in_memory_table
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TFilename
    ///  Check whether the Filename data member has been assigned a value.
    bool IsSetFilename(void) const;
    /// Check whether it is safe or not to call GetFilename method.
    bool CanGetFilename(void) const;
    void ResetFilename(void);
    const TFilename& GetFilename(void) const;
    void SetFilename(const TFilename& value);
    void SetFilename(TFilename&& value);
    TFilename& SetFilename(void);

    /// optional
    /// typedef CApply_table_extra_data TIn_memory_table
    ///  Check whether the In_memory_table data member has been assigned a value.
    bool IsSetIn_memory_table(void) const;
    /// Check whether it is safe or not to call GetIn_memory_table method.
    bool CanGetIn_memory_table(void) const;
    void ResetIn_memory_table(void);
    const TIn_memory_table& GetIn_memory_table(void) const;
    void SetIn_memory_table(TIn_memory_table& value);
    TIn_memory_table& SetIn_memory_table(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CAdd_file_action_Base(const CAdd_file_action_Base&);
    CAdd_file_action_Base& operator=(const CAdd_file_action_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Filename;
    CRef< TIn_memory_table > m_In_memory_table;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CAdd_file_action_Base::IsSetFilename(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CAdd_file_action_Base::CanGetFilename(void) const
{
    return IsSetFilename();
}

inline
const CAdd_file_action_Base::TFilename& CAdd_file_action_Base::GetFilename(void) const
{
    if (!CanGetFilename()) {
        ThrowUnassigned(0);
    }
    return m_Filename;
}

inline
void CAdd_file_action_Base::SetFilename(const CAdd_file_action_Base::TFilename& value)
{
    m_Filename = value;
    m_set_State[0] |= 0x3;
}

inline
void CAdd_file_action_Base::SetFilename(CAdd_file_action_Base::TFilename&& value)
{
    m_Filename = std::forward<CAdd_file_action_Base::TFilename>(value);
    m_set_State[0] |= 0x3;
}

inline
CAdd_file_action_Base::TFilename& CAdd_file_action_Base::SetFilename(void)
{
#ifdef _DEBUG
    if (!IsSetFilename()) {
        m_Filename = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Filename;
}

inline
bool CAdd_file_action_Base::IsSetIn_memory_table(void) const
{
    return m_In_memory_table.NotEmpty();
}

inline
bool CAdd_file_action_Base::CanGetIn_memory_table(void) const
{
    return IsSetIn_memory_table();
}

inline
const CAdd_file_action_Base::TIn_memory_table& CAdd_file_action_Base::GetIn_memory_table(void) const
{
    if (!CanGetIn_memory_table()) {
        ThrowUnassigned(1);
    }
    return (*m_In_memory_table);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_ADD_FILE_ACTION_BASE_HPP
