/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Add_descriptor_list_action_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_ADD_DESCRIPTOR_LIST_ACTION_BASE_HPP
#define OBJECTS_MACRO_ADD_DESCRIPTOR_LIST_ACTION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CAdd_file_action;
class CConstraint_choice_set;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CAdd_descriptor_list_action_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CAdd_descriptor_list_action_Base(void);
    // destructor
    virtual ~CAdd_descriptor_list_action_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CAdd_file_action TDescriptor_list;
    typedef CConstraint_choice_set TConstraint;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_descriptor_list,
        e_constraint
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CAdd_file_action TDescriptor_list
    ///  Check whether the Descriptor_list data member has been assigned a value.
    bool IsSetDescriptor_list(void) const;
    /// Check whether it is safe or not to call GetDescriptor_list method.
    bool CanGetDescriptor_list(void) const;
    void ResetDescriptor_list(void);
    const TDescriptor_list& GetDescriptor_list(void) const;
    void SetDescriptor_list(TDescriptor_list& value);
    TDescriptor_list& SetDescriptor_list(void);

    /// optional
    /// typedef CConstraint_choice_set TConstraint
    ///  Check whether the Constraint data member has been assigned a value.
    bool IsSetConstraint(void) const;
    /// Check whether it is safe or not to call GetConstraint method.
    bool CanGetConstraint(void) const;
    void ResetConstraint(void);
    const TConstraint& GetConstraint(void) const;
    void SetConstraint(TConstraint& value);
    TConstraint& SetConstraint(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CAdd_descriptor_list_action_Base(const CAdd_descriptor_list_action_Base&);
    CAdd_descriptor_list_action_Base& operator=(const CAdd_descriptor_list_action_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TDescriptor_list > m_Descriptor_list;
    CRef< TConstraint > m_Constraint;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CAdd_descriptor_list_action_Base::IsSetDescriptor_list(void) const
{
    return m_Descriptor_list.NotEmpty();
}

inline
bool CAdd_descriptor_list_action_Base::CanGetDescriptor_list(void) const
{
    return true;
}

inline
const CAdd_descriptor_list_action_Base::TDescriptor_list& CAdd_descriptor_list_action_Base::GetDescriptor_list(void) const
{
    if ( !m_Descriptor_list ) {
        const_cast<CAdd_descriptor_list_action_Base*>(this)->ResetDescriptor_list();
    }
    return (*m_Descriptor_list);
}

inline
CAdd_descriptor_list_action_Base::TDescriptor_list& CAdd_descriptor_list_action_Base::SetDescriptor_list(void)
{
    if ( !m_Descriptor_list ) {
        ResetDescriptor_list();
    }
    return (*m_Descriptor_list);
}

inline
bool CAdd_descriptor_list_action_Base::IsSetConstraint(void) const
{
    return m_Constraint.NotEmpty();
}

inline
bool CAdd_descriptor_list_action_Base::CanGetConstraint(void) const
{
    return IsSetConstraint();
}

inline
const CAdd_descriptor_list_action_Base::TConstraint& CAdd_descriptor_list_action_Base::GetConstraint(void) const
{
    if (!CanGetConstraint()) {
        ThrowUnassigned(1);
    }
    return (*m_Constraint);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_ADD_DESCRIPTOR_LIST_ACTION_BASE_HPP
