/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file INSDSeq_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'insdseq.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_INSDSEQ_INSDSEQ_BASE_HPP
#define OBJECTS_INSDSEQ_INSDSEQ_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <objects/insdseq/INSDKeyword.hpp>
#include <objects/insdseq/INSDSecondary_accn.hpp>
#include <objects/insdseq/INSDSeqid.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CINSDAltSeqData;
class CINSDComment;
class CINSDFeature;
class CINSDFeatureSet;
class CINSDReference;
class CINSDStrucComment;
class CINSDXref;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_INSDSEQ_EXPORT CINSDSeq_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CINSDSeq_Base(void);
    // destructor
    virtual ~CINSDSeq_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TLocus;
    typedef TSeqPos TLength;
    typedef string TStrandedness;
    typedef string TMoltype;
    typedef string TTopology;
    typedef string TDivision;
    typedef string TUpdate_date;
    typedef string TCreate_date;
    typedef string TUpdate_release;
    typedef string TCreate_release;
    typedef string TDefinition;
    typedef string TPrimary_accession;
    typedef string TEntry_version;
    typedef string TAccession_version;
    typedef list< CINSDSeqid > TOther_seqids;
    typedef list< CINSDSecondary_accn > TSecondary_accessions;
    typedef string TProject;
    typedef list< CINSDKeyword > TKeywords;
    typedef string TSegment;
    typedef string TSource;
    typedef string TOrganism;
    typedef string TTaxonomy;
    typedef list< CRef< CINSDReference > > TReferences;
    typedef string TComment;
    typedef list< CRef< CINSDComment > > TComment_set;
    typedef list< CRef< CINSDStrucComment > > TStruc_comments;
    typedef string TPrimary;
    typedef string TSource_db;
    typedef string TDatabase_reference;
    typedef list< CRef< CINSDFeature > > TFeature_table;
    typedef list< CRef< CINSDFeatureSet > > TFeature_set;
    typedef string TSequence;
    typedef string TContig;
    typedef list< CRef< CINSDAltSeqData > > TAlt_seq;
    typedef list< CRef< CINSDXref > > TXrefs;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_locus,
        e_length,
        e_strandedness,
        e_moltype,
        e_topology,
        e_division,
        e_update_date,
        e_create_date,
        e_update_release,
        e_create_release,
        e_definition,
        e_primary_accession,
        e_entry_version,
        e_accession_version,
        e_other_seqids,
        e_secondary_accessions,
        e_project,
        e_keywords,
        e_segment,
        e_source,
        e_organism,
        e_taxonomy,
        e_references,
        e_comment,
        e_comment_set,
        e_struc_comments,
        e_primary,
        e_source_db,
        e_database_reference,
        e_feature_table,
        e_feature_set,
        e_sequence,
        e_contig,
        e_alt_seq,
        e_xrefs
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 36> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef string TLocus
    ///  Check whether the Locus data member has been assigned a value.
    bool IsSetLocus(void) const;
    /// Check whether it is safe or not to call GetLocus method.
    bool CanGetLocus(void) const;
    void ResetLocus(void);
    const TLocus& GetLocus(void) const;
    void SetLocus(const TLocus& value);
    void SetLocus(TLocus&& value);
    TLocus& SetLocus(void);

    /// mandatory
    /// typedef TSeqPos TLength
    ///  Check whether the Length data member has been assigned a value.
    bool IsSetLength(void) const;
    /// Check whether it is safe or not to call GetLength method.
    bool CanGetLength(void) const;
    void ResetLength(void);
    TLength GetLength(void) const;
    void SetLength(TLength value);
    TLength& SetLength(void);

    /// optional
    /// typedef string TStrandedness
    ///  Check whether the Strandedness data member has been assigned a value.
    bool IsSetStrandedness(void) const;
    /// Check whether it is safe or not to call GetStrandedness method.
    bool CanGetStrandedness(void) const;
    void ResetStrandedness(void);
    const TStrandedness& GetStrandedness(void) const;
    void SetStrandedness(const TStrandedness& value);
    void SetStrandedness(TStrandedness&& value);
    TStrandedness& SetStrandedness(void);

    /// mandatory
    /// typedef string TMoltype
    ///  Check whether the Moltype data member has been assigned a value.
    bool IsSetMoltype(void) const;
    /// Check whether it is safe or not to call GetMoltype method.
    bool CanGetMoltype(void) const;
    void ResetMoltype(void);
    const TMoltype& GetMoltype(void) const;
    void SetMoltype(const TMoltype& value);
    void SetMoltype(TMoltype&& value);
    TMoltype& SetMoltype(void);

    /// optional
    /// typedef string TTopology
    ///  Check whether the Topology data member has been assigned a value.
    bool IsSetTopology(void) const;
    /// Check whether it is safe or not to call GetTopology method.
    bool CanGetTopology(void) const;
    void ResetTopology(void);
    const TTopology& GetTopology(void) const;
    void SetTopology(const TTopology& value);
    void SetTopology(TTopology&& value);
    TTopology& SetTopology(void);

    /// optional
    /// typedef string TDivision
    ///  Check whether the Division data member has been assigned a value.
    bool IsSetDivision(void) const;
    /// Check whether it is safe or not to call GetDivision method.
    bool CanGetDivision(void) const;
    void ResetDivision(void);
    const TDivision& GetDivision(void) const;
    void SetDivision(const TDivision& value);
    void SetDivision(TDivision&& value);
    TDivision& SetDivision(void);

    /// optional
    /// typedef string TUpdate_date
    ///  Check whether the Update_date data member has been assigned a value.
    bool IsSetUpdate_date(void) const;
    /// Check whether it is safe or not to call GetUpdate_date method.
    bool CanGetUpdate_date(void) const;
    void ResetUpdate_date(void);
    const TUpdate_date& GetUpdate_date(void) const;
    void SetUpdate_date(const TUpdate_date& value);
    void SetUpdate_date(TUpdate_date&& value);
    TUpdate_date& SetUpdate_date(void);

    /// optional
    /// typedef string TCreate_date
    ///  Check whether the Create_date data member has been assigned a value.
    bool IsSetCreate_date(void) const;
    /// Check whether it is safe or not to call GetCreate_date method.
    bool CanGetCreate_date(void) const;
    void ResetCreate_date(void);
    const TCreate_date& GetCreate_date(void) const;
    void SetCreate_date(const TCreate_date& value);
    void SetCreate_date(TCreate_date&& value);
    TCreate_date& SetCreate_date(void);

    /// optional
    /// typedef string TUpdate_release
    ///  Check whether the Update_release data member has been assigned a value.
    bool IsSetUpdate_release(void) const;
    /// Check whether it is safe or not to call GetUpdate_release method.
    bool CanGetUpdate_release(void) const;
    void ResetUpdate_release(void);
    const TUpdate_release& GetUpdate_release(void) const;
    void SetUpdate_release(const TUpdate_release& value);
    void SetUpdate_release(TUpdate_release&& value);
    TUpdate_release& SetUpdate_release(void);

    /// optional
    /// typedef string TCreate_release
    ///  Check whether the Create_release data member has been assigned a value.
    bool IsSetCreate_release(void) const;
    /// Check whether it is safe or not to call GetCreate_release method.
    bool CanGetCreate_release(void) const;
    void ResetCreate_release(void);
    const TCreate_release& GetCreate_release(void) const;
    void SetCreate_release(const TCreate_release& value);
    void SetCreate_release(TCreate_release&& value);
    TCreate_release& SetCreate_release(void);

    /// optional
    /// typedef string TDefinition
    ///  Check whether the Definition data member has been assigned a value.
    bool IsSetDefinition(void) const;
    /// Check whether it is safe or not to call GetDefinition method.
    bool CanGetDefinition(void) const;
    void ResetDefinition(void);
    const TDefinition& GetDefinition(void) const;
    void SetDefinition(const TDefinition& value);
    void SetDefinition(TDefinition&& value);
    TDefinition& SetDefinition(void);

    /// optional
    /// typedef string TPrimary_accession
    ///  Check whether the Primary_accession data member has been assigned a value.
    bool IsSetPrimary_accession(void) const;
    /// Check whether it is safe or not to call GetPrimary_accession method.
    bool CanGetPrimary_accession(void) const;
    void ResetPrimary_accession(void);
    const TPrimary_accession& GetPrimary_accession(void) const;
    void SetPrimary_accession(const TPrimary_accession& value);
    void SetPrimary_accession(TPrimary_accession&& value);
    TPrimary_accession& SetPrimary_accession(void);

    /// optional
    /// typedef string TEntry_version
    ///  Check whether the Entry_version data member has been assigned a value.
    bool IsSetEntry_version(void) const;
    /// Check whether it is safe or not to call GetEntry_version method.
    bool CanGetEntry_version(void) const;
    void ResetEntry_version(void);
    const TEntry_version& GetEntry_version(void) const;
    void SetEntry_version(const TEntry_version& value);
    void SetEntry_version(TEntry_version&& value);
    TEntry_version& SetEntry_version(void);

    /// optional
    /// typedef string TAccession_version
    ///  Check whether the Accession_version data member has been assigned a value.
    bool IsSetAccession_version(void) const;
    /// Check whether it is safe or not to call GetAccession_version method.
    bool CanGetAccession_version(void) const;
    void ResetAccession_version(void);
    const TAccession_version& GetAccession_version(void) const;
    void SetAccession_version(const TAccession_version& value);
    void SetAccession_version(TAccession_version&& value);
    TAccession_version& SetAccession_version(void);

    /// optional
    /// typedef list< CINSDSeqid > TOther_seqids
    ///  Check whether the Other_seqids data member has been assigned a value.
    bool IsSetOther_seqids(void) const;
    /// Check whether it is safe or not to call GetOther_seqids method.
    bool CanGetOther_seqids(void) const;
    void ResetOther_seqids(void);
    const TOther_seqids& GetOther_seqids(void) const;
    TOther_seqids& SetOther_seqids(void);

    /// optional
    /// typedef list< CINSDSecondary_accn > TSecondary_accessions
    ///  Check whether the Secondary_accessions data member has been assigned a value.
    bool IsSetSecondary_accessions(void) const;
    /// Check whether it is safe or not to call GetSecondary_accessions method.
    bool CanGetSecondary_accessions(void) const;
    void ResetSecondary_accessions(void);
    const TSecondary_accessions& GetSecondary_accessions(void) const;
    TSecondary_accessions& SetSecondary_accessions(void);

    ///  INSDSeq_project has been deprecated in favor of INSDSeq_xrefs .
    ///  This element may be be removed from a future version of this DTD.
    /// optional
    /// typedef string TProject
    ///  Check whether the Project data member has been assigned a value.
    bool IsSetProject(void) const;
    /// Check whether it is safe or not to call GetProject method.
    bool CanGetProject(void) const;
    void ResetProject(void);
    const TProject& GetProject(void) const;
    void SetProject(const TProject& value);
    void SetProject(TProject&& value);
    TProject& SetProject(void);

    /// optional
    /// typedef list< CINSDKeyword > TKeywords
    ///  Check whether the Keywords data member has been assigned a value.
    bool IsSetKeywords(void) const;
    /// Check whether it is safe or not to call GetKeywords method.
    bool CanGetKeywords(void) const;
    void ResetKeywords(void);
    const TKeywords& GetKeywords(void) const;
    TKeywords& SetKeywords(void);

    /// optional
    /// typedef string TSegment
    ///  Check whether the Segment data member has been assigned a value.
    bool IsSetSegment(void) const;
    /// Check whether it is safe or not to call GetSegment method.
    bool CanGetSegment(void) const;
    void ResetSegment(void);
    const TSegment& GetSegment(void) const;
    void SetSegment(const TSegment& value);
    void SetSegment(TSegment&& value);
    TSegment& SetSegment(void);

    /// optional
    /// typedef string TSource
    ///  Check whether the Source data member has been assigned a value.
    bool IsSetSource(void) const;
    /// Check whether it is safe or not to call GetSource method.
    bool CanGetSource(void) const;
    void ResetSource(void);
    const TSource& GetSource(void) const;
    void SetSource(const TSource& value);
    void SetSource(TSource&& value);
    TSource& SetSource(void);

    /// optional
    /// typedef string TOrganism
    ///  Check whether the Organism data member has been assigned a value.
    bool IsSetOrganism(void) const;
    /// Check whether it is safe or not to call GetOrganism method.
    bool CanGetOrganism(void) const;
    void ResetOrganism(void);
    const TOrganism& GetOrganism(void) const;
    void SetOrganism(const TOrganism& value);
    void SetOrganism(TOrganism&& value);
    TOrganism& SetOrganism(void);

    /// optional
    /// typedef string TTaxonomy
    ///  Check whether the Taxonomy data member has been assigned a value.
    bool IsSetTaxonomy(void) const;
    /// Check whether it is safe or not to call GetTaxonomy method.
    bool CanGetTaxonomy(void) const;
    void ResetTaxonomy(void);
    const TTaxonomy& GetTaxonomy(void) const;
    void SetTaxonomy(const TTaxonomy& value);
    void SetTaxonomy(TTaxonomy&& value);
    TTaxonomy& SetTaxonomy(void);

    /// optional
    /// typedef list< CRef< CINSDReference > > TReferences
    ///  Check whether the References data member has been assigned a value.
    bool IsSetReferences(void) const;
    /// Check whether it is safe or not to call GetReferences method.
    bool CanGetReferences(void) const;
    void ResetReferences(void);
    const TReferences& GetReferences(void) const;
    TReferences& SetReferences(void);

    /// optional
    /// typedef string TComment
    ///  Check whether the Comment data member has been assigned a value.
    bool IsSetComment(void) const;
    /// Check whether it is safe or not to call GetComment method.
    bool CanGetComment(void) const;
    void ResetComment(void);
    const TComment& GetComment(void) const;
    void SetComment(const TComment& value);
    void SetComment(TComment&& value);
    TComment& SetComment(void);

    /// optional
    /// typedef list< CRef< CINSDComment > > TComment_set
    ///  Check whether the Comment_set data member has been assigned a value.
    bool IsSetComment_set(void) const;
    /// Check whether it is safe or not to call GetComment_set method.
    bool CanGetComment_set(void) const;
    void ResetComment_set(void);
    const TComment_set& GetComment_set(void) const;
    TComment_set& SetComment_set(void);

    /// optional
    /// typedef list< CRef< CINSDStrucComment > > TStruc_comments
    ///  Check whether the Struc_comments data member has been assigned a value.
    bool IsSetStruc_comments(void) const;
    /// Check whether it is safe or not to call GetStruc_comments method.
    bool CanGetStruc_comments(void) const;
    void ResetStruc_comments(void);
    const TStruc_comments& GetStruc_comments(void) const;
    TStruc_comments& SetStruc_comments(void);

    /// optional
    /// typedef string TPrimary
    ///  Check whether the Primary data member has been assigned a value.
    bool IsSetPrimary(void) const;
    /// Check whether it is safe or not to call GetPrimary method.
    bool CanGetPrimary(void) const;
    void ResetPrimary(void);
    const TPrimary& GetPrimary(void) const;
    void SetPrimary(const TPrimary& value);
    void SetPrimary(TPrimary&& value);
    TPrimary& SetPrimary(void);

    /// optional
    /// typedef string TSource_db
    ///  Check whether the Source_db data member has been assigned a value.
    bool IsSetSource_db(void) const;
    /// Check whether it is safe or not to call GetSource_db method.
    bool CanGetSource_db(void) const;
    void ResetSource_db(void);
    const TSource_db& GetSource_db(void) const;
    void SetSource_db(const TSource_db& value);
    void SetSource_db(TSource_db&& value);
    TSource_db& SetSource_db(void);

    /// optional
    /// typedef string TDatabase_reference
    ///  Check whether the Database_reference data member has been assigned a value.
    bool IsSetDatabase_reference(void) const;
    /// Check whether it is safe or not to call GetDatabase_reference method.
    bool CanGetDatabase_reference(void) const;
    void ResetDatabase_reference(void);
    const TDatabase_reference& GetDatabase_reference(void) const;
    void SetDatabase_reference(const TDatabase_reference& value);
    void SetDatabase_reference(TDatabase_reference&& value);
    TDatabase_reference& SetDatabase_reference(void);

    /// optional
    /// typedef list< CRef< CINSDFeature > > TFeature_table
    ///  Check whether the Feature_table data member has been assigned a value.
    bool IsSetFeature_table(void) const;
    /// Check whether it is safe or not to call GetFeature_table method.
    bool CanGetFeature_table(void) const;
    void ResetFeature_table(void);
    const TFeature_table& GetFeature_table(void) const;
    TFeature_table& SetFeature_table(void);

    /// optional
    /// typedef list< CRef< CINSDFeatureSet > > TFeature_set
    ///  Check whether the Feature_set data member has been assigned a value.
    bool IsSetFeature_set(void) const;
    /// Check whether it is safe or not to call GetFeature_set method.
    bool CanGetFeature_set(void) const;
    void ResetFeature_set(void);
    const TFeature_set& GetFeature_set(void) const;
    TFeature_set& SetFeature_set(void);

    /// Optional for contig, wgs, etc.
    /// optional
    /// typedef string TSequence
    ///  Check whether the Sequence data member has been assigned a value.
    bool IsSetSequence(void) const;
    /// Check whether it is safe or not to call GetSequence method.
    bool CanGetSequence(void) const;
    void ResetSequence(void);
    const TSequence& GetSequence(void) const;
    void SetSequence(const TSequence& value);
    void SetSequence(TSequence&& value);
    TSequence& SetSequence(void);

    /// optional
    /// typedef string TContig
    ///  Check whether the Contig data member has been assigned a value.
    bool IsSetContig(void) const;
    /// Check whether it is safe or not to call GetContig method.
    bool CanGetContig(void) const;
    void ResetContig(void);
    const TContig& GetContig(void) const;
    void SetContig(const TContig& value);
    void SetContig(TContig&& value);
    TContig& SetContig(void);

    /// optional
    /// typedef list< CRef< CINSDAltSeqData > > TAlt_seq
    ///  Check whether the Alt_seq data member has been assigned a value.
    bool IsSetAlt_seq(void) const;
    /// Check whether it is safe or not to call GetAlt_seq method.
    bool CanGetAlt_seq(void) const;
    void ResetAlt_seq(void);
    const TAlt_seq& GetAlt_seq(void) const;
    TAlt_seq& SetAlt_seq(void);

    ///  INSDSeq_xrefs provides cross-references from a sequence record
    ///  to other database resources. These cross-references are at the
    ///  level of the entire record, rather than at the level of a specific
    ///  feature. These cross-references can include: BioProject, BioSample,
    ///  Sequence Read Archive, etc.
    /// optional
    /// typedef list< CRef< CINSDXref > > TXrefs
    ///  Check whether the Xrefs data member has been assigned a value.
    bool IsSetXrefs(void) const;
    /// Check whether it is safe or not to call GetXrefs method.
    bool CanGetXrefs(void) const;
    void ResetXrefs(void);
    const TXrefs& GetXrefs(void) const;
    TXrefs& SetXrefs(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CINSDSeq_Base(const CINSDSeq_Base&);
    CINSDSeq_Base& operator=(const CINSDSeq_Base&);

    // data
    Uint4 m_set_State[3];
    string m_Locus;
    TSeqPos m_Length;
    string m_Strandedness;
    string m_Moltype;
    string m_Topology;
    string m_Division;
    string m_Update_date;
    string m_Create_date;
    string m_Update_release;
    string m_Create_release;
    string m_Definition;
    string m_Primary_accession;
    string m_Entry_version;
    string m_Accession_version;
    list< CINSDSeqid > m_Other_seqids;
    list< CINSDSecondary_accn > m_Secondary_accessions;
    string m_Project;
    list< CINSDKeyword > m_Keywords;
    string m_Segment;
    string m_Source;
    string m_Organism;
    string m_Taxonomy;
    list< CRef< CINSDReference > > m_References;
    string m_Comment;
    list< CRef< CINSDComment > > m_Comment_set;
    list< CRef< CINSDStrucComment > > m_Struc_comments;
    string m_Primary;
    string m_Source_db;
    string m_Database_reference;
    list< CRef< CINSDFeature > > m_Feature_table;
    list< CRef< CINSDFeatureSet > > m_Feature_set;
    string m_Sequence;
    string m_Contig;
    list< CRef< CINSDAltSeqData > > m_Alt_seq;
    list< CRef< CINSDXref > > m_Xrefs;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CINSDSeq_Base::IsSetLocus(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CINSDSeq_Base::CanGetLocus(void) const
{
    return IsSetLocus();
}

inline
const CINSDSeq_Base::TLocus& CINSDSeq_Base::GetLocus(void) const
{
    if (!CanGetLocus()) {
        ThrowUnassigned(0);
    }
    return m_Locus;
}

inline
void CINSDSeq_Base::SetLocus(const CINSDSeq_Base::TLocus& value)
{
    m_Locus = value;
    m_set_State[0] |= 0x3;
}

inline
void CINSDSeq_Base::SetLocus(CINSDSeq_Base::TLocus&& value)
{
    m_Locus = std::forward<CINSDSeq_Base::TLocus>(value);
    m_set_State[0] |= 0x3;
}

inline
CINSDSeq_Base::TLocus& CINSDSeq_Base::SetLocus(void)
{
#ifdef _DEBUG
    if (!IsSetLocus()) {
        m_Locus = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Locus;
}

inline
bool CINSDSeq_Base::IsSetLength(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CINSDSeq_Base::CanGetLength(void) const
{
    return IsSetLength();
}

inline
void CINSDSeq_Base::ResetLength(void)
{
    m_Length = 0;
    m_set_State[0] &= ~0xc;
}

inline
CINSDSeq_Base::TLength CINSDSeq_Base::GetLength(void) const
{
    if (!CanGetLength()) {
        ThrowUnassigned(1);
    }
    return m_Length;
}

inline
void CINSDSeq_Base::SetLength(CINSDSeq_Base::TLength value)
{
    m_Length = value;
    m_set_State[0] |= 0xc;
}

inline
CINSDSeq_Base::TLength& CINSDSeq_Base::SetLength(void)
{
#ifdef _DEBUG
    if (!IsSetLength()) {
        memset(&m_Length,UnassignedByte(),sizeof(m_Length));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Length;
}

inline
bool CINSDSeq_Base::IsSetStrandedness(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CINSDSeq_Base::CanGetStrandedness(void) const
{
    return IsSetStrandedness();
}

inline
const CINSDSeq_Base::TStrandedness& CINSDSeq_Base::GetStrandedness(void) const
{
    if (!CanGetStrandedness()) {
        ThrowUnassigned(2);
    }
    return m_Strandedness;
}

inline
void CINSDSeq_Base::SetStrandedness(const CINSDSeq_Base::TStrandedness& value)
{
    m_Strandedness = value;
    m_set_State[0] |= 0x30;
}

inline
void CINSDSeq_Base::SetStrandedness(CINSDSeq_Base::TStrandedness&& value)
{
    m_Strandedness = std::forward<CINSDSeq_Base::TStrandedness>(value);
    m_set_State[0] |= 0x30;
}

inline
CINSDSeq_Base::TStrandedness& CINSDSeq_Base::SetStrandedness(void)
{
#ifdef _DEBUG
    if (!IsSetStrandedness()) {
        m_Strandedness = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Strandedness;
}

inline
bool CINSDSeq_Base::IsSetMoltype(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CINSDSeq_Base::CanGetMoltype(void) const
{
    return IsSetMoltype();
}

inline
const CINSDSeq_Base::TMoltype& CINSDSeq_Base::GetMoltype(void) const
{
    if (!CanGetMoltype()) {
        ThrowUnassigned(3);
    }
    return m_Moltype;
}

inline
void CINSDSeq_Base::SetMoltype(const CINSDSeq_Base::TMoltype& value)
{
    m_Moltype = value;
    m_set_State[0] |= 0xc0;
}

inline
void CINSDSeq_Base::SetMoltype(CINSDSeq_Base::TMoltype&& value)
{
    m_Moltype = std::forward<CINSDSeq_Base::TMoltype>(value);
    m_set_State[0] |= 0xc0;
}

inline
CINSDSeq_Base::TMoltype& CINSDSeq_Base::SetMoltype(void)
{
#ifdef _DEBUG
    if (!IsSetMoltype()) {
        m_Moltype = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Moltype;
}

inline
bool CINSDSeq_Base::IsSetTopology(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CINSDSeq_Base::CanGetTopology(void) const
{
    return IsSetTopology();
}

inline
const CINSDSeq_Base::TTopology& CINSDSeq_Base::GetTopology(void) const
{
    if (!CanGetTopology()) {
        ThrowUnassigned(4);
    }
    return m_Topology;
}

inline
void CINSDSeq_Base::SetTopology(const CINSDSeq_Base::TTopology& value)
{
    m_Topology = value;
    m_set_State[0] |= 0x300;
}

inline
void CINSDSeq_Base::SetTopology(CINSDSeq_Base::TTopology&& value)
{
    m_Topology = std::forward<CINSDSeq_Base::TTopology>(value);
    m_set_State[0] |= 0x300;
}

inline
CINSDSeq_Base::TTopology& CINSDSeq_Base::SetTopology(void)
{
#ifdef _DEBUG
    if (!IsSetTopology()) {
        m_Topology = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Topology;
}

inline
bool CINSDSeq_Base::IsSetDivision(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CINSDSeq_Base::CanGetDivision(void) const
{
    return IsSetDivision();
}

inline
const CINSDSeq_Base::TDivision& CINSDSeq_Base::GetDivision(void) const
{
    if (!CanGetDivision()) {
        ThrowUnassigned(5);
    }
    return m_Division;
}

inline
void CINSDSeq_Base::SetDivision(const CINSDSeq_Base::TDivision& value)
{
    m_Division = value;
    m_set_State[0] |= 0xc00;
}

inline
void CINSDSeq_Base::SetDivision(CINSDSeq_Base::TDivision&& value)
{
    m_Division = std::forward<CINSDSeq_Base::TDivision>(value);
    m_set_State[0] |= 0xc00;
}

inline
CINSDSeq_Base::TDivision& CINSDSeq_Base::SetDivision(void)
{
#ifdef _DEBUG
    if (!IsSetDivision()) {
        m_Division = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Division;
}

inline
bool CINSDSeq_Base::IsSetUpdate_date(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CINSDSeq_Base::CanGetUpdate_date(void) const
{
    return IsSetUpdate_date();
}

inline
const CINSDSeq_Base::TUpdate_date& CINSDSeq_Base::GetUpdate_date(void) const
{
    if (!CanGetUpdate_date()) {
        ThrowUnassigned(6);
    }
    return m_Update_date;
}

inline
void CINSDSeq_Base::SetUpdate_date(const CINSDSeq_Base::TUpdate_date& value)
{
    m_Update_date = value;
    m_set_State[0] |= 0x3000;
}

inline
void CINSDSeq_Base::SetUpdate_date(CINSDSeq_Base::TUpdate_date&& value)
{
    m_Update_date = std::forward<CINSDSeq_Base::TUpdate_date>(value);
    m_set_State[0] |= 0x3000;
}

inline
CINSDSeq_Base::TUpdate_date& CINSDSeq_Base::SetUpdate_date(void)
{
#ifdef _DEBUG
    if (!IsSetUpdate_date()) {
        m_Update_date = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Update_date;
}

inline
bool CINSDSeq_Base::IsSetCreate_date(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CINSDSeq_Base::CanGetCreate_date(void) const
{
    return IsSetCreate_date();
}

inline
const CINSDSeq_Base::TCreate_date& CINSDSeq_Base::GetCreate_date(void) const
{
    if (!CanGetCreate_date()) {
        ThrowUnassigned(7);
    }
    return m_Create_date;
}

inline
void CINSDSeq_Base::SetCreate_date(const CINSDSeq_Base::TCreate_date& value)
{
    m_Create_date = value;
    m_set_State[0] |= 0xc000;
}

inline
void CINSDSeq_Base::SetCreate_date(CINSDSeq_Base::TCreate_date&& value)
{
    m_Create_date = std::forward<CINSDSeq_Base::TCreate_date>(value);
    m_set_State[0] |= 0xc000;
}

inline
CINSDSeq_Base::TCreate_date& CINSDSeq_Base::SetCreate_date(void)
{
#ifdef _DEBUG
    if (!IsSetCreate_date()) {
        m_Create_date = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Create_date;
}

inline
bool CINSDSeq_Base::IsSetUpdate_release(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CINSDSeq_Base::CanGetUpdate_release(void) const
{
    return IsSetUpdate_release();
}

inline
const CINSDSeq_Base::TUpdate_release& CINSDSeq_Base::GetUpdate_release(void) const
{
    if (!CanGetUpdate_release()) {
        ThrowUnassigned(8);
    }
    return m_Update_release;
}

inline
void CINSDSeq_Base::SetUpdate_release(const CINSDSeq_Base::TUpdate_release& value)
{
    m_Update_release = value;
    m_set_State[0] |= 0x30000;
}

inline
void CINSDSeq_Base::SetUpdate_release(CINSDSeq_Base::TUpdate_release&& value)
{
    m_Update_release = std::forward<CINSDSeq_Base::TUpdate_release>(value);
    m_set_State[0] |= 0x30000;
}

inline
CINSDSeq_Base::TUpdate_release& CINSDSeq_Base::SetUpdate_release(void)
{
#ifdef _DEBUG
    if (!IsSetUpdate_release()) {
        m_Update_release = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Update_release;
}

inline
bool CINSDSeq_Base::IsSetCreate_release(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CINSDSeq_Base::CanGetCreate_release(void) const
{
    return IsSetCreate_release();
}

inline
const CINSDSeq_Base::TCreate_release& CINSDSeq_Base::GetCreate_release(void) const
{
    if (!CanGetCreate_release()) {
        ThrowUnassigned(9);
    }
    return m_Create_release;
}

inline
void CINSDSeq_Base::SetCreate_release(const CINSDSeq_Base::TCreate_release& value)
{
    m_Create_release = value;
    m_set_State[0] |= 0xc0000;
}

inline
void CINSDSeq_Base::SetCreate_release(CINSDSeq_Base::TCreate_release&& value)
{
    m_Create_release = std::forward<CINSDSeq_Base::TCreate_release>(value);
    m_set_State[0] |= 0xc0000;
}

inline
CINSDSeq_Base::TCreate_release& CINSDSeq_Base::SetCreate_release(void)
{
#ifdef _DEBUG
    if (!IsSetCreate_release()) {
        m_Create_release = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Create_release;
}

inline
bool CINSDSeq_Base::IsSetDefinition(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CINSDSeq_Base::CanGetDefinition(void) const
{
    return IsSetDefinition();
}

inline
const CINSDSeq_Base::TDefinition& CINSDSeq_Base::GetDefinition(void) const
{
    if (!CanGetDefinition()) {
        ThrowUnassigned(10);
    }
    return m_Definition;
}

inline
void CINSDSeq_Base::SetDefinition(const CINSDSeq_Base::TDefinition& value)
{
    m_Definition = value;
    m_set_State[0] |= 0x300000;
}

inline
void CINSDSeq_Base::SetDefinition(CINSDSeq_Base::TDefinition&& value)
{
    m_Definition = std::forward<CINSDSeq_Base::TDefinition>(value);
    m_set_State[0] |= 0x300000;
}

inline
CINSDSeq_Base::TDefinition& CINSDSeq_Base::SetDefinition(void)
{
#ifdef _DEBUG
    if (!IsSetDefinition()) {
        m_Definition = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100000;
    return m_Definition;
}

inline
bool CINSDSeq_Base::IsSetPrimary_accession(void) const
{
    return ((m_set_State[0] & 0xc00000) != 0);
}

inline
bool CINSDSeq_Base::CanGetPrimary_accession(void) const
{
    return IsSetPrimary_accession();
}

inline
const CINSDSeq_Base::TPrimary_accession& CINSDSeq_Base::GetPrimary_accession(void) const
{
    if (!CanGetPrimary_accession()) {
        ThrowUnassigned(11);
    }
    return m_Primary_accession;
}

inline
void CINSDSeq_Base::SetPrimary_accession(const CINSDSeq_Base::TPrimary_accession& value)
{
    m_Primary_accession = value;
    m_set_State[0] |= 0xc00000;
}

inline
void CINSDSeq_Base::SetPrimary_accession(CINSDSeq_Base::TPrimary_accession&& value)
{
    m_Primary_accession = std::forward<CINSDSeq_Base::TPrimary_accession>(value);
    m_set_State[0] |= 0xc00000;
}

inline
CINSDSeq_Base::TPrimary_accession& CINSDSeq_Base::SetPrimary_accession(void)
{
#ifdef _DEBUG
    if (!IsSetPrimary_accession()) {
        m_Primary_accession = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400000;
    return m_Primary_accession;
}

inline
bool CINSDSeq_Base::IsSetEntry_version(void) const
{
    return ((m_set_State[0] & 0x3000000) != 0);
}

inline
bool CINSDSeq_Base::CanGetEntry_version(void) const
{
    return IsSetEntry_version();
}

inline
const CINSDSeq_Base::TEntry_version& CINSDSeq_Base::GetEntry_version(void) const
{
    if (!CanGetEntry_version()) {
        ThrowUnassigned(12);
    }
    return m_Entry_version;
}

inline
void CINSDSeq_Base::SetEntry_version(const CINSDSeq_Base::TEntry_version& value)
{
    m_Entry_version = value;
    m_set_State[0] |= 0x3000000;
}

inline
void CINSDSeq_Base::SetEntry_version(CINSDSeq_Base::TEntry_version&& value)
{
    m_Entry_version = std::forward<CINSDSeq_Base::TEntry_version>(value);
    m_set_State[0] |= 0x3000000;
}

inline
CINSDSeq_Base::TEntry_version& CINSDSeq_Base::SetEntry_version(void)
{
#ifdef _DEBUG
    if (!IsSetEntry_version()) {
        m_Entry_version = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000000;
    return m_Entry_version;
}

inline
bool CINSDSeq_Base::IsSetAccession_version(void) const
{
    return ((m_set_State[0] & 0xc000000) != 0);
}

inline
bool CINSDSeq_Base::CanGetAccession_version(void) const
{
    return IsSetAccession_version();
}

inline
const CINSDSeq_Base::TAccession_version& CINSDSeq_Base::GetAccession_version(void) const
{
    if (!CanGetAccession_version()) {
        ThrowUnassigned(13);
    }
    return m_Accession_version;
}

inline
void CINSDSeq_Base::SetAccession_version(const CINSDSeq_Base::TAccession_version& value)
{
    m_Accession_version = value;
    m_set_State[0] |= 0xc000000;
}

inline
void CINSDSeq_Base::SetAccession_version(CINSDSeq_Base::TAccession_version&& value)
{
    m_Accession_version = std::forward<CINSDSeq_Base::TAccession_version>(value);
    m_set_State[0] |= 0xc000000;
}

inline
CINSDSeq_Base::TAccession_version& CINSDSeq_Base::SetAccession_version(void)
{
#ifdef _DEBUG
    if (!IsSetAccession_version()) {
        m_Accession_version = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000000;
    return m_Accession_version;
}

inline
bool CINSDSeq_Base::IsSetOther_seqids(void) const
{
    return ((m_set_State[0] & 0x30000000) != 0);
}

inline
bool CINSDSeq_Base::CanGetOther_seqids(void) const
{
    return true;
}

inline
const CINSDSeq_Base::TOther_seqids& CINSDSeq_Base::GetOther_seqids(void) const
{
    return m_Other_seqids;
}

inline
CINSDSeq_Base::TOther_seqids& CINSDSeq_Base::SetOther_seqids(void)
{
    m_set_State[0] |= 0x10000000;
    return m_Other_seqids;
}

inline
bool CINSDSeq_Base::IsSetSecondary_accessions(void) const
{
    return ((m_set_State[0] & 0xc0000000) != 0);
}

inline
bool CINSDSeq_Base::CanGetSecondary_accessions(void) const
{
    return true;
}

inline
const CINSDSeq_Base::TSecondary_accessions& CINSDSeq_Base::GetSecondary_accessions(void) const
{
    return m_Secondary_accessions;
}

inline
CINSDSeq_Base::TSecondary_accessions& CINSDSeq_Base::SetSecondary_accessions(void)
{
    m_set_State[0] |= 0x40000000;
    return m_Secondary_accessions;
}

inline
bool CINSDSeq_Base::IsSetProject(void) const
{
    return ((m_set_State[1] & 0x3) != 0);
}

inline
bool CINSDSeq_Base::CanGetProject(void) const
{
    return IsSetProject();
}

inline
const CINSDSeq_Base::TProject& CINSDSeq_Base::GetProject(void) const
{
    if (!CanGetProject()) {
        ThrowUnassigned(16);
    }
    return m_Project;
}

inline
void CINSDSeq_Base::SetProject(const CINSDSeq_Base::TProject& value)
{
    m_Project = value;
    m_set_State[1] |= 0x3;
}

inline
void CINSDSeq_Base::SetProject(CINSDSeq_Base::TProject&& value)
{
    m_Project = std::forward<CINSDSeq_Base::TProject>(value);
    m_set_State[1] |= 0x3;
}

inline
CINSDSeq_Base::TProject& CINSDSeq_Base::SetProject(void)
{
#ifdef _DEBUG
    if (!IsSetProject()) {
        m_Project = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x1;
    return m_Project;
}

inline
bool CINSDSeq_Base::IsSetKeywords(void) const
{
    return ((m_set_State[1] & 0xc) != 0);
}

inline
bool CINSDSeq_Base::CanGetKeywords(void) const
{
    return true;
}

inline
const CINSDSeq_Base::TKeywords& CINSDSeq_Base::GetKeywords(void) const
{
    return m_Keywords;
}

inline
CINSDSeq_Base::TKeywords& CINSDSeq_Base::SetKeywords(void)
{
    m_set_State[1] |= 0x4;
    return m_Keywords;
}

inline
bool CINSDSeq_Base::IsSetSegment(void) const
{
    return ((m_set_State[1] & 0x30) != 0);
}

inline
bool CINSDSeq_Base::CanGetSegment(void) const
{
    return IsSetSegment();
}

inline
const CINSDSeq_Base::TSegment& CINSDSeq_Base::GetSegment(void) const
{
    if (!CanGetSegment()) {
        ThrowUnassigned(18);
    }
    return m_Segment;
}

inline
void CINSDSeq_Base::SetSegment(const CINSDSeq_Base::TSegment& value)
{
    m_Segment = value;
    m_set_State[1] |= 0x30;
}

inline
void CINSDSeq_Base::SetSegment(CINSDSeq_Base::TSegment&& value)
{
    m_Segment = std::forward<CINSDSeq_Base::TSegment>(value);
    m_set_State[1] |= 0x30;
}

inline
CINSDSeq_Base::TSegment& CINSDSeq_Base::SetSegment(void)
{
#ifdef _DEBUG
    if (!IsSetSegment()) {
        m_Segment = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x10;
    return m_Segment;
}

inline
bool CINSDSeq_Base::IsSetSource(void) const
{
    return ((m_set_State[1] & 0xc0) != 0);
}

inline
bool CINSDSeq_Base::CanGetSource(void) const
{
    return IsSetSource();
}

inline
const CINSDSeq_Base::TSource& CINSDSeq_Base::GetSource(void) const
{
    if (!CanGetSource()) {
        ThrowUnassigned(19);
    }
    return m_Source;
}

inline
void CINSDSeq_Base::SetSource(const CINSDSeq_Base::TSource& value)
{
    m_Source = value;
    m_set_State[1] |= 0xc0;
}

inline
void CINSDSeq_Base::SetSource(CINSDSeq_Base::TSource&& value)
{
    m_Source = std::forward<CINSDSeq_Base::TSource>(value);
    m_set_State[1] |= 0xc0;
}

inline
CINSDSeq_Base::TSource& CINSDSeq_Base::SetSource(void)
{
#ifdef _DEBUG
    if (!IsSetSource()) {
        m_Source = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x40;
    return m_Source;
}

inline
bool CINSDSeq_Base::IsSetOrganism(void) const
{
    return ((m_set_State[1] & 0x300) != 0);
}

inline
bool CINSDSeq_Base::CanGetOrganism(void) const
{
    return IsSetOrganism();
}

inline
const CINSDSeq_Base::TOrganism& CINSDSeq_Base::GetOrganism(void) const
{
    if (!CanGetOrganism()) {
        ThrowUnassigned(20);
    }
    return m_Organism;
}

inline
void CINSDSeq_Base::SetOrganism(const CINSDSeq_Base::TOrganism& value)
{
    m_Organism = value;
    m_set_State[1] |= 0x300;
}

inline
void CINSDSeq_Base::SetOrganism(CINSDSeq_Base::TOrganism&& value)
{
    m_Organism = std::forward<CINSDSeq_Base::TOrganism>(value);
    m_set_State[1] |= 0x300;
}

inline
CINSDSeq_Base::TOrganism& CINSDSeq_Base::SetOrganism(void)
{
#ifdef _DEBUG
    if (!IsSetOrganism()) {
        m_Organism = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x100;
    return m_Organism;
}

inline
bool CINSDSeq_Base::IsSetTaxonomy(void) const
{
    return ((m_set_State[1] & 0xc00) != 0);
}

inline
bool CINSDSeq_Base::CanGetTaxonomy(void) const
{
    return IsSetTaxonomy();
}

inline
const CINSDSeq_Base::TTaxonomy& CINSDSeq_Base::GetTaxonomy(void) const
{
    if (!CanGetTaxonomy()) {
        ThrowUnassigned(21);
    }
    return m_Taxonomy;
}

inline
void CINSDSeq_Base::SetTaxonomy(const CINSDSeq_Base::TTaxonomy& value)
{
    m_Taxonomy = value;
    m_set_State[1] |= 0xc00;
}

inline
void CINSDSeq_Base::SetTaxonomy(CINSDSeq_Base::TTaxonomy&& value)
{
    m_Taxonomy = std::forward<CINSDSeq_Base::TTaxonomy>(value);
    m_set_State[1] |= 0xc00;
}

inline
CINSDSeq_Base::TTaxonomy& CINSDSeq_Base::SetTaxonomy(void)
{
#ifdef _DEBUG
    if (!IsSetTaxonomy()) {
        m_Taxonomy = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x400;
    return m_Taxonomy;
}

inline
bool CINSDSeq_Base::IsSetReferences(void) const
{
    return ((m_set_State[1] & 0x3000) != 0);
}

inline
bool CINSDSeq_Base::CanGetReferences(void) const
{
    return true;
}

inline
const CINSDSeq_Base::TReferences& CINSDSeq_Base::GetReferences(void) const
{
    return m_References;
}

inline
CINSDSeq_Base::TReferences& CINSDSeq_Base::SetReferences(void)
{
    m_set_State[1] |= 0x1000;
    return m_References;
}

inline
bool CINSDSeq_Base::IsSetComment(void) const
{
    return ((m_set_State[1] & 0xc000) != 0);
}

inline
bool CINSDSeq_Base::CanGetComment(void) const
{
    return IsSetComment();
}

inline
const CINSDSeq_Base::TComment& CINSDSeq_Base::GetComment(void) const
{
    if (!CanGetComment()) {
        ThrowUnassigned(23);
    }
    return m_Comment;
}

inline
void CINSDSeq_Base::SetComment(const CINSDSeq_Base::TComment& value)
{
    m_Comment = value;
    m_set_State[1] |= 0xc000;
}

inline
void CINSDSeq_Base::SetComment(CINSDSeq_Base::TComment&& value)
{
    m_Comment = std::forward<CINSDSeq_Base::TComment>(value);
    m_set_State[1] |= 0xc000;
}

inline
CINSDSeq_Base::TComment& CINSDSeq_Base::SetComment(void)
{
#ifdef _DEBUG
    if (!IsSetComment()) {
        m_Comment = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x4000;
    return m_Comment;
}

inline
bool CINSDSeq_Base::IsSetComment_set(void) const
{
    return ((m_set_State[1] & 0x30000) != 0);
}

inline
bool CINSDSeq_Base::CanGetComment_set(void) const
{
    return true;
}

inline
const CINSDSeq_Base::TComment_set& CINSDSeq_Base::GetComment_set(void) const
{
    return m_Comment_set;
}

inline
CINSDSeq_Base::TComment_set& CINSDSeq_Base::SetComment_set(void)
{
    m_set_State[1] |= 0x10000;
    return m_Comment_set;
}

inline
bool CINSDSeq_Base::IsSetStruc_comments(void) const
{
    return ((m_set_State[1] & 0xc0000) != 0);
}

inline
bool CINSDSeq_Base::CanGetStruc_comments(void) const
{
    return true;
}

inline
const CINSDSeq_Base::TStruc_comments& CINSDSeq_Base::GetStruc_comments(void) const
{
    return m_Struc_comments;
}

inline
CINSDSeq_Base::TStruc_comments& CINSDSeq_Base::SetStruc_comments(void)
{
    m_set_State[1] |= 0x40000;
    return m_Struc_comments;
}

inline
bool CINSDSeq_Base::IsSetPrimary(void) const
{
    return ((m_set_State[1] & 0x300000) != 0);
}

inline
bool CINSDSeq_Base::CanGetPrimary(void) const
{
    return IsSetPrimary();
}

inline
const CINSDSeq_Base::TPrimary& CINSDSeq_Base::GetPrimary(void) const
{
    if (!CanGetPrimary()) {
        ThrowUnassigned(26);
    }
    return m_Primary;
}

inline
void CINSDSeq_Base::SetPrimary(const CINSDSeq_Base::TPrimary& value)
{
    m_Primary = value;
    m_set_State[1] |= 0x300000;
}

inline
void CINSDSeq_Base::SetPrimary(CINSDSeq_Base::TPrimary&& value)
{
    m_Primary = std::forward<CINSDSeq_Base::TPrimary>(value);
    m_set_State[1] |= 0x300000;
}

inline
CINSDSeq_Base::TPrimary& CINSDSeq_Base::SetPrimary(void)
{
#ifdef _DEBUG
    if (!IsSetPrimary()) {
        m_Primary = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x100000;
    return m_Primary;
}

inline
bool CINSDSeq_Base::IsSetSource_db(void) const
{
    return ((m_set_State[1] & 0xc00000) != 0);
}

inline
bool CINSDSeq_Base::CanGetSource_db(void) const
{
    return IsSetSource_db();
}

inline
const CINSDSeq_Base::TSource_db& CINSDSeq_Base::GetSource_db(void) const
{
    if (!CanGetSource_db()) {
        ThrowUnassigned(27);
    }
    return m_Source_db;
}

inline
void CINSDSeq_Base::SetSource_db(const CINSDSeq_Base::TSource_db& value)
{
    m_Source_db = value;
    m_set_State[1] |= 0xc00000;
}

inline
void CINSDSeq_Base::SetSource_db(CINSDSeq_Base::TSource_db&& value)
{
    m_Source_db = std::forward<CINSDSeq_Base::TSource_db>(value);
    m_set_State[1] |= 0xc00000;
}

inline
CINSDSeq_Base::TSource_db& CINSDSeq_Base::SetSource_db(void)
{
#ifdef _DEBUG
    if (!IsSetSource_db()) {
        m_Source_db = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x400000;
    return m_Source_db;
}

inline
bool CINSDSeq_Base::IsSetDatabase_reference(void) const
{
    return ((m_set_State[1] & 0x3000000) != 0);
}

inline
bool CINSDSeq_Base::CanGetDatabase_reference(void) const
{
    return IsSetDatabase_reference();
}

inline
const CINSDSeq_Base::TDatabase_reference& CINSDSeq_Base::GetDatabase_reference(void) const
{
    if (!CanGetDatabase_reference()) {
        ThrowUnassigned(28);
    }
    return m_Database_reference;
}

inline
void CINSDSeq_Base::SetDatabase_reference(const CINSDSeq_Base::TDatabase_reference& value)
{
    m_Database_reference = value;
    m_set_State[1] |= 0x3000000;
}

inline
void CINSDSeq_Base::SetDatabase_reference(CINSDSeq_Base::TDatabase_reference&& value)
{
    m_Database_reference = std::forward<CINSDSeq_Base::TDatabase_reference>(value);
    m_set_State[1] |= 0x3000000;
}

inline
CINSDSeq_Base::TDatabase_reference& CINSDSeq_Base::SetDatabase_reference(void)
{
#ifdef _DEBUG
    if (!IsSetDatabase_reference()) {
        m_Database_reference = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x1000000;
    return m_Database_reference;
}

inline
bool CINSDSeq_Base::IsSetFeature_table(void) const
{
    return ((m_set_State[1] & 0xc000000) != 0);
}

inline
bool CINSDSeq_Base::CanGetFeature_table(void) const
{
    return true;
}

inline
const CINSDSeq_Base::TFeature_table& CINSDSeq_Base::GetFeature_table(void) const
{
    return m_Feature_table;
}

inline
CINSDSeq_Base::TFeature_table& CINSDSeq_Base::SetFeature_table(void)
{
    m_set_State[1] |= 0x4000000;
    return m_Feature_table;
}

inline
bool CINSDSeq_Base::IsSetFeature_set(void) const
{
    return ((m_set_State[1] & 0x30000000) != 0);
}

inline
bool CINSDSeq_Base::CanGetFeature_set(void) const
{
    return true;
}

inline
const CINSDSeq_Base::TFeature_set& CINSDSeq_Base::GetFeature_set(void) const
{
    return m_Feature_set;
}

inline
CINSDSeq_Base::TFeature_set& CINSDSeq_Base::SetFeature_set(void)
{
    m_set_State[1] |= 0x10000000;
    return m_Feature_set;
}

inline
bool CINSDSeq_Base::IsSetSequence(void) const
{
    return ((m_set_State[1] & 0xc0000000) != 0);
}

inline
bool CINSDSeq_Base::CanGetSequence(void) const
{
    return IsSetSequence();
}

inline
const CINSDSeq_Base::TSequence& CINSDSeq_Base::GetSequence(void) const
{
    if (!CanGetSequence()) {
        ThrowUnassigned(31);
    }
    return m_Sequence;
}

inline
void CINSDSeq_Base::SetSequence(const CINSDSeq_Base::TSequence& value)
{
    m_Sequence = value;
    m_set_State[1] |= 0xc0000000;
}

inline
void CINSDSeq_Base::SetSequence(CINSDSeq_Base::TSequence&& value)
{
    m_Sequence = std::forward<CINSDSeq_Base::TSequence>(value);
    m_set_State[1] |= 0xc0000000;
}

inline
CINSDSeq_Base::TSequence& CINSDSeq_Base::SetSequence(void)
{
#ifdef _DEBUG
    if (!IsSetSequence()) {
        m_Sequence = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x40000000;
    return m_Sequence;
}

inline
bool CINSDSeq_Base::IsSetContig(void) const
{
    return ((m_set_State[2] & 0x3) != 0);
}

inline
bool CINSDSeq_Base::CanGetContig(void) const
{
    return IsSetContig();
}

inline
const CINSDSeq_Base::TContig& CINSDSeq_Base::GetContig(void) const
{
    if (!CanGetContig()) {
        ThrowUnassigned(32);
    }
    return m_Contig;
}

inline
void CINSDSeq_Base::SetContig(const CINSDSeq_Base::TContig& value)
{
    m_Contig = value;
    m_set_State[2] |= 0x3;
}

inline
void CINSDSeq_Base::SetContig(CINSDSeq_Base::TContig&& value)
{
    m_Contig = std::forward<CINSDSeq_Base::TContig>(value);
    m_set_State[2] |= 0x3;
}

inline
CINSDSeq_Base::TContig& CINSDSeq_Base::SetContig(void)
{
#ifdef _DEBUG
    if (!IsSetContig()) {
        m_Contig = UnassignedString();
    }
#endif
    m_set_State[2] |= 0x1;
    return m_Contig;
}

inline
bool CINSDSeq_Base::IsSetAlt_seq(void) const
{
    return ((m_set_State[2] & 0xc) != 0);
}

inline
bool CINSDSeq_Base::CanGetAlt_seq(void) const
{
    return true;
}

inline
const CINSDSeq_Base::TAlt_seq& CINSDSeq_Base::GetAlt_seq(void) const
{
    return m_Alt_seq;
}

inline
CINSDSeq_Base::TAlt_seq& CINSDSeq_Base::SetAlt_seq(void)
{
    m_set_State[2] |= 0x4;
    return m_Alt_seq;
}

inline
bool CINSDSeq_Base::IsSetXrefs(void) const
{
    return ((m_set_State[2] & 0x30) != 0);
}

inline
bool CINSDSeq_Base::CanGetXrefs(void) const
{
    return true;
}

inline
const CINSDSeq_Base::TXrefs& CINSDSeq_Base::GetXrefs(void) const
{
    return m_Xrefs;
}

inline
CINSDSeq_Base::TXrefs& CINSDSeq_Base::SetXrefs(void)
{
    m_set_State[2] |= 0x10;
    return m_Xrefs;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_INSDSEQ_INSDSEQ_BASE_HPP
