/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ID2_Reply_Data_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'id2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ID2_ID2_REPLY_DATA_BASE_HPP
#define OBJECTS_ID2_ID2_REPLY_DATA_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <vector>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Data packing.
class NCBI_ID2_EXPORT CID2_Reply_Data_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CID2_Reply_Data_Base(void);
    // destructor
    virtual ~CID2_Reply_Data_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /// index of negotiated types
    /// recommended types
    ///   Seq-entry,
    ///   ID2S-Split-Info,
    ///   ID2S-Chunk
    enum EData_type {
        eData_type_seq_entry       = 0,
        eData_type_seq_annot       = 1,
        eData_type_id2s_split_info = 2,
        eData_type_id2s_chunk      = 3
    };
    
    /// Access to EData_type's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EData_type)(void);
    
    /// serialization format (ASN.1 binary, ASN.1 text)
    /// index of negotiated formats
    enum EData_format {
        eData_format_asn_binary = 0,
        eData_format_asn_text   = 1,
        eData_format_xml        = 2
    };
    
    /// Access to EData_format's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EData_format)(void);
    
    /// post serialization compression (plain, gzip, etc.)
    /// index of negotiated compressions
    enum EData_compression {
        eData_compression_none   = 0,
        eData_compression_gzip   = 1,
        eData_compression_nlmzip = 2,
        eData_compression_bzip2  = 3
    };
    
    /// Access to EData_compression's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EData_compression)(void);
    
    // types
    typedef int TData_type;
    typedef int TData_format;
    typedef int TData_compression;
    typedef list< vector< char >* > TData;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_data_type,
        e_data_format,
        e_data_compression,
        e_data
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// optional with default eData_type_seq_entry
    /// typedef int TData_type
    ///  Check whether the Data_type data member has been assigned a value.
    bool IsSetData_type(void) const;
    /// Check whether it is safe or not to call GetData_type method.
    bool CanGetData_type(void) const;
    void ResetData_type(void);
    void SetDefaultData_type(void);
    TData_type GetData_type(void) const;
    void SetData_type(TData_type value);
    TData_type& SetData_type(void);

    /// optional with default eData_format_asn_binary
    /// typedef int TData_format
    ///  Check whether the Data_format data member has been assigned a value.
    bool IsSetData_format(void) const;
    /// Check whether it is safe or not to call GetData_format method.
    bool CanGetData_format(void) const;
    void ResetData_format(void);
    void SetDefaultData_format(void);
    TData_format GetData_format(void) const;
    void SetData_format(TData_format value);
    TData_format& SetData_format(void);

    /// optional with default eData_compression_none
    /// typedef int TData_compression
    ///  Check whether the Data_compression data member has been assigned a value.
    bool IsSetData_compression(void) const;
    /// Check whether it is safe or not to call GetData_compression method.
    bool CanGetData_compression(void) const;
    void ResetData_compression(void);
    void SetDefaultData_compression(void);
    TData_compression GetData_compression(void) const;
    void SetData_compression(TData_compression value);
    TData_compression& SetData_compression(void);

    /// data blob
    /// mandatory
    /// typedef list< vector< char >* > TData
    ///  Check whether the Data data member has been assigned a value.
    bool IsSetData(void) const;
    /// Check whether it is safe or not to call GetData method.
    bool CanGetData(void) const;
    void ResetData(void);
    const TData& GetData(void) const;
    TData& SetData(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CID2_Reply_Data_Base(const CID2_Reply_Data_Base&);
    CID2_Reply_Data_Base& operator=(const CID2_Reply_Data_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Data_type;
    int m_Data_format;
    int m_Data_compression;
    list< vector< char >* > m_Data;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CID2_Reply_Data_Base::IsSetData_type(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CID2_Reply_Data_Base::CanGetData_type(void) const
{
    return true;
}

inline
void CID2_Reply_Data_Base::ResetData_type(void)
{
    m_Data_type = eData_type_seq_entry;
    m_set_State[0] &= ~0x3;
}

inline
void CID2_Reply_Data_Base::SetDefaultData_type(void)
{
    ResetData_type();
}

inline
CID2_Reply_Data_Base::TData_type CID2_Reply_Data_Base::GetData_type(void) const
{
    return m_Data_type;
}

inline
void CID2_Reply_Data_Base::SetData_type(CID2_Reply_Data_Base::TData_type value)
{
    m_Data_type = value;
    m_set_State[0] |= 0x3;
}

inline
CID2_Reply_Data_Base::TData_type& CID2_Reply_Data_Base::SetData_type(void)
{
#ifdef _DEBUG
    if (!IsSetData_type()) {
        memset(&m_Data_type,UnassignedByte(),sizeof(m_Data_type));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Data_type;
}

inline
bool CID2_Reply_Data_Base::IsSetData_format(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CID2_Reply_Data_Base::CanGetData_format(void) const
{
    return true;
}

inline
void CID2_Reply_Data_Base::ResetData_format(void)
{
    m_Data_format = eData_format_asn_binary;
    m_set_State[0] &= ~0xc;
}

inline
void CID2_Reply_Data_Base::SetDefaultData_format(void)
{
    ResetData_format();
}

inline
CID2_Reply_Data_Base::TData_format CID2_Reply_Data_Base::GetData_format(void) const
{
    return m_Data_format;
}

inline
void CID2_Reply_Data_Base::SetData_format(CID2_Reply_Data_Base::TData_format value)
{
    m_Data_format = value;
    m_set_State[0] |= 0xc;
}

inline
CID2_Reply_Data_Base::TData_format& CID2_Reply_Data_Base::SetData_format(void)
{
#ifdef _DEBUG
    if (!IsSetData_format()) {
        memset(&m_Data_format,UnassignedByte(),sizeof(m_Data_format));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Data_format;
}

inline
bool CID2_Reply_Data_Base::IsSetData_compression(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CID2_Reply_Data_Base::CanGetData_compression(void) const
{
    return true;
}

inline
void CID2_Reply_Data_Base::ResetData_compression(void)
{
    m_Data_compression = eData_compression_none;
    m_set_State[0] &= ~0x30;
}

inline
void CID2_Reply_Data_Base::SetDefaultData_compression(void)
{
    ResetData_compression();
}

inline
CID2_Reply_Data_Base::TData_compression CID2_Reply_Data_Base::GetData_compression(void) const
{
    return m_Data_compression;
}

inline
void CID2_Reply_Data_Base::SetData_compression(CID2_Reply_Data_Base::TData_compression value)
{
    m_Data_compression = value;
    m_set_State[0] |= 0x30;
}

inline
CID2_Reply_Data_Base::TData_compression& CID2_Reply_Data_Base::SetData_compression(void)
{
#ifdef _DEBUG
    if (!IsSetData_compression()) {
        memset(&m_Data_compression,UnassignedByte(),sizeof(m_Data_compression));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Data_compression;
}

inline
bool CID2_Reply_Data_Base::IsSetData(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CID2_Reply_Data_Base::CanGetData(void) const
{
    return true;
}

inline
const CID2_Reply_Data_Base::TData& CID2_Reply_Data_Base::GetData(void) const
{
    return m_Data;
}

inline
CID2_Reply_Data_Base::TData& CID2_Reply_Data_Base::SetData(void)
{
    m_set_State[0] |= 0x40;
    return m_Data;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ID2_ID2_REPLY_DATA_BASE_HPP
