/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ID1blob_info_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'id1.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ID1_ID1BLOB_INFO_BASE_HPP
#define OBJECTS_ID1_ID1BLOB_INFO_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_ID1_EXPORT CID1blob_info_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CID1blob_info_Base(void);
    // destructor
    virtual ~CID1blob_info_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef NCBI_NS_NCBI::TGi TGi;
    typedef int TSat;
    typedef int TSat_key;
    typedef string TSatname;
    typedef int TSuppress;
    typedef int TWithdrawn;
    typedef int TConfidential;
    typedef int TBlob_state;
    typedef string TComment;
    typedef int TExtfeatmask;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_gi,
        e_sat,
        e_sat_key,
        e_satname,
        e_suppress,
        e_withdrawn,
        e_confidential,
        e_blob_state,
        e_comment,
        e_extfeatmask
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 11> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef NCBI_NS_NCBI::TGi TGi
    ///  Check whether the Gi data member has been assigned a value.
    bool IsSetGi(void) const;
    /// Check whether it is safe or not to call GetGi method.
    bool CanGetGi(void) const;
    void ResetGi(void);
    TGi GetGi(void) const;
    void SetGi(TGi value);
    TGi& SetGi(void);

    /// mandatory
    /// typedef int TSat
    ///  Check whether the Sat data member has been assigned a value.
    bool IsSetSat(void) const;
    /// Check whether it is safe or not to call GetSat method.
    bool CanGetSat(void) const;
    void ResetSat(void);
    TSat GetSat(void) const;
    void SetSat(TSat value);
    TSat& SetSat(void);

    /// mandatory
    /// typedef int TSat_key
    ///  Check whether the Sat_key data member has been assigned a value.
    bool IsSetSat_key(void) const;
    /// Check whether it is safe or not to call GetSat_key method.
    bool CanGetSat_key(void) const;
    void ResetSat_key(void);
    TSat_key GetSat_key(void) const;
    void SetSat_key(TSat_key value);
    TSat_key& SetSat_key(void);

    /// mandatory
    /// typedef string TSatname
    ///  Check whether the Satname data member has been assigned a value.
    bool IsSetSatname(void) const;
    /// Check whether it is safe or not to call GetSatname method.
    bool CanGetSatname(void) const;
    void ResetSatname(void);
    const TSatname& GetSatname(void) const;
    void SetSatname(const TSatname& value);
    void SetSatname(TSatname&& value);
    TSatname& SetSatname(void);

    /// mandatory
    /// typedef int TSuppress
    ///  Check whether the Suppress data member has been assigned a value.
    bool IsSetSuppress(void) const;
    /// Check whether it is safe or not to call GetSuppress method.
    bool CanGetSuppress(void) const;
    void ResetSuppress(void);
    TSuppress GetSuppress(void) const;
    void SetSuppress(TSuppress value);
    TSuppress& SetSuppress(void);

    /// mandatory
    /// typedef int TWithdrawn
    ///  Check whether the Withdrawn data member has been assigned a value.
    bool IsSetWithdrawn(void) const;
    /// Check whether it is safe or not to call GetWithdrawn method.
    bool CanGetWithdrawn(void) const;
    void ResetWithdrawn(void);
    TWithdrawn GetWithdrawn(void) const;
    void SetWithdrawn(TWithdrawn value);
    TWithdrawn& SetWithdrawn(void);

    /// mandatory
    /// typedef int TConfidential
    ///  Check whether the Confidential data member has been assigned a value.
    bool IsSetConfidential(void) const;
    /// Check whether it is safe or not to call GetConfidential method.
    bool CanGetConfidential(void) const;
    void ResetConfidential(void);
    TConfidential GetConfidential(void) const;
    void SetConfidential(TConfidential value);
    TConfidential& SetConfidential(void);

    /// blob-state now contains blob version info.
    /// it's actually minutes from 01/01/1970
    /// and it's negative if blob is dead.
    /// mandatory
    /// typedef int TBlob_state
    ///  Check whether the Blob_state data member has been assigned a value.
    bool IsSetBlob_state(void) const;
    /// Check whether it is safe or not to call GetBlob_state method.
    bool CanGetBlob_state(void) const;
    void ResetBlob_state(void);
    TBlob_state GetBlob_state(void) const;
    void SetBlob_state(TBlob_state value);
    TBlob_state& SetBlob_state(void);

    /// public comment for withdrawn record 
    /// optional
    /// typedef string TComment
    ///  Check whether the Comment data member has been assigned a value.
    bool IsSetComment(void) const;
    /// Check whether it is safe or not to call GetComment method.
    bool CanGetComment(void) const;
    void ResetComment(void);
    const TComment& GetComment(void) const;
    void SetComment(const TComment& value);
    void SetComment(TComment&& value);
    TComment& SetComment(void);

    /// mask for external features (SNP,...)
    /// optional
    /// typedef int TExtfeatmask
    ///  Check whether the Extfeatmask data member has been assigned a value.
    bool IsSetExtfeatmask(void) const;
    /// Check whether it is safe or not to call GetExtfeatmask method.
    bool CanGetExtfeatmask(void) const;
    void ResetExtfeatmask(void);
    TExtfeatmask GetExtfeatmask(void) const;
    void SetExtfeatmask(TExtfeatmask value);
    TExtfeatmask& SetExtfeatmask(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CID1blob_info_Base(const CID1blob_info_Base&);
    CID1blob_info_Base& operator=(const CID1blob_info_Base&);

    // data
    Uint4 m_set_State[1];
    ncbi::TIntId m_Gi;
    int m_Sat;
    int m_Sat_key;
    string m_Satname;
    int m_Suppress;
    int m_Withdrawn;
    int m_Confidential;
    int m_Blob_state;
    string m_Comment;
    int m_Extfeatmask;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CID1blob_info_Base::IsSetGi(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CID1blob_info_Base::CanGetGi(void) const
{
    return IsSetGi();
}

inline
void CID1blob_info_Base::ResetGi(void)
{
    m_Gi = 0;
    m_set_State[0] &= ~0x3;
}

inline
CID1blob_info_Base::TGi CID1blob_info_Base::GetGi(void) const
{
    if (!CanGetGi()) {
        ThrowUnassigned(0);
    }
    return reinterpret_cast<const TGi&>(m_Gi);
}

inline
void CID1blob_info_Base::SetGi(CID1blob_info_Base::TGi value)
{
    reinterpret_cast<TGi&>(m_Gi) = value;
    m_set_State[0] |= 0x3;
}

inline
CID1blob_info_Base::TGi& CID1blob_info_Base::SetGi(void)
{
#ifdef _DEBUG
    if (!IsSetGi()) {
        memset(&m_Gi,UnassignedByte(),sizeof(m_Gi));
    }
#endif
    m_set_State[0] |= 0x1;
    return reinterpret_cast<TGi&>(m_Gi);
}

inline
bool CID1blob_info_Base::IsSetSat(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CID1blob_info_Base::CanGetSat(void) const
{
    return IsSetSat();
}

inline
void CID1blob_info_Base::ResetSat(void)
{
    m_Sat = 0;
    m_set_State[0] &= ~0xc;
}

inline
CID1blob_info_Base::TSat CID1blob_info_Base::GetSat(void) const
{
    if (!CanGetSat()) {
        ThrowUnassigned(1);
    }
    return m_Sat;
}

inline
void CID1blob_info_Base::SetSat(CID1blob_info_Base::TSat value)
{
    m_Sat = value;
    m_set_State[0] |= 0xc;
}

inline
CID1blob_info_Base::TSat& CID1blob_info_Base::SetSat(void)
{
#ifdef _DEBUG
    if (!IsSetSat()) {
        memset(&m_Sat,UnassignedByte(),sizeof(m_Sat));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Sat;
}

inline
bool CID1blob_info_Base::IsSetSat_key(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CID1blob_info_Base::CanGetSat_key(void) const
{
    return IsSetSat_key();
}

inline
void CID1blob_info_Base::ResetSat_key(void)
{
    m_Sat_key = 0;
    m_set_State[0] &= ~0x30;
}

inline
CID1blob_info_Base::TSat_key CID1blob_info_Base::GetSat_key(void) const
{
    if (!CanGetSat_key()) {
        ThrowUnassigned(2);
    }
    return m_Sat_key;
}

inline
void CID1blob_info_Base::SetSat_key(CID1blob_info_Base::TSat_key value)
{
    m_Sat_key = value;
    m_set_State[0] |= 0x30;
}

inline
CID1blob_info_Base::TSat_key& CID1blob_info_Base::SetSat_key(void)
{
#ifdef _DEBUG
    if (!IsSetSat_key()) {
        memset(&m_Sat_key,UnassignedByte(),sizeof(m_Sat_key));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Sat_key;
}

inline
bool CID1blob_info_Base::IsSetSatname(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CID1blob_info_Base::CanGetSatname(void) const
{
    return IsSetSatname();
}

inline
const CID1blob_info_Base::TSatname& CID1blob_info_Base::GetSatname(void) const
{
    if (!CanGetSatname()) {
        ThrowUnassigned(3);
    }
    return m_Satname;
}

inline
void CID1blob_info_Base::SetSatname(const CID1blob_info_Base::TSatname& value)
{
    m_Satname = value;
    m_set_State[0] |= 0xc0;
}

inline
void CID1blob_info_Base::SetSatname(CID1blob_info_Base::TSatname&& value)
{
    m_Satname = std::forward<CID1blob_info_Base::TSatname>(value);
    m_set_State[0] |= 0xc0;
}

inline
CID1blob_info_Base::TSatname& CID1blob_info_Base::SetSatname(void)
{
#ifdef _DEBUG
    if (!IsSetSatname()) {
        m_Satname = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Satname;
}

inline
bool CID1blob_info_Base::IsSetSuppress(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CID1blob_info_Base::CanGetSuppress(void) const
{
    return IsSetSuppress();
}

inline
void CID1blob_info_Base::ResetSuppress(void)
{
    m_Suppress = 0;
    m_set_State[0] &= ~0x300;
}

inline
CID1blob_info_Base::TSuppress CID1blob_info_Base::GetSuppress(void) const
{
    if (!CanGetSuppress()) {
        ThrowUnassigned(4);
    }
    return m_Suppress;
}

inline
void CID1blob_info_Base::SetSuppress(CID1blob_info_Base::TSuppress value)
{
    m_Suppress = value;
    m_set_State[0] |= 0x300;
}

inline
CID1blob_info_Base::TSuppress& CID1blob_info_Base::SetSuppress(void)
{
#ifdef _DEBUG
    if (!IsSetSuppress()) {
        memset(&m_Suppress,UnassignedByte(),sizeof(m_Suppress));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Suppress;
}

inline
bool CID1blob_info_Base::IsSetWithdrawn(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CID1blob_info_Base::CanGetWithdrawn(void) const
{
    return IsSetWithdrawn();
}

inline
void CID1blob_info_Base::ResetWithdrawn(void)
{
    m_Withdrawn = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CID1blob_info_Base::TWithdrawn CID1blob_info_Base::GetWithdrawn(void) const
{
    if (!CanGetWithdrawn()) {
        ThrowUnassigned(5);
    }
    return m_Withdrawn;
}

inline
void CID1blob_info_Base::SetWithdrawn(CID1blob_info_Base::TWithdrawn value)
{
    m_Withdrawn = value;
    m_set_State[0] |= 0xc00;
}

inline
CID1blob_info_Base::TWithdrawn& CID1blob_info_Base::SetWithdrawn(void)
{
#ifdef _DEBUG
    if (!IsSetWithdrawn()) {
        memset(&m_Withdrawn,UnassignedByte(),sizeof(m_Withdrawn));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Withdrawn;
}

inline
bool CID1blob_info_Base::IsSetConfidential(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CID1blob_info_Base::CanGetConfidential(void) const
{
    return IsSetConfidential();
}

inline
void CID1blob_info_Base::ResetConfidential(void)
{
    m_Confidential = 0;
    m_set_State[0] &= ~0x3000;
}

inline
CID1blob_info_Base::TConfidential CID1blob_info_Base::GetConfidential(void) const
{
    if (!CanGetConfidential()) {
        ThrowUnassigned(6);
    }
    return m_Confidential;
}

inline
void CID1blob_info_Base::SetConfidential(CID1blob_info_Base::TConfidential value)
{
    m_Confidential = value;
    m_set_State[0] |= 0x3000;
}

inline
CID1blob_info_Base::TConfidential& CID1blob_info_Base::SetConfidential(void)
{
#ifdef _DEBUG
    if (!IsSetConfidential()) {
        memset(&m_Confidential,UnassignedByte(),sizeof(m_Confidential));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Confidential;
}

inline
bool CID1blob_info_Base::IsSetBlob_state(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CID1blob_info_Base::CanGetBlob_state(void) const
{
    return IsSetBlob_state();
}

inline
void CID1blob_info_Base::ResetBlob_state(void)
{
    m_Blob_state = 0;
    m_set_State[0] &= ~0xc000;
}

inline
CID1blob_info_Base::TBlob_state CID1blob_info_Base::GetBlob_state(void) const
{
    if (!CanGetBlob_state()) {
        ThrowUnassigned(7);
    }
    return m_Blob_state;
}

inline
void CID1blob_info_Base::SetBlob_state(CID1blob_info_Base::TBlob_state value)
{
    m_Blob_state = value;
    m_set_State[0] |= 0xc000;
}

inline
CID1blob_info_Base::TBlob_state& CID1blob_info_Base::SetBlob_state(void)
{
#ifdef _DEBUG
    if (!IsSetBlob_state()) {
        memset(&m_Blob_state,UnassignedByte(),sizeof(m_Blob_state));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Blob_state;
}

inline
bool CID1blob_info_Base::IsSetComment(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CID1blob_info_Base::CanGetComment(void) const
{
    return IsSetComment();
}

inline
const CID1blob_info_Base::TComment& CID1blob_info_Base::GetComment(void) const
{
    if (!CanGetComment()) {
        ThrowUnassigned(8);
    }
    return m_Comment;
}

inline
void CID1blob_info_Base::SetComment(const CID1blob_info_Base::TComment& value)
{
    m_Comment = value;
    m_set_State[0] |= 0x30000;
}

inline
void CID1blob_info_Base::SetComment(CID1blob_info_Base::TComment&& value)
{
    m_Comment = std::forward<CID1blob_info_Base::TComment>(value);
    m_set_State[0] |= 0x30000;
}

inline
CID1blob_info_Base::TComment& CID1blob_info_Base::SetComment(void)
{
#ifdef _DEBUG
    if (!IsSetComment()) {
        m_Comment = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Comment;
}

inline
bool CID1blob_info_Base::IsSetExtfeatmask(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CID1blob_info_Base::CanGetExtfeatmask(void) const
{
    return IsSetExtfeatmask();
}

inline
void CID1blob_info_Base::ResetExtfeatmask(void)
{
    m_Extfeatmask = 0;
    m_set_State[0] &= ~0xc0000;
}

inline
CID1blob_info_Base::TExtfeatmask CID1blob_info_Base::GetExtfeatmask(void) const
{
    if (!CanGetExtfeatmask()) {
        ThrowUnassigned(9);
    }
    return m_Extfeatmask;
}

inline
void CID1blob_info_Base::SetExtfeatmask(CID1blob_info_Base::TExtfeatmask value)
{
    m_Extfeatmask = value;
    m_set_State[0] |= 0xc0000;
}

inline
CID1blob_info_Base::TExtfeatmask& CID1blob_info_Base::SetExtfeatmask(void)
{
#ifdef _DEBUG
    if (!IsSetExtfeatmask()) {
        memset(&m_Extfeatmask,UnassignedByte(),sizeof(m_Extfeatmask));
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Extfeatmask;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ID1_ID1BLOB_INFO_BASE_HPP
