/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file HG_EntrySet_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'homologene.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_HOMOLOGENE_HG_ENTRYSET_BASE_HPP
#define OBJECTS_HOMOLOGENE_HG_ENTRYSET_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CHG_Entry;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// HomoloGeneEntry taxid is the tax id of the group node, which can
/// be the same as the Gene tax id in case of singletons
class CHG_EntrySet_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CHG_EntrySet_Base(void);
    // destructor
    virtual ~CHG_EntrySet_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CHG_Entry C_E;
    typedef list< CRef< CHG_Entry > > TEntries;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_entries
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;

    // getters
    // setters

    /// homologene entry
    /// mandatory
    /// typedef list< CRef< CHG_Entry > > TEntries
    ///  Check whether the Entries data member has been assigned a value.
    bool IsSetEntries(void) const;
    /// Check whether it is safe or not to call GetEntries method.
    bool CanGetEntries(void) const;
    void ResetEntries(void);
    const TEntries& GetEntries(void) const;
    TEntries& SetEntries(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CHG_EntrySet_Base(const CHG_EntrySet_Base&);
    CHG_EntrySet_Base& operator=(const CHG_EntrySet_Base&);

    // data
    Uint4 m_set_State[1];
    list< CRef< CHG_Entry > > m_Entries;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CHG_EntrySet_Base::IsSetEntries(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CHG_EntrySet_Base::CanGetEntries(void) const
{
    return true;
}

inline
const CHG_EntrySet_Base::TEntries& CHG_EntrySet_Base::GetEntries(void) const
{
    return m_Entries;
}

inline
CHG_EntrySet_Base::TEntries& CHG_EntrySet_Base::SetEntries(void)
{
    m_set_State[0] |= 0x1;
    return m_Entries;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_HOMOLOGENE_HG_ENTRYSET_BASE_HPP
