/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file entrez2_client_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'entrez2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ENTREZ2_ENTREZ2_CLIENT_BASE_HPP
#define OBJECTS_ENTREZ2_ENTREZ2_CLIENT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/entrez2/E2Reply.hpp>
#include <objects/entrez2/E2Request.hpp>
#include <objects/entrez2/Entrez2_reply.hpp>
#include <objects/entrez2/Entrez2_request.hpp>
#include <serial/rpcbase.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_ENTREZ2_EXPORT CEntrez2Client_Base : public CRPCClient<CEntrez2_request, CEntrez2_reply>
{
    typedef CRPCClient<CEntrez2_request, CEntrez2_reply> Tparent;
public:
    // constructor
    CEntrez2Client_Base(void);
    // destructor
    virtual ~CEntrez2Client_Base(void);

    typedef CEntrez2_request TRequest;
    typedef CEntrez2_reply TReply;
    typedef CE2Request TRequestChoice;
    typedef CE2Reply TReplyChoice;

    virtual void Ask(const TRequest& request, TReply& reply);
    virtual void Ask(const TRequest& request, TReply& reply,
                     TReplyChoice::E_Choice wanted);


    virtual const TRequest& GetDefaultRequest(void) const;
    virtual TRequest&       SetDefaultRequest(void);
    virtual void            SetDefaultRequest(const TRequest& request);

    virtual void Ask(const TRequestChoice& req, TReply& reply);
    virtual void Ask(const TRequestChoice& req, TReply& reply,
                     TReplyChoice::E_Choice wanted);

    virtual CRef<CEntrez2_info> AskGet_info
        (TReply* reply = 0);

    virtual CRef<CEntrez2_boolean_reply> AskEval_boolean
        (const CEntrez2_eval_boolean& req, TReply* reply = 0);

    virtual CRef<CEntrez2_docsum_list> AskGet_docsum
        (const CEntrez2_id_list& req, TReply* reply = 0);

    virtual int AskGet_term_pos
        (const CEntrez2_term_query& req, TReply* reply = 0);

    virtual CRef<CEntrez2_term_list> AskGet_term_list
        (const CEntrez2_term_pos& req, TReply* reply = 0);

    virtual CRef<CEntrez2_hier_node> AskGet_term_hierarchy
        (const CEntrez2_hier_query& req, TReply* reply = 0);

    virtual CRef<CEntrez2_link_set> AskGet_links
        (const CEntrez2_get_links& req, TReply* reply = 0);

    virtual CRef<CEntrez2_id_list> AskGet_linked
        (const CEntrez2_get_links& req, TReply* reply = 0);

    virtual CRef<CEntrez2_link_count_list> AskGet_link_counts
        (const CEntrez2_id& req, TReply* reply = 0);


private:
    CRef<TRequest> m_DefaultRequest;

    TReplyChoice& x_Choice(TReply& reply);
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CEntrez2Client_Base::TReplyChoice& CEntrez2Client_Base::x_Choice(CEntrez2Client_Base::TReply& reply)
{
    return reply.SetReply();
}

inline
void CEntrez2Client_Base::Ask(const CEntrez2Client_Base::TRequest& request, CEntrez2Client_Base::TReply& reply)
{
    Tparent::Ask(request, reply);
}


inline
const CEntrez2Client_Base::TRequest& CEntrez2Client_Base::GetDefaultRequest(void) const
{
    return *m_DefaultRequest;
}

inline
CEntrez2Client_Base::TRequest& CEntrez2Client_Base::SetDefaultRequest(void)
{
    return *m_DefaultRequest;
}

inline
void CEntrez2Client_Base::SetDefaultRequest(const CEntrez2Client_Base::TRequest& request)
{
    m_DefaultRequest->Assign(request);
}


///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ENTREZ2_ENTREZ2_CLIENT_BASE_HPP
