/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Entrez2_link_count_list_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'entrez2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ENTREZ2_ENTREZ2_LINK_COUNT_LIST_BASE_HPP
#define OBJECTS_ENTREZ2_ENTREZ2_LINK_COUNT_LIST_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CEntrez2_link_count;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// all links from 1 uid
class NCBI_ENTREZ2_EXPORT CEntrez2_link_count_list_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CEntrez2_link_count_list_Base(void);
    // destructor
    virtual ~CEntrez2_link_count_list_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TLink_type_count;
    typedef list< CRef< CEntrez2_link_count > > TLinks;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_link_type_count,
        e_links
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// number of types of links
    /// mandatory
    /// typedef int TLink_type_count
    ///  Check whether the Link_type_count data member has been assigned a value.
    bool IsSetLink_type_count(void) const;
    /// Check whether it is safe or not to call GetLink_type_count method.
    bool CanGetLink_type_count(void) const;
    void ResetLink_type_count(void);
    TLink_type_count GetLink_type_count(void) const;
    void SetLink_type_count(TLink_type_count value);
    TLink_type_count& SetLink_type_count(void);

    /// mandatory
    /// typedef list< CRef< CEntrez2_link_count > > TLinks
    ///  Check whether the Links data member has been assigned a value.
    bool IsSetLinks(void) const;
    /// Check whether it is safe or not to call GetLinks method.
    bool CanGetLinks(void) const;
    void ResetLinks(void);
    const TLinks& GetLinks(void) const;
    TLinks& SetLinks(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CEntrez2_link_count_list_Base(const CEntrez2_link_count_list_Base&);
    CEntrez2_link_count_list_Base& operator=(const CEntrez2_link_count_list_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Link_type_count;
    list< CRef< CEntrez2_link_count > > m_Links;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CEntrez2_link_count_list_Base::IsSetLink_type_count(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CEntrez2_link_count_list_Base::CanGetLink_type_count(void) const
{
    return IsSetLink_type_count();
}

inline
void CEntrez2_link_count_list_Base::ResetLink_type_count(void)
{
    m_Link_type_count = 0;
    m_set_State[0] &= ~0x3;
}

inline
CEntrez2_link_count_list_Base::TLink_type_count CEntrez2_link_count_list_Base::GetLink_type_count(void) const
{
    if (!CanGetLink_type_count()) {
        ThrowUnassigned(0);
    }
    return m_Link_type_count;
}

inline
void CEntrez2_link_count_list_Base::SetLink_type_count(CEntrez2_link_count_list_Base::TLink_type_count value)
{
    m_Link_type_count = value;
    m_set_State[0] |= 0x3;
}

inline
CEntrez2_link_count_list_Base::TLink_type_count& CEntrez2_link_count_list_Base::SetLink_type_count(void)
{
#ifdef _DEBUG
    if (!IsSetLink_type_count()) {
        memset(&m_Link_type_count,UnassignedByte(),sizeof(m_Link_type_count));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Link_type_count;
}

inline
bool CEntrez2_link_count_list_Base::IsSetLinks(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CEntrez2_link_count_list_Base::CanGetLinks(void) const
{
    return true;
}

inline
const CEntrez2_link_count_list_Base::TLinks& CEntrez2_link_count_list_Base::GetLinks(void) const
{
    return m_Links;
}

inline
CEntrez2_link_count_list_Base::TLinks& CEntrez2_link_count_list_Base::SetLinks(void)
{
    m_set_State[0] |= 0x4;
    return m_Links;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ENTREZ2_ENTREZ2_LINK_COUNT_LIST_BASE_HPP
