/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file RsStruct_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'docsum.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_DOCSUM_RSSTRUCT_BASE_HPP
#define OBJECTS_DOCSUM_RSSTRUCT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
///structure information for SNP
class NCBI_DOCSUM_EXPORT CRsStruct_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CRsStruct_Base(void);
    // destructor
    virtual ~CRsStruct_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_DOCSUM_EXPORT C_Attlist : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef string TProtAcc;
        typedef int TProtGi;
        typedef int TProtLoc;
        typedef string TProtResidue;
        typedef string TRsResidue;
        typedef int TStructGi;
        typedef int TStructLoc;
        typedef string TStructResidue;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_protAcc,
            e_protGi,
            e_protLoc,
            e_protResidue,
            e_rsResidue,
            e_structGi,
            e_structLoc,
            e_structResidue
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 9> TmemberIndex;
    
        // getters
        // setters
    
        ///accession of the protein with variation
        /// optional
        /// typedef string TProtAcc
        ///  Check whether the ProtAcc data member has been assigned a value.
        bool IsSetProtAcc(void) const;
        /// Check whether it is safe or not to call GetProtAcc method.
        bool CanGetProtAcc(void) const;
        void ResetProtAcc(void);
        const TProtAcc& GetProtAcc(void) const;
        void SetProtAcc(const TProtAcc& value);
        void SetProtAcc(TProtAcc&& value);
        TProtAcc& SetProtAcc(void);
    
        ///GI of the protein with variation
        /// optional
        /// typedef int TProtGi
        ///  Check whether the ProtGi data member has been assigned a value.
        bool IsSetProtGi(void) const;
        /// Check whether it is safe or not to call GetProtGi method.
        bool CanGetProtGi(void) const;
        void ResetProtGi(void);
        TProtGi GetProtGi(void) const;
        void SetProtGi(TProtGi value);
        TProtGi& SetProtGi(void);
    
        ///position of the residue for the protein
        ///						GI
        /// optional
        /// typedef int TProtLoc
        ///  Check whether the ProtLoc data member has been assigned a value.
        bool IsSetProtLoc(void) const;
        /// Check whether it is safe or not to call GetProtLoc method.
        bool CanGetProtLoc(void) const;
        void ResetProtLoc(void);
        TProtLoc GetProtLoc(void) const;
        void SetProtLoc(TProtLoc value);
        TProtLoc& SetProtLoc(void);
    
        ///residue specified for protein at prot-loc
        ///						location
        /// optional
        /// typedef string TProtResidue
        ///  Check whether the ProtResidue data member has been assigned a value.
        bool IsSetProtResidue(void) const;
        /// Check whether it is safe or not to call GetProtResidue method.
        bool CanGetProtResidue(void) const;
        void ResetProtResidue(void);
        const TProtResidue& GetProtResidue(void) const;
        void SetProtResidue(const TProtResidue& value);
        void SetProtResidue(TProtResidue&& value);
        TProtResidue& SetProtResidue(void);
    
        ///alternative residue specified by variation
        ///						sequence
        /// optional
        /// typedef string TRsResidue
        ///  Check whether the RsResidue data member has been assigned a value.
        bool IsSetRsResidue(void) const;
        /// Check whether it is safe or not to call GetRsResidue method.
        bool CanGetRsResidue(void) const;
        void ResetRsResidue(void);
        const TRsResidue& GetRsResidue(void) const;
        void SetRsResidue(const TRsResidue& value);
        void SetRsResidue(TRsResidue&& value);
        TRsResidue& SetRsResidue(void);
    
        ///GI of the structure neighbor
        /// optional
        /// typedef int TStructGi
        ///  Check whether the StructGi data member has been assigned a value.
        bool IsSetStructGi(void) const;
        /// Check whether it is safe or not to call GetStructGi method.
        bool CanGetStructGi(void) const;
        void ResetStructGi(void);
        TStructGi GetStructGi(void) const;
        void SetStructGi(TStructGi value);
        TStructGi& SetStructGi(void);
    
        ///position of the residue for the structure
        ///						GI
        /// optional
        /// typedef int TStructLoc
        ///  Check whether the StructLoc data member has been assigned a value.
        bool IsSetStructLoc(void) const;
        /// Check whether it is safe or not to call GetStructLoc method.
        bool CanGetStructLoc(void) const;
        void ResetStructLoc(void);
        TStructLoc GetStructLoc(void) const;
        void SetStructLoc(TStructLoc value);
        TStructLoc& SetStructLoc(void);
    
        ///residue specified for protein at struct-loc
        ///						location
        /// optional
        /// typedef string TStructResidue
        ///  Check whether the StructResidue data member has been assigned a value.
        bool IsSetStructResidue(void) const;
        /// Check whether it is safe or not to call GetStructResidue method.
        bool CanGetStructResidue(void) const;
        void ResetStructResidue(void);
        const TStructResidue& GetStructResidue(void) const;
        void SetStructResidue(const TStructResidue& value);
        void SetStructResidue(TStructResidue&& value);
        TStructResidue& SetStructResidue(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        string m_ProtAcc;
        int m_ProtGi;
        int m_ProtLoc;
        string m_ProtResidue;
        string m_RsResidue;
        int m_StructGi;
        int m_StructLoc;
        string m_StructResidue;
    };
    // types
    typedef C_Attlist TAttlist;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_attlist,
        e_rsStruct
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    ///structure information for SNP
    /// mandatory
    ///  Check whether the RsStruct data member has been assigned a value.
    bool IsSetRsStruct(void) const;
    /// Check whether it is safe or not to call GetRsStruct method.
    bool CanGetRsStruct(void) const;
    void ResetRsStruct(void);
    void SetRsStruct(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CRsStruct_Base(const CRsStruct_Base&);
    CRsStruct_Base& operator=(const CRsStruct_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TAttlist > m_Attlist;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CRsStruct_Base::C_Attlist::IsSetProtAcc(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CRsStruct_Base::C_Attlist::CanGetProtAcc(void) const
{
    return IsSetProtAcc();
}

inline
const CRsStruct_Base::C_Attlist::TProtAcc& CRsStruct_Base::C_Attlist::GetProtAcc(void) const
{
    if (!CanGetProtAcc()) {
        ThrowUnassigned(0);
    }
    return m_ProtAcc;
}

inline
void CRsStruct_Base::C_Attlist::SetProtAcc(const CRsStruct_Base::C_Attlist::TProtAcc& value)
{
    m_ProtAcc = value;
    m_set_State[0] |= 0x3;
}

inline
void CRsStruct_Base::C_Attlist::SetProtAcc(CRsStruct_Base::C_Attlist::TProtAcc&& value)
{
    m_ProtAcc = std::forward<CRsStruct_Base::C_Attlist::TProtAcc>(value);
    m_set_State[0] |= 0x3;
}

inline
CRsStruct_Base::C_Attlist::TProtAcc& CRsStruct_Base::C_Attlist::SetProtAcc(void)
{
#ifdef _DEBUG
    if (!IsSetProtAcc()) {
        m_ProtAcc = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_ProtAcc;
}

inline
bool CRsStruct_Base::C_Attlist::IsSetProtGi(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CRsStruct_Base::C_Attlist::CanGetProtGi(void) const
{
    return IsSetProtGi();
}

inline
void CRsStruct_Base::C_Attlist::ResetProtGi(void)
{
    m_ProtGi = 0;
    m_set_State[0] &= ~0xc;
}

inline
CRsStruct_Base::C_Attlist::TProtGi CRsStruct_Base::C_Attlist::GetProtGi(void) const
{
    if (!CanGetProtGi()) {
        ThrowUnassigned(1);
    }
    return m_ProtGi;
}

inline
void CRsStruct_Base::C_Attlist::SetProtGi(CRsStruct_Base::C_Attlist::TProtGi value)
{
    m_ProtGi = value;
    m_set_State[0] |= 0xc;
}

inline
CRsStruct_Base::C_Attlist::TProtGi& CRsStruct_Base::C_Attlist::SetProtGi(void)
{
#ifdef _DEBUG
    if (!IsSetProtGi()) {
        memset(&m_ProtGi,UnassignedByte(),sizeof(m_ProtGi));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_ProtGi;
}

inline
bool CRsStruct_Base::C_Attlist::IsSetProtLoc(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CRsStruct_Base::C_Attlist::CanGetProtLoc(void) const
{
    return IsSetProtLoc();
}

inline
void CRsStruct_Base::C_Attlist::ResetProtLoc(void)
{
    m_ProtLoc = 0;
    m_set_State[0] &= ~0x30;
}

inline
CRsStruct_Base::C_Attlist::TProtLoc CRsStruct_Base::C_Attlist::GetProtLoc(void) const
{
    if (!CanGetProtLoc()) {
        ThrowUnassigned(2);
    }
    return m_ProtLoc;
}

inline
void CRsStruct_Base::C_Attlist::SetProtLoc(CRsStruct_Base::C_Attlist::TProtLoc value)
{
    m_ProtLoc = value;
    m_set_State[0] |= 0x30;
}

inline
CRsStruct_Base::C_Attlist::TProtLoc& CRsStruct_Base::C_Attlist::SetProtLoc(void)
{
#ifdef _DEBUG
    if (!IsSetProtLoc()) {
        memset(&m_ProtLoc,UnassignedByte(),sizeof(m_ProtLoc));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_ProtLoc;
}

inline
bool CRsStruct_Base::C_Attlist::IsSetProtResidue(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CRsStruct_Base::C_Attlist::CanGetProtResidue(void) const
{
    return IsSetProtResidue();
}

inline
const CRsStruct_Base::C_Attlist::TProtResidue& CRsStruct_Base::C_Attlist::GetProtResidue(void) const
{
    if (!CanGetProtResidue()) {
        ThrowUnassigned(3);
    }
    return m_ProtResidue;
}

inline
void CRsStruct_Base::C_Attlist::SetProtResidue(const CRsStruct_Base::C_Attlist::TProtResidue& value)
{
    m_ProtResidue = value;
    m_set_State[0] |= 0xc0;
}

inline
void CRsStruct_Base::C_Attlist::SetProtResidue(CRsStruct_Base::C_Attlist::TProtResidue&& value)
{
    m_ProtResidue = std::forward<CRsStruct_Base::C_Attlist::TProtResidue>(value);
    m_set_State[0] |= 0xc0;
}

inline
CRsStruct_Base::C_Attlist::TProtResidue& CRsStruct_Base::C_Attlist::SetProtResidue(void)
{
#ifdef _DEBUG
    if (!IsSetProtResidue()) {
        m_ProtResidue = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_ProtResidue;
}

inline
bool CRsStruct_Base::C_Attlist::IsSetRsResidue(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CRsStruct_Base::C_Attlist::CanGetRsResidue(void) const
{
    return IsSetRsResidue();
}

inline
const CRsStruct_Base::C_Attlist::TRsResidue& CRsStruct_Base::C_Attlist::GetRsResidue(void) const
{
    if (!CanGetRsResidue()) {
        ThrowUnassigned(4);
    }
    return m_RsResidue;
}

inline
void CRsStruct_Base::C_Attlist::SetRsResidue(const CRsStruct_Base::C_Attlist::TRsResidue& value)
{
    m_RsResidue = value;
    m_set_State[0] |= 0x300;
}

inline
void CRsStruct_Base::C_Attlist::SetRsResidue(CRsStruct_Base::C_Attlist::TRsResidue&& value)
{
    m_RsResidue = std::forward<CRsStruct_Base::C_Attlist::TRsResidue>(value);
    m_set_State[0] |= 0x300;
}

inline
CRsStruct_Base::C_Attlist::TRsResidue& CRsStruct_Base::C_Attlist::SetRsResidue(void)
{
#ifdef _DEBUG
    if (!IsSetRsResidue()) {
        m_RsResidue = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_RsResidue;
}

inline
bool CRsStruct_Base::C_Attlist::IsSetStructGi(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CRsStruct_Base::C_Attlist::CanGetStructGi(void) const
{
    return IsSetStructGi();
}

inline
void CRsStruct_Base::C_Attlist::ResetStructGi(void)
{
    m_StructGi = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CRsStruct_Base::C_Attlist::TStructGi CRsStruct_Base::C_Attlist::GetStructGi(void) const
{
    if (!CanGetStructGi()) {
        ThrowUnassigned(5);
    }
    return m_StructGi;
}

inline
void CRsStruct_Base::C_Attlist::SetStructGi(CRsStruct_Base::C_Attlist::TStructGi value)
{
    m_StructGi = value;
    m_set_State[0] |= 0xc00;
}

inline
CRsStruct_Base::C_Attlist::TStructGi& CRsStruct_Base::C_Attlist::SetStructGi(void)
{
#ifdef _DEBUG
    if (!IsSetStructGi()) {
        memset(&m_StructGi,UnassignedByte(),sizeof(m_StructGi));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_StructGi;
}

inline
bool CRsStruct_Base::C_Attlist::IsSetStructLoc(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CRsStruct_Base::C_Attlist::CanGetStructLoc(void) const
{
    return IsSetStructLoc();
}

inline
void CRsStruct_Base::C_Attlist::ResetStructLoc(void)
{
    m_StructLoc = 0;
    m_set_State[0] &= ~0x3000;
}

inline
CRsStruct_Base::C_Attlist::TStructLoc CRsStruct_Base::C_Attlist::GetStructLoc(void) const
{
    if (!CanGetStructLoc()) {
        ThrowUnassigned(6);
    }
    return m_StructLoc;
}

inline
void CRsStruct_Base::C_Attlist::SetStructLoc(CRsStruct_Base::C_Attlist::TStructLoc value)
{
    m_StructLoc = value;
    m_set_State[0] |= 0x3000;
}

inline
CRsStruct_Base::C_Attlist::TStructLoc& CRsStruct_Base::C_Attlist::SetStructLoc(void)
{
#ifdef _DEBUG
    if (!IsSetStructLoc()) {
        memset(&m_StructLoc,UnassignedByte(),sizeof(m_StructLoc));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_StructLoc;
}

inline
bool CRsStruct_Base::C_Attlist::IsSetStructResidue(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CRsStruct_Base::C_Attlist::CanGetStructResidue(void) const
{
    return IsSetStructResidue();
}

inline
const CRsStruct_Base::C_Attlist::TStructResidue& CRsStruct_Base::C_Attlist::GetStructResidue(void) const
{
    if (!CanGetStructResidue()) {
        ThrowUnassigned(7);
    }
    return m_StructResidue;
}

inline
void CRsStruct_Base::C_Attlist::SetStructResidue(const CRsStruct_Base::C_Attlist::TStructResidue& value)
{
    m_StructResidue = value;
    m_set_State[0] |= 0xc000;
}

inline
void CRsStruct_Base::C_Attlist::SetStructResidue(CRsStruct_Base::C_Attlist::TStructResidue&& value)
{
    m_StructResidue = std::forward<CRsStruct_Base::C_Attlist::TStructResidue>(value);
    m_set_State[0] |= 0xc000;
}

inline
CRsStruct_Base::C_Attlist::TStructResidue& CRsStruct_Base::C_Attlist::SetStructResidue(void)
{
#ifdef _DEBUG
    if (!IsSetStructResidue()) {
        m_StructResidue = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_StructResidue;
}

inline
bool CRsStruct_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CRsStruct_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CRsStruct_Base::TAttlist& CRsStruct_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CRsStruct_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CRsStruct_Base::TAttlist& CRsStruct_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CRsStruct_Base::IsSetRsStruct(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CRsStruct_Base::CanGetRsStruct(void) const
{
    return false;
}

inline
void CRsStruct_Base::ResetRsStruct(void)
{
    m_set_State[0] &= ~0xc;
}

inline
void CRsStruct_Base::SetRsStruct(void)
{
    m_set_State[0] |= 0xc;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_DOCSUM_RSSTRUCT_BASE_HPP
