/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Blas_get_searc_statu_reply_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blast.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLAST_BLAS_GET_SEARC_STATU_REPLY_BASE_HPP
#define OBJECTS_BLAST_BLAS_GET_SEARC_STATU_REPLY_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Reply to retrieve the status of a given search
class NCBI_BLAST_EXPORT CBlast4_get_search_status_reply_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBlast4_get_search_status_reply_Base(void);
    // destructor
    virtual ~CBlast4_get_search_status_reply_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TStatus;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_status
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TStatus
    ///  Check whether the Status data member has been assigned a value.
    bool IsSetStatus(void) const;
    /// Check whether it is safe or not to call GetStatus method.
    bool CanGetStatus(void) const;
    void ResetStatus(void);
    const TStatus& GetStatus(void) const;
    void SetStatus(const TStatus& value);
    void SetStatus(TStatus&& value);
    TStatus& SetStatus(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBlast4_get_search_status_reply_Base(const CBlast4_get_search_status_reply_Base&);
    CBlast4_get_search_status_reply_Base& operator=(const CBlast4_get_search_status_reply_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Status;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBlast4_get_search_status_reply_Base::IsSetStatus(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBlast4_get_search_status_reply_Base::CanGetStatus(void) const
{
    return IsSetStatus();
}

inline
const CBlast4_get_search_status_reply_Base::TStatus& CBlast4_get_search_status_reply_Base::GetStatus(void) const
{
    if (!CanGetStatus()) {
        ThrowUnassigned(0);
    }
    return m_Status;
}

inline
void CBlast4_get_search_status_reply_Base::SetStatus(const CBlast4_get_search_status_reply_Base::TStatus& value)
{
    m_Status = value;
    m_set_State[0] |= 0x3;
}

inline
void CBlast4_get_search_status_reply_Base::SetStatus(CBlast4_get_search_status_reply_Base::TStatus&& value)
{
    m_Status = std::forward<CBlast4_get_search_status_reply_Base::TStatus>(value);
    m_set_State[0] |= 0x3;
}

inline
CBlast4_get_search_status_reply_Base::TStatus& CBlast4_get_search_status_reply_Base::SetStatus(void)
{
#ifdef _DEBUG
    if (!IsSetStatus()) {
        m_Status = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Status;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLAST_BLAS_GET_SEARC_STATU_REPLY_BASE_HPP
