/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Cit_sub_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'biblio.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BIBLIO_CIT_SUB_BASE_HPP
#define OBJECTS_BIBLIO_CIT_SUB_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CAuth_list;
class CDate;
class CImprint;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// NOTE: this is just to cite a
/// direct data submission, see NCBI-Submit
/// for the form of a sequence submission
/// citation for a direct submission
class NCBI_BIBLIO_EXPORT CCit_sub_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CCit_sub_Base(void);
    // destructor
    virtual ~CCit_sub_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /// medium of submission
    enum EMedium {
        eMedium_paper  =   1,
        eMedium_tape   =   2,
        eMedium_floppy =   3,
        eMedium_email  =   4,
        eMedium_other  = 255
    };
    
    /// Access to EMedium's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EMedium)(void);
    
    // types
    typedef CAuth_list TAuthors;
    typedef CImprint TImp;
    typedef EMedium TMedium;
    typedef CDate TDate;
    typedef string TDescr;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_authors,
        e_imp,
        e_medium,
        e_date,
        e_descr
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// not necessarily authors of the paper
    /// mandatory
    /// typedef CAuth_list TAuthors
    ///  Check whether the Authors data member has been assigned a value.
    bool IsSetAuthors(void) const;
    /// Check whether it is safe or not to call GetAuthors method.
    bool CanGetAuthors(void) const;
    void ResetAuthors(void);
    const TAuthors& GetAuthors(void) const;
    void SetAuthors(TAuthors& value);
    TAuthors& SetAuthors(void);

    /// this only used to get date.. will go
    /// optional
    /// typedef CImprint TImp
    ///  Check whether the Imp data member has been assigned a value.
    bool IsSetImp(void) const;
    /// Check whether it is safe or not to call GetImp method.
    bool CanGetImp(void) const;
    void ResetImp(void);
    const TImp& GetImp(void) const;
    void SetImp(TImp& value);
    TImp& SetImp(void);

    /// optional
    /// typedef EMedium TMedium
    ///  Check whether the Medium data member has been assigned a value.
    bool IsSetMedium(void) const;
    /// Check whether it is safe or not to call GetMedium method.
    bool CanGetMedium(void) const;
    void ResetMedium(void);
    TMedium GetMedium(void) const;
    void SetMedium(TMedium value);
    TMedium& SetMedium(void);

    /// replaces imp, will become required
    /// optional
    /// typedef CDate TDate
    ///  Check whether the Date data member has been assigned a value.
    bool IsSetDate(void) const;
    /// Check whether it is safe or not to call GetDate method.
    bool CanGetDate(void) const;
    void ResetDate(void);
    const TDate& GetDate(void) const;
    void SetDate(TDate& value);
    TDate& SetDate(void);

    /// description of changes for public view
    /// optional
    /// typedef string TDescr
    ///  Check whether the Descr data member has been assigned a value.
    bool IsSetDescr(void) const;
    /// Check whether it is safe or not to call GetDescr method.
    bool CanGetDescr(void) const;
    void ResetDescr(void);
    const TDescr& GetDescr(void) const;
    void SetDescr(const TDescr& value);
    void SetDescr(TDescr&& value);
    TDescr& SetDescr(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCit_sub_Base(const CCit_sub_Base&);
    CCit_sub_Base& operator=(const CCit_sub_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TAuthors > m_Authors;
    CRef< TImp > m_Imp;
    EMedium m_Medium;
    CRef< TDate > m_Date;
    string m_Descr;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCit_sub_Base::IsSetAuthors(void) const
{
    return m_Authors.NotEmpty();
}

inline
bool CCit_sub_Base::CanGetAuthors(void) const
{
    return true;
}

inline
const CCit_sub_Base::TAuthors& CCit_sub_Base::GetAuthors(void) const
{
    if ( !m_Authors ) {
        const_cast<CCit_sub_Base*>(this)->ResetAuthors();
    }
    return (*m_Authors);
}

inline
CCit_sub_Base::TAuthors& CCit_sub_Base::SetAuthors(void)
{
    if ( !m_Authors ) {
        ResetAuthors();
    }
    return (*m_Authors);
}

inline
bool CCit_sub_Base::IsSetImp(void) const
{
    return m_Imp.NotEmpty();
}

inline
bool CCit_sub_Base::CanGetImp(void) const
{
    return IsSetImp();
}

inline
const CCit_sub_Base::TImp& CCit_sub_Base::GetImp(void) const
{
    if (!CanGetImp()) {
        ThrowUnassigned(1);
    }
    return (*m_Imp);
}

inline
bool CCit_sub_Base::IsSetMedium(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CCit_sub_Base::CanGetMedium(void) const
{
    return IsSetMedium();
}

inline
void CCit_sub_Base::ResetMedium(void)
{
    m_Medium = (EMedium)(0);
    m_set_State[0] &= ~0x30;
}

inline
CCit_sub_Base::TMedium CCit_sub_Base::GetMedium(void) const
{
    if (!CanGetMedium()) {
        ThrowUnassigned(2);
    }
    return m_Medium;
}

inline
void CCit_sub_Base::SetMedium(CCit_sub_Base::TMedium value)
{
    m_Medium = value;
    m_set_State[0] |= 0x30;
}

inline
CCit_sub_Base::TMedium& CCit_sub_Base::SetMedium(void)
{
#ifdef _DEBUG
    if (!IsSetMedium()) {
        memset(&m_Medium,UnassignedByte(),sizeof(m_Medium));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Medium;
}

inline
bool CCit_sub_Base::IsSetDate(void) const
{
    return m_Date.NotEmpty();
}

inline
bool CCit_sub_Base::CanGetDate(void) const
{
    return IsSetDate();
}

inline
const CCit_sub_Base::TDate& CCit_sub_Base::GetDate(void) const
{
    if (!CanGetDate()) {
        ThrowUnassigned(3);
    }
    return (*m_Date);
}

inline
bool CCit_sub_Base::IsSetDescr(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CCit_sub_Base::CanGetDescr(void) const
{
    return IsSetDescr();
}

inline
const CCit_sub_Base::TDescr& CCit_sub_Base::GetDescr(void) const
{
    if (!CanGetDescr()) {
        ThrowUnassigned(4);
    }
    return m_Descr;
}

inline
void CCit_sub_Base::SetDescr(const CCit_sub_Base::TDescr& value)
{
    m_Descr = value;
    m_set_State[0] |= 0x300;
}

inline
void CCit_sub_Base::SetDescr(CCit_sub_Base::TDescr&& value)
{
    m_Descr = std::forward<CCit_sub_Base::TDescr>(value);
    m_set_State[0] |= 0x300;
}

inline
CCit_sub_Base::TDescr& CCit_sub_Base::SetDescr(void)
{
#ifdef _DEBUG
    if (!IsSetDescr()) {
        m_Descr = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Descr;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BIBLIO_CIT_SUB_BASE_HPP
