/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Affil_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'biblio.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BIBLIO_AFFIL_BASE_HPP
#define OBJECTS_BIBLIO_AFFIL_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_BIBLIO_EXPORT CAffil_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CAffil_Base(void);
    // destructor
    virtual ~CAffil_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    /// std representation
    class NCBI_BIBLIO_EXPORT C_Std : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Std(void);
        // destructor
        ~C_Std(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef string TAffil;
        typedef string TDiv;
        typedef string TCity;
        typedef string TSub;
        typedef string TCountry;
        typedef string TStreet;
        typedef string TEmail;
        typedef string TFax;
        typedef string TPhone;
        typedef string TPostal_code;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_affil,
            e_div,
            e_city,
            e_sub,
            e_country,
            e_street,
            e_email,
            e_fax,
            e_phone,
            e_postal_code
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 11> TmemberIndex;
    
        // getters
        // setters
    
        /// Author Affiliation, Name
        /// optional
        /// typedef string TAffil
        ///  Check whether the Affil data member has been assigned a value.
        bool IsSetAffil(void) const;
        /// Check whether it is safe or not to call GetAffil method.
        bool CanGetAffil(void) const;
        void ResetAffil(void);
        const TAffil& GetAffil(void) const;
        void SetAffil(const TAffil& value);
        void SetAffil(TAffil&& value);
        TAffil& SetAffil(void);
    
        /// Author Affiliation, Division
        /// optional
        /// typedef string TDiv
        ///  Check whether the Div data member has been assigned a value.
        bool IsSetDiv(void) const;
        /// Check whether it is safe or not to call GetDiv method.
        bool CanGetDiv(void) const;
        void ResetDiv(void);
        const TDiv& GetDiv(void) const;
        void SetDiv(const TDiv& value);
        void SetDiv(TDiv&& value);
        TDiv& SetDiv(void);
    
        /// Author Affiliation, City
        /// optional
        /// typedef string TCity
        ///  Check whether the City data member has been assigned a value.
        bool IsSetCity(void) const;
        /// Check whether it is safe or not to call GetCity method.
        bool CanGetCity(void) const;
        void ResetCity(void);
        const TCity& GetCity(void) const;
        void SetCity(const TCity& value);
        void SetCity(TCity&& value);
        TCity& SetCity(void);
    
        /// Author Affiliation, County Sub
        /// optional
        /// typedef string TSub
        ///  Check whether the Sub data member has been assigned a value.
        bool IsSetSub(void) const;
        /// Check whether it is safe or not to call GetSub method.
        bool CanGetSub(void) const;
        void ResetSub(void);
        const TSub& GetSub(void) const;
        void SetSub(const TSub& value);
        void SetSub(TSub&& value);
        TSub& SetSub(void);
    
        /// Author Affiliation, Country
        /// optional
        /// typedef string TCountry
        ///  Check whether the Country data member has been assigned a value.
        bool IsSetCountry(void) const;
        /// Check whether it is safe or not to call GetCountry method.
        bool CanGetCountry(void) const;
        void ResetCountry(void);
        const TCountry& GetCountry(void) const;
        void SetCountry(const TCountry& value);
        void SetCountry(TCountry&& value);
        TCountry& SetCountry(void);
    
        /// street address, not ANSI
        /// optional
        /// typedef string TStreet
        ///  Check whether the Street data member has been assigned a value.
        bool IsSetStreet(void) const;
        /// Check whether it is safe or not to call GetStreet method.
        bool CanGetStreet(void) const;
        void ResetStreet(void);
        const TStreet& GetStreet(void) const;
        void SetStreet(const TStreet& value);
        void SetStreet(TStreet&& value);
        TStreet& SetStreet(void);
    
        /// optional
        /// typedef string TEmail
        ///  Check whether the Email data member has been assigned a value.
        bool IsSetEmail(void) const;
        /// Check whether it is safe or not to call GetEmail method.
        bool CanGetEmail(void) const;
        void ResetEmail(void);
        const TEmail& GetEmail(void) const;
        void SetEmail(const TEmail& value);
        void SetEmail(TEmail&& value);
        TEmail& SetEmail(void);
    
        /// optional
        /// typedef string TFax
        ///  Check whether the Fax data member has been assigned a value.
        bool IsSetFax(void) const;
        /// Check whether it is safe or not to call GetFax method.
        bool CanGetFax(void) const;
        void ResetFax(void);
        const TFax& GetFax(void) const;
        void SetFax(const TFax& value);
        void SetFax(TFax&& value);
        TFax& SetFax(void);
    
        /// optional
        /// typedef string TPhone
        ///  Check whether the Phone data member has been assigned a value.
        bool IsSetPhone(void) const;
        /// Check whether it is safe or not to call GetPhone method.
        bool CanGetPhone(void) const;
        void ResetPhone(void);
        const TPhone& GetPhone(void) const;
        void SetPhone(const TPhone& value);
        void SetPhone(TPhone&& value);
        TPhone& SetPhone(void);
    
        /// optional
        /// typedef string TPostal_code
        ///  Check whether the Postal_code data member has been assigned a value.
        bool IsSetPostal_code(void) const;
        /// Check whether it is safe or not to call GetPostal_code method.
        bool CanGetPostal_code(void) const;
        void ResetPostal_code(void);
        const TPostal_code& GetPostal_code(void) const;
        void SetPostal_code(const TPostal_code& value);
        void SetPostal_code(TPostal_code&& value);
        TPostal_code& SetPostal_code(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Std(const C_Std&);
        C_Std& operator=(const C_Std&);
    
        // data
        Uint4 m_set_State[1];
        string m_Affil;
        string m_Div;
        string m_City;
        string m_Sub;
        string m_Country;
        string m_Street;
        string m_Email;
        string m_Fax;
        string m_Phone;
        string m_Postal_code;
    };

    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,  ///< No variant selected
        e_Str,          ///< unparsed string
        e_Std
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 3 ///< == e_Std+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef string TStr;
    typedef C_Std TStd;

    // getters
    // setters

    // typedef string TStr
    bool IsStr(void) const;
    const TStr& GetStr(void) const;
    TStr& SetStr(void);
    void SetStr(const TStr& value);

    // typedef C_Std TStd
    bool IsStd(void) const;
    const TStd& GetStd(void) const;
    TStd& SetStd(void);
    void SetStd(TStd& value);


private:
    // copy constructor and assignment operator
    CAffil_Base(const CAffil_Base& );
    CAffil_Base& operator=(const CAffil_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CAffil_Base::C_Std::IsSetAffil(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CAffil_Base::C_Std::CanGetAffil(void) const
{
    return IsSetAffil();
}

inline
const CAffil_Base::C_Std::TAffil& CAffil_Base::C_Std::GetAffil(void) const
{
    if (!CanGetAffil()) {
        ThrowUnassigned(0);
    }
    return m_Affil;
}

inline
void CAffil_Base::C_Std::SetAffil(const CAffil_Base::C_Std::TAffil& value)
{
    m_Affil = value;
    m_set_State[0] |= 0x3;
}

inline
void CAffil_Base::C_Std::SetAffil(CAffil_Base::C_Std::TAffil&& value)
{
    m_Affil = std::forward<CAffil_Base::C_Std::TAffil>(value);
    m_set_State[0] |= 0x3;
}

inline
CAffil_Base::C_Std::TAffil& CAffil_Base::C_Std::SetAffil(void)
{
#ifdef _DEBUG
    if (!IsSetAffil()) {
        m_Affil = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Affil;
}

inline
bool CAffil_Base::C_Std::IsSetDiv(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CAffil_Base::C_Std::CanGetDiv(void) const
{
    return IsSetDiv();
}

inline
const CAffil_Base::C_Std::TDiv& CAffil_Base::C_Std::GetDiv(void) const
{
    if (!CanGetDiv()) {
        ThrowUnassigned(1);
    }
    return m_Div;
}

inline
void CAffil_Base::C_Std::SetDiv(const CAffil_Base::C_Std::TDiv& value)
{
    m_Div = value;
    m_set_State[0] |= 0xc;
}

inline
void CAffil_Base::C_Std::SetDiv(CAffil_Base::C_Std::TDiv&& value)
{
    m_Div = std::forward<CAffil_Base::C_Std::TDiv>(value);
    m_set_State[0] |= 0xc;
}

inline
CAffil_Base::C_Std::TDiv& CAffil_Base::C_Std::SetDiv(void)
{
#ifdef _DEBUG
    if (!IsSetDiv()) {
        m_Div = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Div;
}

inline
bool CAffil_Base::C_Std::IsSetCity(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CAffil_Base::C_Std::CanGetCity(void) const
{
    return IsSetCity();
}

inline
const CAffil_Base::C_Std::TCity& CAffil_Base::C_Std::GetCity(void) const
{
    if (!CanGetCity()) {
        ThrowUnassigned(2);
    }
    return m_City;
}

inline
void CAffil_Base::C_Std::SetCity(const CAffil_Base::C_Std::TCity& value)
{
    m_City = value;
    m_set_State[0] |= 0x30;
}

inline
void CAffil_Base::C_Std::SetCity(CAffil_Base::C_Std::TCity&& value)
{
    m_City = std::forward<CAffil_Base::C_Std::TCity>(value);
    m_set_State[0] |= 0x30;
}

inline
CAffil_Base::C_Std::TCity& CAffil_Base::C_Std::SetCity(void)
{
#ifdef _DEBUG
    if (!IsSetCity()) {
        m_City = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_City;
}

inline
bool CAffil_Base::C_Std::IsSetSub(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CAffil_Base::C_Std::CanGetSub(void) const
{
    return IsSetSub();
}

inline
const CAffil_Base::C_Std::TSub& CAffil_Base::C_Std::GetSub(void) const
{
    if (!CanGetSub()) {
        ThrowUnassigned(3);
    }
    return m_Sub;
}

inline
void CAffil_Base::C_Std::SetSub(const CAffil_Base::C_Std::TSub& value)
{
    m_Sub = value;
    m_set_State[0] |= 0xc0;
}

inline
void CAffil_Base::C_Std::SetSub(CAffil_Base::C_Std::TSub&& value)
{
    m_Sub = std::forward<CAffil_Base::C_Std::TSub>(value);
    m_set_State[0] |= 0xc0;
}

inline
CAffil_Base::C_Std::TSub& CAffil_Base::C_Std::SetSub(void)
{
#ifdef _DEBUG
    if (!IsSetSub()) {
        m_Sub = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Sub;
}

inline
bool CAffil_Base::C_Std::IsSetCountry(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CAffil_Base::C_Std::CanGetCountry(void) const
{
    return IsSetCountry();
}

inline
const CAffil_Base::C_Std::TCountry& CAffil_Base::C_Std::GetCountry(void) const
{
    if (!CanGetCountry()) {
        ThrowUnassigned(4);
    }
    return m_Country;
}

inline
void CAffil_Base::C_Std::SetCountry(const CAffil_Base::C_Std::TCountry& value)
{
    m_Country = value;
    m_set_State[0] |= 0x300;
}

inline
void CAffil_Base::C_Std::SetCountry(CAffil_Base::C_Std::TCountry&& value)
{
    m_Country = std::forward<CAffil_Base::C_Std::TCountry>(value);
    m_set_State[0] |= 0x300;
}

inline
CAffil_Base::C_Std::TCountry& CAffil_Base::C_Std::SetCountry(void)
{
#ifdef _DEBUG
    if (!IsSetCountry()) {
        m_Country = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Country;
}

inline
bool CAffil_Base::C_Std::IsSetStreet(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CAffil_Base::C_Std::CanGetStreet(void) const
{
    return IsSetStreet();
}

inline
const CAffil_Base::C_Std::TStreet& CAffil_Base::C_Std::GetStreet(void) const
{
    if (!CanGetStreet()) {
        ThrowUnassigned(5);
    }
    return m_Street;
}

inline
void CAffil_Base::C_Std::SetStreet(const CAffil_Base::C_Std::TStreet& value)
{
    m_Street = value;
    m_set_State[0] |= 0xc00;
}

inline
void CAffil_Base::C_Std::SetStreet(CAffil_Base::C_Std::TStreet&& value)
{
    m_Street = std::forward<CAffil_Base::C_Std::TStreet>(value);
    m_set_State[0] |= 0xc00;
}

inline
CAffil_Base::C_Std::TStreet& CAffil_Base::C_Std::SetStreet(void)
{
#ifdef _DEBUG
    if (!IsSetStreet()) {
        m_Street = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Street;
}

inline
bool CAffil_Base::C_Std::IsSetEmail(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CAffil_Base::C_Std::CanGetEmail(void) const
{
    return IsSetEmail();
}

inline
const CAffil_Base::C_Std::TEmail& CAffil_Base::C_Std::GetEmail(void) const
{
    if (!CanGetEmail()) {
        ThrowUnassigned(6);
    }
    return m_Email;
}

inline
void CAffil_Base::C_Std::SetEmail(const CAffil_Base::C_Std::TEmail& value)
{
    m_Email = value;
    m_set_State[0] |= 0x3000;
}

inline
void CAffil_Base::C_Std::SetEmail(CAffil_Base::C_Std::TEmail&& value)
{
    m_Email = std::forward<CAffil_Base::C_Std::TEmail>(value);
    m_set_State[0] |= 0x3000;
}

inline
CAffil_Base::C_Std::TEmail& CAffil_Base::C_Std::SetEmail(void)
{
#ifdef _DEBUG
    if (!IsSetEmail()) {
        m_Email = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Email;
}

inline
bool CAffil_Base::C_Std::IsSetFax(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CAffil_Base::C_Std::CanGetFax(void) const
{
    return IsSetFax();
}

inline
const CAffil_Base::C_Std::TFax& CAffil_Base::C_Std::GetFax(void) const
{
    if (!CanGetFax()) {
        ThrowUnassigned(7);
    }
    return m_Fax;
}

inline
void CAffil_Base::C_Std::SetFax(const CAffil_Base::C_Std::TFax& value)
{
    m_Fax = value;
    m_set_State[0] |= 0xc000;
}

inline
void CAffil_Base::C_Std::SetFax(CAffil_Base::C_Std::TFax&& value)
{
    m_Fax = std::forward<CAffil_Base::C_Std::TFax>(value);
    m_set_State[0] |= 0xc000;
}

inline
CAffil_Base::C_Std::TFax& CAffil_Base::C_Std::SetFax(void)
{
#ifdef _DEBUG
    if (!IsSetFax()) {
        m_Fax = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Fax;
}

inline
bool CAffil_Base::C_Std::IsSetPhone(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CAffil_Base::C_Std::CanGetPhone(void) const
{
    return IsSetPhone();
}

inline
const CAffil_Base::C_Std::TPhone& CAffil_Base::C_Std::GetPhone(void) const
{
    if (!CanGetPhone()) {
        ThrowUnassigned(8);
    }
    return m_Phone;
}

inline
void CAffil_Base::C_Std::SetPhone(const CAffil_Base::C_Std::TPhone& value)
{
    m_Phone = value;
    m_set_State[0] |= 0x30000;
}

inline
void CAffil_Base::C_Std::SetPhone(CAffil_Base::C_Std::TPhone&& value)
{
    m_Phone = std::forward<CAffil_Base::C_Std::TPhone>(value);
    m_set_State[0] |= 0x30000;
}

inline
CAffil_Base::C_Std::TPhone& CAffil_Base::C_Std::SetPhone(void)
{
#ifdef _DEBUG
    if (!IsSetPhone()) {
        m_Phone = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Phone;
}

inline
bool CAffil_Base::C_Std::IsSetPostal_code(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CAffil_Base::C_Std::CanGetPostal_code(void) const
{
    return IsSetPostal_code();
}

inline
const CAffil_Base::C_Std::TPostal_code& CAffil_Base::C_Std::GetPostal_code(void) const
{
    if (!CanGetPostal_code()) {
        ThrowUnassigned(9);
    }
    return m_Postal_code;
}

inline
void CAffil_Base::C_Std::SetPostal_code(const CAffil_Base::C_Std::TPostal_code& value)
{
    m_Postal_code = value;
    m_set_State[0] |= 0xc0000;
}

inline
void CAffil_Base::C_Std::SetPostal_code(CAffil_Base::C_Std::TPostal_code&& value)
{
    m_Postal_code = std::forward<CAffil_Base::C_Std::TPostal_code>(value);
    m_set_State[0] |= 0xc0000;
}

inline
CAffil_Base::C_Std::TPostal_code& CAffil_Base::C_Std::SetPostal_code(void)
{
#ifdef _DEBUG
    if (!IsSetPostal_code()) {
        m_Postal_code = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Postal_code;
}

inline
CAffil_Base::E_Choice CAffil_Base::Which(void) const
{
    return m_choice;
}

inline
void CAffil_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CAffil_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CAffil_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CAffil_Base::IsStr(void) const
{
    return m_choice == e_Str;
}

inline
const CAffil_Base::TStr& CAffil_Base::GetStr(void) const
{
    CheckSelected(e_Str);
    return *m_string;
}

inline
CAffil_Base::TStr& CAffil_Base::SetStr(void)
{
    Select(e_Str, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CAffil_Base::IsStd(void) const
{
    return m_choice == e_Std;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BIBLIO_AFFIL_BASE_HPP
