/*
 NAME
 	tobject.h - type definition
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#if !defined(TOBJECT_H_INCLUDED)
#define TOBJECT_H_INCLUDED

#include <coconut/tbasic.h>

typedef struct {
	id	obj ;
	SEL	message ;
	void *	param1 ;
	void *	param2 ;
} signal_t ;

#  define	SET_SIGNAL(REC, OBJ, MSG, PAR1, PAR2) \
	do { \
		(REC).obj = OBJ ; (REC).message = MSG ; \
		(REC).param1 = PAR1 ; (REC).param2 = PAR2 ; \
	} while(0) 

  /* the last P means the argument is pointer */
#  define	EMIT_SIGNALP(PTR) \
	[(PTR)->obj perform: (PTR)->message with: (PTR)->param1 \
	  with: (PTR)->param2] 

/* param_*_t structure is use as a parameter of "perform" method */
typedef struct {
	boolean		bool_value ;
} param_b_t ;

#define	SET_PARAM_B(REC, B) \
	do { \
		(REC).bool_value = B ; \
	} while(0) 

typedef struct {
	void *		ptr_value ;
} param_p_t ;

#define	SET_PARAM_P(REC, P) \
	do { \
		(REC).ptr_value = P ; \
	} while(0) 

typedef struct {
	boolean		bool_value1 ;
	boolean		bool_value2 ;
} param_b2_t ;

#define	SET_PARAM_B2(REC, B1, B2) \
	do { \
		(REC).bool_value1 = B1 ; (REC).bool_value2 = B2 ; \
	} while(0) 

typedef struct {
	void *		ptr_value ;
	boolean		bool_value1 ;
	boolean		bool_value2 ;
} param_pb2_t ;

#define	SET_PARAM_PB2(REC, P, B1, B2) \
	do { \
		(REC).ptr_value = P ; \
		(REC).bool_value1 = B1 ; (REC).bool_value2 = B2 ; \
	} while(0) 

typedef struct {
	const char *	str_value1 ;
	const char *	str_value2 ;
} param_s2_t ;

#define	SET_PARAM_S2(REC, STR1, STR2) \
	do { \
		(REC).str_value1 = STR1 ; (REC).str_value2 = STR2 ; \
	} while(0) 

typedef struct {
	void *	ptr_value1 ;
	void *	ptr_value2 ;
} param_p2_t ;

#define	SET_PARAM_P2(REC, P1, P2) \
	do { \
		(REC).ptr_value1 = P1 ; (REC).ptr_value2 = P2 ; \
	} while(0) 

typedef struct {
	void *	ptr_value ;
	u_int	u_int_value ;
} param_pu_t ;

#define	SET_PARAM_PU(REC, P, U) \
	do { \
		(REC).ptr_value = P ; (REC).u_int_value = U ; \
	} while(0) 

#endif /* defined(TOBJECT_H_INCLUDED) */

