/*****
 NAME
	pwidget.h - protocol definition for GTK widgets
 VERSION
	$Id$
 CHANGELOG
	$Log$
 */

#if !defined(PWIDGET_H_INCLUDED)
#define PWIDGET_H_INCLUDED

#include <coconut/pobject.h>
#include <coconut/pstring.h>
#include <coconut/pmisc.h>
#include <coconut/gtk/tgtk.h>

/* PWidget protocol defines the interface of CWidget class. CWidget class
   is a super class of all objects */
@protocol PWidget <PObject>
 - (widget_t) type ;
 - (GtkWidget *) widgetPtr ;

 - (boolean) isContainer ;
 - (boolean) isDeletable ;
 - (boolean) isGrowable ;
   /* if the title string can be set to the widget, return true. 
      (this method DOES NOT mean the title string is null or not. 
      Same method is defined in PWidgetTitle protocol. */
 - (boolean) hasAlign ;
 - (boolean) hasDirection ;
 - (boolean) hasInconsistent ;
 - (boolean) hasIndicator ;
 - (boolean) hasJustification ;
 - (boolean) hasPadding ;
 - (boolean) hasShadow ;
 - (boolean) hasTextView ;
 - (boolean) hasTitle ;
 - (boolean) hasToggleSwitch ;

 - show ;
 - hide ;

 - connectClickedEvent: (id) obj message:(SEL)sel with: param ;

   /* If this method is called, when the object is released, 
      the event loop is terminated. */
 - doExitAfterDelete ;

   /* This object is not accessed by this class except releasing.
      This object will be released when this class is released */
 - setUserObject: (id) obj ;
 - (id) getUserObject ;
@end

/* common protocols which implemented by some classes
 */

@protocol PContainerPart <PObject>
 - (boolean) isContainer ;

 - show ;
 - hide ;

 - (u_int) count ;

 - appendWidget: (id <PWidget>) child ;
 - prependWidget: (id <PWidget>) child ;

 - (id <PWidget>) item: (u_int) index ;
 - removeWidget: (id <PWidget>) wid ;

 - foreach: (SEL) msg with: p1 with: p2 ;

 - setBorderWidth: (dimension_t) width ;
 - setHomogeneous: (boolean) dohomogeneous ;
 - setSpacing: (dimension_t) spacing ;

@end

@protocol PActivationPart <PObject>
 - (boolean) hasActivation ;
@end

@protocol PAlignPart <PObject>
 - (boolean) hasAlign ;

 - setAlign: (align_t) holiz and: (align_t) vert ;
 - setHolizAlign: (align_t) holiz ;
 - setVertAlign: (align_t) vert ;

 - (align_t) holizAlign ;
 - (align_t) vertAlign ;
@end

@protocol PJustificationPart
 - (boolean) hasJustification ;

 - doWordWrap: (boolean) dowrap ;
 - doLineWrap: (boolean) dowrap ;

 - setJusitification: (justification_t) typ ;
@end

@protocol PArrowPart <PObject>
 - (boolean) hasDirection ;

 - setDirection: (direction_t) stype ;
 - (direction_t) direction ;
@end

@protocol PGrowablePart <PObject>
 - (boolean) isGrowable ;

 - doShrink: (boolean) doshrink ;
 - (boolean) isShrinkable ;

 - doGrow: (boolean) dogrow ;
@end

@protocol PInconsistentPart <PObject>
 - (boolean) hasInconsistent ;

 - setInconsistent: (boolean) setting ;
 - (boolean) inconsistent ;
@end

@protocol PIndicatorPart <PObject>
 - (boolean) hasIndicator ;

 - setIndicator: (boolean) setting ;
 - (boolean) indicator ;
@end

@protocol PPaddingPart <PObject>
 - (boolean) hasPadding ;

 - setPadding: (dimension_t) xpad and: (dimension_t) ypad ;
 - setHolizPadding: (dimension_t) xpad ;
 - setVertPadding: (dimension_t) ypad ;

 - (dimension_t) holizPadding ;
 - (dimension_t) vertPadding ;
@end

@protocol PShadowPart <PObject>
 - (boolean) hasShadow ;

 - setShadow: (shadow_t) stype ;
 - (shadow_t) shadow ;
@end

@protocol PTextViewPart <PJustificationPart>
 - (boolean) hasTextView ;

 - setEditable: (boolean) doedit ;
 - (boolean) isEditable ;

 - setCursorVisible: (boolean) dovis ;
 - (boolean) isCursorVisible ;

 - setStr: (id <PBasicStr>) str ;
 - setPtr: (const utf8_char *) text length: (u_int) len ;
@end

@protocol PTitlePart <PObject>
 - (boolean) hasTitle ;

 - setTitle: (const char *) title ;
 - (const char *) title ;

@end

@protocol PToggleSwitchPart <PObject>
 - (boolean) hasToggleSwitch ;

 - toggle: (boolean) value ;
 - (boolean) isToggled ;
@end

/* the protocol which implemented for each classes 
 */

@protocol PWindowPart <PGrowablePart, PTitlePart>
@end

@protocol PButtonPart <PObject>
@end

@protocol PCalendarPart <PDate>
  - (id <PDate>) date ;
  - markDay: (u_int) day ;
  - unmarkDay: (u_int) day ;
  - clearMarks ;
@end

@protocol PToggleButtonPart <PToggleSwitchPart,PInconsistentPart,PIndicatorPart>
@end

@protocol PFramePart <PTitlePart, PAlignPart, PShadowPart>
@end

@protocol PLabelPart <PTitlePart, PJustificationPart>
@end

@protocol PRadioButtonPart <PObject>
   /* the RadioButton class is based on the Container class. But it is not
      container */
 - (boolean) isContainer ;
 - appendLabel: (const utf8_char *) label ;
 - prependLabel: (const utf8_char *) label ;

 - activate: (u_int) idx ;

 - show ;
 - hide ;

@end

@protocol PSeparatorPart <PObject>
@end

/* the protocol containes all super classes' protocols
 */

@protocol PContainer <PContainerPart, PGrowablePart, PWidget>
@end

@protocol PWindow <PWindowPart, PContainer>
@end

@protocol PArrow <PArrowPart, PShadowPart, PPaddingPart, PWidget>
@end

@protocol PButton <PButtonPart, PContainerPart, PWidget>
@end

@protocol PCalendar <PCalendarPart, PWidget>
@end

@protocol PFrame <PFramePart, PContainer>
@end

@protocol PLabel <PLabelPart, PWidget>
@end

@protocol PRadioButton <PRadioButtonPart, PWidget>
@end

@protocol PTextView <PTextViewPart, PWidget>
@end

#endif

