/*****
 NAME
	dbasic.h - basic macro definition 
 VERSION
	$Id$
 CHANGELOG
	$Log$
 */

#if !defined(DBASIC_H_INCLUDED)
#define	DBASIC_H_INCLUDED

/* the definition of TRUE and FALSE is copied from glib.h */
#if !defined(FALSE)
#	define	FALSE	(0)
#endif

#if !defined(TRUE)
#	define	TRUE	(!FALSE)
#endif

/* these constant values are copied from limits.h for FreeBSD
   But I think it has compatibility with all other systems :) */
#define	MAX_INT8		127
#define	MIN_INT8		(-128)
#define	MAX_U_INT8		255
#define	MIN_U_INT8		0

#define	MAX_INT16		32767
#define	MIN_INT16		(-32768)
#define	MAX_U_INT16		65535
#define	MIN_U_INT16		0

#define	MAX_INT32		2147483647
#define	MIN_INT32		(-MAX_INT32 - 1)
#define	MAX_U_INT32		4294967295U
#define	MIN_U_INT32		0

#define	MAX_INT64		9223372036854775807L
#define	MIN_INT64		(-MAX_INT64 - 1L)
#define	MAX_U_INT64		18446744073709551615UL
#define	MIN_U_INT64		0

/* memory alignment */
#define	PAGE_SIZE(S, U)	\
 (((u_int) ((S) + (U) - 1) / (U)) * (U))

#define	ALIGN_UNIT_SIZE		sizeof(double)
#define	ALIGNED_SIZE(S)		PAGE_SIZE(S, ALIGN_UNIT_SIZE)

/* these definitions are conflict with the same named macros in glib.h */
#if !defined(MAX)
#  define	MAX(A,B)	((A) > (B) ? (A) : (B))
#endif
#if !defined(MIN)
#  define	MIN(A,B)	((A) < (B) ? (A) : (B))
#endif

#if !defined(ABS)
#  define	ABS(A)		((A) > 0 ? (A) : -(A))
#endif

#define	IS_IN_RANGE(MIN, MAX, VAL)	((MIN) <= (VAL) && (VAL) <= (MAX))
#define	IS_IN_INT_RANGE(VAL)	IS_IN_RANGE(INT_MIN, INT_MAX, VAL)

#define	SUPPRESS_UNUSED_WARN(val)	((void) val)

#endif /* !defined(DBASIC_H_INCLUDED) */

