/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ArticleIdList_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_ARTICLEIDLIST_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_ARTICLEIDLIST_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CArticleId;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CArticleIdList_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CArticleIdList_Base(void);
    // destructor
    virtual ~CArticleIdList_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CArticleId C_E;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CArticleId > > TArticleId;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_ArticleId
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CArticleId > > TArticleId
    ///  Check whether the ArticleId data member has been assigned a value.
    bool IsSetArticleId(void) const;
    /// Check whether it is safe or not to call GetArticleId method.
    bool CanGetArticleId(void) const;
    void ResetArticleId(void);
    const TArticleId& GetArticleId(void) const;
    TArticleId& SetArticleId(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CArticleIdList_Base(const CArticleIdList_Base&);
    CArticleIdList_Base& operator=(const CArticleIdList_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CArticleId > > m_ArticleId;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CArticleIdList_Base::IsSetArticleId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CArticleIdList_Base::CanGetArticleId(void) const
{
    return true;
}

inline
const CArticleIdList_Base::TArticleId& CArticleIdList_Base::GetArticleId(void) const
{
    return m_ArticleId;
}

inline
CArticleIdList_Base::TArticleId& CArticleIdList_Base::SetArticleId(void)
{
    m_set_State[0] |= 0x1;
    return m_ArticleId;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_ARTICLEIDLIST_BASE_HPP
