/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ArticleDate_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_ARTICLEDATE_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_ARTICLEDATE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CDay;
class CMonth;
class CYear;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CArticleDate_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CArticleDate_Base(void);
    // destructor
    virtual ~CArticleDate_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_DateType {
            eAttlist_DateType_Electronic = 1
        };
        
        /// Access to EAttlist_DateType's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_DateType)(void);
        
        // types
        typedef EAttlist_DateType TDateType;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_DateType
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
    
        // getters
        // setters
    
        /// optional with default eAttlist_DateType_Electronic
        /// typedef EAttlist_DateType TDateType
        ///  Check whether the DateType data member has been assigned a value.
        bool IsSetDateType(void) const;
        /// Check whether it is safe or not to call GetDateType method.
        bool CanGetDateType(void) const;
        void ResetDateType(void);
        void SetDefaultDateType(void);
        TDateType GetDateType(void) const;
        void SetDateType(TDateType value);
        TDateType& SetDateType(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        EAttlist_DateType m_DateType;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef CYear TYear;
    typedef CMonth TMonth;
    typedef CDay TDay;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_Year,
        e_Month,
        e_Day
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef CYear TYear
    ///  Check whether the Year data member has been assigned a value.
    bool IsSetYear(void) const;
    /// Check whether it is safe or not to call GetYear method.
    bool CanGetYear(void) const;
    void ResetYear(void);
    const TYear& GetYear(void) const;
    void SetYear(TYear& value);
    TYear& SetYear(void);

    /// mandatory
    /// typedef CMonth TMonth
    ///  Check whether the Month data member has been assigned a value.
    bool IsSetMonth(void) const;
    /// Check whether it is safe or not to call GetMonth method.
    bool CanGetMonth(void) const;
    void ResetMonth(void);
    const TMonth& GetMonth(void) const;
    void SetMonth(TMonth& value);
    TMonth& SetMonth(void);

    /// mandatory
    /// typedef CDay TDay
    ///  Check whether the Day data member has been assigned a value.
    bool IsSetDay(void) const;
    /// Check whether it is safe or not to call GetDay method.
    bool CanGetDay(void) const;
    void ResetDay(void);
    const TDay& GetDay(void) const;
    void SetDay(TDay& value);
    TDay& SetDay(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CArticleDate_Base(const CArticleDate_Base&);
    CArticleDate_Base& operator=(const CArticleDate_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_NCBI::CRef< TYear > m_Year;
    NCBI_NS_NCBI::CRef< TMonth > m_Month;
    NCBI_NS_NCBI::CRef< TDay > m_Day;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CArticleDate_Base::C_Attlist::IsSetDateType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CArticleDate_Base::C_Attlist::CanGetDateType(void) const
{
    return true;
}

inline
void CArticleDate_Base::C_Attlist::ResetDateType(void)
{
    m_DateType = eAttlist_DateType_Electronic;
    m_set_State[0] &= ~0x3;
}

inline
void CArticleDate_Base::C_Attlist::SetDefaultDateType(void)
{
    ResetDateType();
    m_set_State[0] |= 0x1;
}

inline
CArticleDate_Base::C_Attlist::TDateType CArticleDate_Base::C_Attlist::GetDateType(void) const
{
    return m_DateType;
}

inline
void CArticleDate_Base::C_Attlist::SetDateType(CArticleDate_Base::C_Attlist::TDateType value)
{
    m_DateType = value;
    m_set_State[0] |= 0x3;
}

inline
CArticleDate_Base::C_Attlist::TDateType& CArticleDate_Base::C_Attlist::SetDateType(void)
{
#ifdef _DEBUG
    if (!IsSetDateType()) {
        memset(&m_DateType,UnassignedByte(),sizeof(m_DateType));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_DateType;
}

inline
bool CArticleDate_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CArticleDate_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CArticleDate_Base::TAttlist& CArticleDate_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CArticleDate_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CArticleDate_Base::TAttlist& CArticleDate_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CArticleDate_Base::IsSetYear(void) const
{
    return m_Year.NotEmpty();
}

inline
bool CArticleDate_Base::CanGetYear(void) const
{
    return true;
}

inline
const CArticleDate_Base::TYear& CArticleDate_Base::GetYear(void) const
{
    if ( !m_Year ) {
        const_cast<CArticleDate_Base*>(this)->ResetYear();
    }
    return (*m_Year);
}

inline
CArticleDate_Base::TYear& CArticleDate_Base::SetYear(void)
{
    if ( !m_Year ) {
        ResetYear();
    }
    return (*m_Year);
}

inline
bool CArticleDate_Base::IsSetMonth(void) const
{
    return m_Month.NotEmpty();
}

inline
bool CArticleDate_Base::CanGetMonth(void) const
{
    return true;
}

inline
const CArticleDate_Base::TMonth& CArticleDate_Base::GetMonth(void) const
{
    if ( !m_Month ) {
        const_cast<CArticleDate_Base*>(this)->ResetMonth();
    }
    return (*m_Month);
}

inline
CArticleDate_Base::TMonth& CArticleDate_Base::SetMonth(void)
{
    if ( !m_Month ) {
        ResetMonth();
    }
    return (*m_Month);
}

inline
bool CArticleDate_Base::IsSetDay(void) const
{
    return m_Day.NotEmpty();
}

inline
bool CArticleDate_Base::CanGetDay(void) const
{
    return true;
}

inline
const CArticleDate_Base::TDay& CArticleDate_Base::GetDay(void) const
{
    if ( !m_Day ) {
        const_cast<CArticleDate_Base*>(this)->ResetDay();
    }
    return (*m_Day);
}

inline
CArticleDate_Base::TDay& CArticleDate_Base::SetDay(void)
{
    if ( !m_Day ) {
        ResetDay();
    }
    return (*m_Day);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_ARTICLEDATE_BASE_HPP
