/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file SimpleVariant_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'varrep.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_VARREP_SIMPLEVARIANT_BASE_HPP
#define OBJECTS_VARREP_SIMPLEVARIANT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CAaLocation;
class CConversion;
class CDeletion;
class CDelins;
class CDuplication;
class CFrameshift;
class CInsertion;
class CInversion;
class CNaIdentity;
class CNaSub;
class CProteinExtension;
class CProteinSub;
class CRepeat;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CSimpleVariant_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSimpleVariant_Base(void);
    // destructor
    virtual ~CSimpleVariant_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Type : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Type(void);
        // destructor
        ~C_Type(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Na_identity,
            e_Na_sub,
            e_Prot_sub,
            e_Prot_silent,
            e_Del,
            e_Dup,
            e_Inv,
            e_Ins,
            e_Conv,
            e_Delins,
            e_Repeat,       ///<short-sequence repeat (ssr)
            e_Prot_ext,
            e_Frameshift
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 14 ///< == e_Frameshift+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef CNaIdentity TNa_identity;
        typedef CNaSub TNa_sub;
        typedef CProteinSub TProt_sub;
        typedef CAaLocation TProt_silent;
        typedef CDeletion TDel;
        typedef CDuplication TDup;
        typedef CInversion TInv;
        typedef CInsertion TIns;
        typedef CConversion TConv;
        typedef CDelins TDelins;
        typedef CRepeat TRepeat;
        typedef CProteinExtension TProt_ext;
        typedef CFrameshift TFrameshift;
    
        // getters
        // setters
    
        // typedef CNaIdentity TNa_identity
        bool IsNa_identity(void) const;
        const TNa_identity& GetNa_identity(void) const;
        TNa_identity& SetNa_identity(void);
        void SetNa_identity(TNa_identity& value);
    
        // typedef CNaSub TNa_sub
        bool IsNa_sub(void) const;
        const TNa_sub& GetNa_sub(void) const;
        TNa_sub& SetNa_sub(void);
        void SetNa_sub(TNa_sub& value);
    
        // typedef CProteinSub TProt_sub
        bool IsProt_sub(void) const;
        const TProt_sub& GetProt_sub(void) const;
        TProt_sub& SetProt_sub(void);
        void SetProt_sub(TProt_sub& value);
    
        // typedef CAaLocation TProt_silent
        bool IsProt_silent(void) const;
        const TProt_silent& GetProt_silent(void) const;
        TProt_silent& SetProt_silent(void);
        void SetProt_silent(TProt_silent& value);
    
        // typedef CDeletion TDel
        bool IsDel(void) const;
        const TDel& GetDel(void) const;
        TDel& SetDel(void);
        void SetDel(TDel& value);
    
        // typedef CDuplication TDup
        bool IsDup(void) const;
        const TDup& GetDup(void) const;
        TDup& SetDup(void);
        void SetDup(TDup& value);
    
        // typedef CInversion TInv
        bool IsInv(void) const;
        const TInv& GetInv(void) const;
        TInv& SetInv(void);
        void SetInv(TInv& value);
    
        // typedef CInsertion TIns
        bool IsIns(void) const;
        const TIns& GetIns(void) const;
        TIns& SetIns(void);
        void SetIns(TIns& value);
    
        // typedef CConversion TConv
        bool IsConv(void) const;
        const TConv& GetConv(void) const;
        TConv& SetConv(void);
        void SetConv(TConv& value);
    
        // typedef CDelins TDelins
        bool IsDelins(void) const;
        const TDelins& GetDelins(void) const;
        TDelins& SetDelins(void);
        void SetDelins(TDelins& value);
    
        // typedef CRepeat TRepeat
        bool IsRepeat(void) const;
        const TRepeat& GetRepeat(void) const;
        TRepeat& SetRepeat(void);
        void SetRepeat(TRepeat& value);
    
        // typedef CProteinExtension TProt_ext
        bool IsProt_ext(void) const;
        const TProt_ext& GetProt_ext(void) const;
        TProt_ext& SetProt_ext(void);
        void SetProt_ext(TProt_ext& value);
    
        // typedef CFrameshift TFrameshift
        bool IsFrameshift(void) const;
        const TFrameshift& GetFrameshift(void) const;
        TFrameshift& SetFrameshift(void);
        void SetFrameshift(TFrameshift& value);
    
    
    private:
        // copy constructor and assignment operator
        C_Type(const C_Type& );
        C_Type& operator=(const C_Type& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
    // types
    typedef C_Type TType;
    typedef bool TFuzzy;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_type,
        e_fuzzy
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Type TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    const TType& GetType(void) const;
    void SetType(TType& value);
    TType& SetType(void);

    /// optional with default false
    /// typedef bool TFuzzy
    ///  Check whether the Fuzzy data member has been assigned a value.
    bool IsSetFuzzy(void) const;
    /// Check whether it is safe or not to call GetFuzzy method.
    bool CanGetFuzzy(void) const;
    void ResetFuzzy(void);
    void SetDefaultFuzzy(void);
    TFuzzy GetFuzzy(void) const;
    void SetFuzzy(TFuzzy value);
    TFuzzy& SetFuzzy(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSimpleVariant_Base(const CSimpleVariant_Base&);
    CSimpleVariant_Base& operator=(const CSimpleVariant_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TType > m_Type;
    bool m_Fuzzy;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CSimpleVariant_Base::C_Type::E_Choice CSimpleVariant_Base::C_Type::Which(void) const
{
    return m_choice;
}

inline
void CSimpleVariant_Base::C_Type::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CSimpleVariant_Base::C_Type::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CSimpleVariant_Base::C_Type::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CSimpleVariant_Base::C_Type::IsNa_identity(void) const
{
    return m_choice == e_Na_identity;
}

inline
bool CSimpleVariant_Base::C_Type::IsNa_sub(void) const
{
    return m_choice == e_Na_sub;
}

inline
bool CSimpleVariant_Base::C_Type::IsProt_sub(void) const
{
    return m_choice == e_Prot_sub;
}

inline
bool CSimpleVariant_Base::C_Type::IsProt_silent(void) const
{
    return m_choice == e_Prot_silent;
}

inline
bool CSimpleVariant_Base::C_Type::IsDel(void) const
{
    return m_choice == e_Del;
}

inline
bool CSimpleVariant_Base::C_Type::IsDup(void) const
{
    return m_choice == e_Dup;
}

inline
bool CSimpleVariant_Base::C_Type::IsInv(void) const
{
    return m_choice == e_Inv;
}

inline
bool CSimpleVariant_Base::C_Type::IsIns(void) const
{
    return m_choice == e_Ins;
}

inline
bool CSimpleVariant_Base::C_Type::IsConv(void) const
{
    return m_choice == e_Conv;
}

inline
bool CSimpleVariant_Base::C_Type::IsDelins(void) const
{
    return m_choice == e_Delins;
}

inline
bool CSimpleVariant_Base::C_Type::IsRepeat(void) const
{
    return m_choice == e_Repeat;
}

inline
bool CSimpleVariant_Base::C_Type::IsProt_ext(void) const
{
    return m_choice == e_Prot_ext;
}

inline
bool CSimpleVariant_Base::C_Type::IsFrameshift(void) const
{
    return m_choice == e_Frameshift;
}

inline
bool CSimpleVariant_Base::IsSetType(void) const
{
    return m_Type.NotEmpty();
}

inline
bool CSimpleVariant_Base::CanGetType(void) const
{
    return true;
}

inline
const CSimpleVariant_Base::TType& CSimpleVariant_Base::GetType(void) const
{
    if ( !m_Type ) {
        const_cast<CSimpleVariant_Base*>(this)->ResetType();
    }
    return (*m_Type);
}

inline
CSimpleVariant_Base::TType& CSimpleVariant_Base::SetType(void)
{
    if ( !m_Type ) {
        ResetType();
    }
    return (*m_Type);
}

inline
bool CSimpleVariant_Base::IsSetFuzzy(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CSimpleVariant_Base::CanGetFuzzy(void) const
{
    return true;
}

inline
void CSimpleVariant_Base::ResetFuzzy(void)
{
    m_Fuzzy = false;
    m_set_State[0] &= ~0xc;
}

inline
void CSimpleVariant_Base::SetDefaultFuzzy(void)
{
    ResetFuzzy();
}

inline
CSimpleVariant_Base::TFuzzy CSimpleVariant_Base::GetFuzzy(void) const
{
    return m_Fuzzy;
}

inline
void CSimpleVariant_Base::SetFuzzy(CSimpleVariant_Base::TFuzzy value)
{
    m_Fuzzy = value;
    m_set_State[0] |= 0xc;
}

inline
CSimpleVariant_Base::TFuzzy& CSimpleVariant_Base::SetFuzzy(void)
{
#ifdef _DEBUG
    if (!IsSetFuzzy()) {
        memset(&m_Fuzzy,UnassignedByte(),sizeof(m_Fuzzy));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Fuzzy;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_VARREP_SIMPLEVARIANT_BASE_HPP
