/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file NtermExtension_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'varrep.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_VARREP_NTERMEXTENSION_BASE_HPP
#define OBJECTS_VARREP_NTERMEXTENSION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CCount;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CNtermExtension_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CNtermExtension_Base(void);
    // destructor
    virtual ~CNtermExtension_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CCount TNewStart;
    typedef string TNewAa;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_newStart,
        e_newAa
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CCount TNewStart
    ///  Check whether the NewStart data member has been assigned a value.
    bool IsSetNewStart(void) const;
    /// Check whether it is safe or not to call GetNewStart method.
    bool CanGetNewStart(void) const;
    void ResetNewStart(void);
    const TNewStart& GetNewStart(void) const;
    void SetNewStart(TNewStart& value);
    TNewStart& SetNewStart(void);

    /// optional
    /// typedef string TNewAa
    ///  Check whether the NewAa data member has been assigned a value.
    bool IsSetNewAa(void) const;
    /// Check whether it is safe or not to call GetNewAa method.
    bool CanGetNewAa(void) const;
    void ResetNewAa(void);
    const TNewAa& GetNewAa(void) const;
    void SetNewAa(const TNewAa& value);
    void SetNewAa(TNewAa&& value);
    TNewAa& SetNewAa(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CNtermExtension_Base(const CNtermExtension_Base&);
    CNtermExtension_Base& operator=(const CNtermExtension_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TNewStart > m_NewStart;
    string m_NewAa;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CNtermExtension_Base::IsSetNewStart(void) const
{
    return m_NewStart.NotEmpty();
}

inline
bool CNtermExtension_Base::CanGetNewStart(void) const
{
    return true;
}

inline
const CNtermExtension_Base::TNewStart& CNtermExtension_Base::GetNewStart(void) const
{
    if ( !m_NewStart ) {
        const_cast<CNtermExtension_Base*>(this)->ResetNewStart();
    }
    return (*m_NewStart);
}

inline
CNtermExtension_Base::TNewStart& CNtermExtension_Base::SetNewStart(void)
{
    if ( !m_NewStart ) {
        ResetNewStart();
    }
    return (*m_NewStart);
}

inline
bool CNtermExtension_Base::IsSetNewAa(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CNtermExtension_Base::CanGetNewAa(void) const
{
    return IsSetNewAa();
}

inline
const CNtermExtension_Base::TNewAa& CNtermExtension_Base::GetNewAa(void) const
{
    if (!CanGetNewAa()) {
        ThrowUnassigned(1);
    }
    return m_NewAa;
}

inline
void CNtermExtension_Base::SetNewAa(const CNtermExtension_Base::TNewAa& value)
{
    m_NewAa = value;
    m_set_State[0] |= 0xc;
}

inline
void CNtermExtension_Base::SetNewAa(CNtermExtension_Base::TNewAa&& value)
{
    m_NewAa = std::forward<CNtermExtension_Base::TNewAa>(value);
    m_set_State[0] |= 0xc;
}

inline
CNtermExtension_Base::TNewAa& CNtermExtension_Base::SetNewAa(void)
{
#ifdef _DEBUG
    if (!IsSetNewAa()) {
        m_NewAa = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_NewAa;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_VARREP_NTERMEXTENSION_BASE_HPP
