/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Delins_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'varrep.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_VARREP_DELINS_BASE_HPP
#define OBJECTS_VARREP_DELINS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CCount;
class CSeqLocation;
class CSubsequence;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CDelins_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CDelins_Base(void);
    // destructor
    virtual ~CDelins_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Inserted_seq_info : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Inserted_seq_info(void);
        // destructor
        ~C_Inserted_seq_info(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Identifier,   ///< A sequence identifier (e.g. an accession id)
            e_Raw_seq,      ///< The actual nucleotide / amino-acid sequence
            e_Count,        ///< The number of elements inserted
            e_Subseq        ///< A subsequence specified by an id, type descriptor, and a range
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 5 ///< == e_Subseq+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef string TIdentifier;
        typedef string TRaw_seq;
        typedef CCount TCount;
        typedef CSubsequence TSubseq;
    
        // getters
        // setters
    
        // typedef string TIdentifier
        bool IsIdentifier(void) const;
        const TIdentifier& GetIdentifier(void) const;
        TIdentifier& SetIdentifier(void);
        void SetIdentifier(const TIdentifier& value);
    
        // typedef string TRaw_seq
        bool IsRaw_seq(void) const;
        const TRaw_seq& GetRaw_seq(void) const;
        TRaw_seq& SetRaw_seq(void);
        void SetRaw_seq(const TRaw_seq& value);
    
        // typedef CCount TCount
        bool IsCount(void) const;
        const TCount& GetCount(void) const;
        TCount& SetCount(void);
        void SetCount(TCount& value);
    
        // typedef CSubsequence TSubseq
        bool IsSubseq(void) const;
        const TSubseq& GetSubseq(void) const;
        TSubseq& SetSubseq(void);
        void SetSubseq(TSubseq& value);
    
    
    private:
        // copy constructor and assignment operator
        C_Inserted_seq_info(const C_Inserted_seq_info& );
        C_Inserted_seq_info& operator=(const C_Inserted_seq_info& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
    };
    // types
    typedef CSeqLocation TLoc;
    typedef string TDeleted_raw_seq;
    typedef C_Inserted_seq_info TInserted_seq_info;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_loc,
        e_deleted_raw_seq,
        e_inserted_seq_info
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CSeqLocation TLoc
    ///  Check whether the Loc data member has been assigned a value.
    bool IsSetLoc(void) const;
    /// Check whether it is safe or not to call GetLoc method.
    bool CanGetLoc(void) const;
    void ResetLoc(void);
    const TLoc& GetLoc(void) const;
    void SetLoc(TLoc& value);
    TLoc& SetLoc(void);

    /// can optionally specify the deleted sequence
    /// optional
    /// typedef string TDeleted_raw_seq
    ///  Check whether the Deleted_raw_seq data member has been assigned a value.
    bool IsSetDeleted_raw_seq(void) const;
    /// Check whether it is safe or not to call GetDeleted_raw_seq method.
    bool CanGetDeleted_raw_seq(void) const;
    void ResetDeleted_raw_seq(void);
    const TDeleted_raw_seq& GetDeleted_raw_seq(void) const;
    void SetDeleted_raw_seq(const TDeleted_raw_seq& value);
    void SetDeleted_raw_seq(TDeleted_raw_seq&& value);
    TDeleted_raw_seq& SetDeleted_raw_seq(void);

    /// mandatory
    /// typedef C_Inserted_seq_info TInserted_seq_info
    ///  Check whether the Inserted_seq_info data member has been assigned a value.
    bool IsSetInserted_seq_info(void) const;
    /// Check whether it is safe or not to call GetInserted_seq_info method.
    bool CanGetInserted_seq_info(void) const;
    void ResetInserted_seq_info(void);
    const TInserted_seq_info& GetInserted_seq_info(void) const;
    void SetInserted_seq_info(TInserted_seq_info& value);
    TInserted_seq_info& SetInserted_seq_info(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CDelins_Base(const CDelins_Base&);
    CDelins_Base& operator=(const CDelins_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TLoc > m_Loc;
    string m_Deleted_raw_seq;
    CRef< TInserted_seq_info > m_Inserted_seq_info;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CDelins_Base::C_Inserted_seq_info::E_Choice CDelins_Base::C_Inserted_seq_info::Which(void) const
{
    return m_choice;
}

inline
void CDelins_Base::C_Inserted_seq_info::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CDelins_Base::C_Inserted_seq_info::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CDelins_Base::C_Inserted_seq_info::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CDelins_Base::C_Inserted_seq_info::IsIdentifier(void) const
{
    return m_choice == e_Identifier;
}

inline
const CDelins_Base::C_Inserted_seq_info::TIdentifier& CDelins_Base::C_Inserted_seq_info::GetIdentifier(void) const
{
    CheckSelected(e_Identifier);
    return *m_string;
}

inline
CDelins_Base::C_Inserted_seq_info::TIdentifier& CDelins_Base::C_Inserted_seq_info::SetIdentifier(void)
{
    Select(e_Identifier, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CDelins_Base::C_Inserted_seq_info::IsRaw_seq(void) const
{
    return m_choice == e_Raw_seq;
}

inline
const CDelins_Base::C_Inserted_seq_info::TRaw_seq& CDelins_Base::C_Inserted_seq_info::GetRaw_seq(void) const
{
    CheckSelected(e_Raw_seq);
    return *m_string;
}

inline
CDelins_Base::C_Inserted_seq_info::TRaw_seq& CDelins_Base::C_Inserted_seq_info::SetRaw_seq(void)
{
    Select(e_Raw_seq, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CDelins_Base::C_Inserted_seq_info::IsCount(void) const
{
    return m_choice == e_Count;
}

inline
bool CDelins_Base::C_Inserted_seq_info::IsSubseq(void) const
{
    return m_choice == e_Subseq;
}

inline
bool CDelins_Base::IsSetLoc(void) const
{
    return m_Loc.NotEmpty();
}

inline
bool CDelins_Base::CanGetLoc(void) const
{
    return true;
}

inline
const CDelins_Base::TLoc& CDelins_Base::GetLoc(void) const
{
    if ( !m_Loc ) {
        const_cast<CDelins_Base*>(this)->ResetLoc();
    }
    return (*m_Loc);
}

inline
CDelins_Base::TLoc& CDelins_Base::SetLoc(void)
{
    if ( !m_Loc ) {
        ResetLoc();
    }
    return (*m_Loc);
}

inline
bool CDelins_Base::IsSetDeleted_raw_seq(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CDelins_Base::CanGetDeleted_raw_seq(void) const
{
    return IsSetDeleted_raw_seq();
}

inline
const CDelins_Base::TDeleted_raw_seq& CDelins_Base::GetDeleted_raw_seq(void) const
{
    if (!CanGetDeleted_raw_seq()) {
        ThrowUnassigned(1);
    }
    return m_Deleted_raw_seq;
}

inline
void CDelins_Base::SetDeleted_raw_seq(const CDelins_Base::TDeleted_raw_seq& value)
{
    m_Deleted_raw_seq = value;
    m_set_State[0] |= 0xc;
}

inline
void CDelins_Base::SetDeleted_raw_seq(CDelins_Base::TDeleted_raw_seq&& value)
{
    m_Deleted_raw_seq = std::forward<CDelins_Base::TDeleted_raw_seq>(value);
    m_set_State[0] |= 0xc;
}

inline
CDelins_Base::TDeleted_raw_seq& CDelins_Base::SetDeleted_raw_seq(void)
{
#ifdef _DEBUG
    if (!IsSetDeleted_raw_seq()) {
        m_Deleted_raw_seq = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Deleted_raw_seq;
}

inline
bool CDelins_Base::IsSetInserted_seq_info(void) const
{
    return m_Inserted_seq_info.NotEmpty();
}

inline
bool CDelins_Base::CanGetInserted_seq_info(void) const
{
    return true;
}

inline
const CDelins_Base::TInserted_seq_info& CDelins_Base::GetInserted_seq_info(void) const
{
    if ( !m_Inserted_seq_info ) {
        const_cast<CDelins_Base*>(this)->ResetInserted_seq_info();
    }
    return (*m_Inserted_seq_info);
}

inline
CDelins_Base::TInserted_seq_info& CDelins_Base::SetInserted_seq_info(void)
{
    if ( !m_Inserted_seq_info ) {
        ResetInserted_seq_info();
    }
    return (*m_Inserted_seq_info);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_VARREP_DELINS_BASE_HPP
