/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file CtermExtension_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'varrep.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_VARREP_CTERMEXTENSION_BASE_HPP
#define OBJECTS_VARREP_CTERMEXTENSION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CCount;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CCtermExtension_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CCtermExtension_Base(void);
    // destructor
    virtual ~CCtermExtension_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TRefStop;
    typedef string TNewAa;
    typedef CCount TLength;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_refStop,
        e_newAa,
        e_length
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TRefStop
    ///  Check whether the RefStop data member has been assigned a value.
    bool IsSetRefStop(void) const;
    /// Check whether it is safe or not to call GetRefStop method.
    bool CanGetRefStop(void) const;
    void ResetRefStop(void);
    TRefStop GetRefStop(void) const;
    void SetRefStop(TRefStop value);
    TRefStop& SetRefStop(void);

    /// mandatory
    /// typedef string TNewAa
    ///  Check whether the NewAa data member has been assigned a value.
    bool IsSetNewAa(void) const;
    /// Check whether it is safe or not to call GetNewAa method.
    bool CanGetNewAa(void) const;
    void ResetNewAa(void);
    const TNewAa& GetNewAa(void) const;
    void SetNewAa(const TNewAa& value);
    void SetNewAa(TNewAa&& value);
    TNewAa& SetNewAa(void);

    /// mandatory
    /// typedef CCount TLength
    ///  Check whether the Length data member has been assigned a value.
    bool IsSetLength(void) const;
    /// Check whether it is safe or not to call GetLength method.
    bool CanGetLength(void) const;
    void ResetLength(void);
    const TLength& GetLength(void) const;
    void SetLength(TLength& value);
    TLength& SetLength(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCtermExtension_Base(const CCtermExtension_Base&);
    CCtermExtension_Base& operator=(const CCtermExtension_Base&);

    // data
    Uint4 m_set_State[1];
    int m_RefStop;
    string m_NewAa;
    CRef< TLength > m_Length;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCtermExtension_Base::IsSetRefStop(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CCtermExtension_Base::CanGetRefStop(void) const
{
    return IsSetRefStop();
}

inline
void CCtermExtension_Base::ResetRefStop(void)
{
    m_RefStop = 0;
    m_set_State[0] &= ~0x3;
}

inline
CCtermExtension_Base::TRefStop CCtermExtension_Base::GetRefStop(void) const
{
    if (!CanGetRefStop()) {
        ThrowUnassigned(0);
    }
    return m_RefStop;
}

inline
void CCtermExtension_Base::SetRefStop(CCtermExtension_Base::TRefStop value)
{
    m_RefStop = value;
    m_set_State[0] |= 0x3;
}

inline
CCtermExtension_Base::TRefStop& CCtermExtension_Base::SetRefStop(void)
{
#ifdef _DEBUG
    if (!IsSetRefStop()) {
        memset(&m_RefStop,UnassignedByte(),sizeof(m_RefStop));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_RefStop;
}

inline
bool CCtermExtension_Base::IsSetNewAa(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CCtermExtension_Base::CanGetNewAa(void) const
{
    return IsSetNewAa();
}

inline
const CCtermExtension_Base::TNewAa& CCtermExtension_Base::GetNewAa(void) const
{
    if (!CanGetNewAa()) {
        ThrowUnassigned(1);
    }
    return m_NewAa;
}

inline
void CCtermExtension_Base::SetNewAa(const CCtermExtension_Base::TNewAa& value)
{
    m_NewAa = value;
    m_set_State[0] |= 0xc;
}

inline
void CCtermExtension_Base::SetNewAa(CCtermExtension_Base::TNewAa&& value)
{
    m_NewAa = std::forward<CCtermExtension_Base::TNewAa>(value);
    m_set_State[0] |= 0xc;
}

inline
CCtermExtension_Base::TNewAa& CCtermExtension_Base::SetNewAa(void)
{
#ifdef _DEBUG
    if (!IsSetNewAa()) {
        m_NewAa = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_NewAa;
}

inline
bool CCtermExtension_Base::IsSetLength(void) const
{
    return m_Length.NotEmpty();
}

inline
bool CCtermExtension_Base::CanGetLength(void) const
{
    return true;
}

inline
const CCtermExtension_Base::TLength& CCtermExtension_Base::GetLength(void) const
{
    if ( !m_Length ) {
        const_cast<CCtermExtension_Base*>(this)->ResetLength();
    }
    return (*m_Length);
}

inline
CCtermExtension_Base::TLength& CCtermExtension_Base::SetLength(void)
{
    if ( !m_Length ) {
        ResetLength();
    }
    return (*m_Length);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_VARREP_CTERMEXTENSION_BASE_HPP
