/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file TMgr_BlastRIDDetail_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'trackmgr.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_TRACKMGR_TMGR_BLASTRIDDETAIL_BASE_HPP
#define OBJECTS_TRACKMGR_TMGR_BLASTRIDDETAIL_BASE_HPP

// extra headers
#include <objects/trackmgr/trackmgr_export.h>

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CTMgr_BlastQuerySeq;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_TRACKMGR_EXPORT CTMgr_BlastRIDDetail_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTMgr_BlastRIDDetail_Base(void);
    // destructor
    virtual ~CTMgr_BlastRIDDetail_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TRid;
    typedef string TTitle;
    typedef list< CRef< CTMgr_BlastQuerySeq > > TQuery_sequences;
    typedef time_t TCreated;
    typedef string TDatabase;
    typedef string TProgram;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_rid,
        e_title,
        e_query_sequences,
        e_created,
        e_database,
        e_program
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 7> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TRid
    ///  Check whether the Rid data member has been assigned a value.
    bool IsSetRid(void) const;
    /// Check whether it is safe or not to call GetRid method.
    bool CanGetRid(void) const;
    void ResetRid(void);
    const TRid& GetRid(void) const;
    void SetRid(const TRid& value);
    void SetRid(TRid&& value);
    TRid& SetRid(void);

    /// optional
    /// typedef string TTitle
    ///  Check whether the Title data member has been assigned a value.
    bool IsSetTitle(void) const;
    /// Check whether it is safe or not to call GetTitle method.
    bool CanGetTitle(void) const;
    void ResetTitle(void);
    const TTitle& GetTitle(void) const;
    void SetTitle(const TTitle& value);
    void SetTitle(TTitle&& value);
    TTitle& SetTitle(void);

    /// optional
    /// typedef list< CRef< CTMgr_BlastQuerySeq > > TQuery_sequences
    ///  Check whether the Query_sequences data member has been assigned a value.
    bool IsSetQuery_sequences(void) const;
    /// Check whether it is safe or not to call GetQuery_sequences method.
    bool CanGetQuery_sequences(void) const;
    void ResetQuery_sequences(void);
    const TQuery_sequences& GetQuery_sequences(void) const;
    TQuery_sequences& SetQuery_sequences(void);

    /// seconds since unix epoch, 00:00:00 UTC on 1 January 1970
    /// optional
    /// typedef time_t TCreated
    ///  Check whether the Created data member has been assigned a value.
    bool IsSetCreated(void) const;
    /// Check whether it is safe or not to call GetCreated method.
    bool CanGetCreated(void) const;
    void ResetCreated(void);
    TCreated GetCreated(void) const;
    void SetCreated(TCreated value);
    TCreated& SetCreated(void);

    /// optional
    /// typedef string TDatabase
    ///  Check whether the Database data member has been assigned a value.
    bool IsSetDatabase(void) const;
    /// Check whether it is safe or not to call GetDatabase method.
    bool CanGetDatabase(void) const;
    void ResetDatabase(void);
    const TDatabase& GetDatabase(void) const;
    void SetDatabase(const TDatabase& value);
    void SetDatabase(TDatabase&& value);
    TDatabase& SetDatabase(void);

    /// optional
    /// typedef string TProgram
    ///  Check whether the Program data member has been assigned a value.
    bool IsSetProgram(void) const;
    /// Check whether it is safe or not to call GetProgram method.
    bool CanGetProgram(void) const;
    void ResetProgram(void);
    const TProgram& GetProgram(void) const;
    void SetProgram(const TProgram& value);
    void SetProgram(TProgram&& value);
    TProgram& SetProgram(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTMgr_BlastRIDDetail_Base(const CTMgr_BlastRIDDetail_Base&);
    CTMgr_BlastRIDDetail_Base& operator=(const CTMgr_BlastRIDDetail_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Rid;
    string m_Title;
    list< CRef< CTMgr_BlastQuerySeq > > m_Query_sequences;
    time_t m_Created;
    string m_Database;
    string m_Program;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTMgr_BlastRIDDetail_Base::IsSetRid(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CTMgr_BlastRIDDetail_Base::CanGetRid(void) const
{
    return IsSetRid();
}

inline
const CTMgr_BlastRIDDetail_Base::TRid& CTMgr_BlastRIDDetail_Base::GetRid(void) const
{
    if (!CanGetRid()) {
        ThrowUnassigned(0);
    }
    return m_Rid;
}

inline
void CTMgr_BlastRIDDetail_Base::SetRid(const CTMgr_BlastRIDDetail_Base::TRid& value)
{
    m_Rid = value;
    m_set_State[0] |= 0x3;
}

inline
void CTMgr_BlastRIDDetail_Base::SetRid(CTMgr_BlastRIDDetail_Base::TRid&& value)
{
    m_Rid = std::forward<CTMgr_BlastRIDDetail_Base::TRid>(value);
    m_set_State[0] |= 0x3;
}

inline
CTMgr_BlastRIDDetail_Base::TRid& CTMgr_BlastRIDDetail_Base::SetRid(void)
{
#ifdef _DEBUG
    if (!IsSetRid()) {
        m_Rid = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Rid;
}

inline
bool CTMgr_BlastRIDDetail_Base::IsSetTitle(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CTMgr_BlastRIDDetail_Base::CanGetTitle(void) const
{
    return IsSetTitle();
}

inline
const CTMgr_BlastRIDDetail_Base::TTitle& CTMgr_BlastRIDDetail_Base::GetTitle(void) const
{
    if (!CanGetTitle()) {
        ThrowUnassigned(1);
    }
    return m_Title;
}

inline
void CTMgr_BlastRIDDetail_Base::SetTitle(const CTMgr_BlastRIDDetail_Base::TTitle& value)
{
    m_Title = value;
    m_set_State[0] |= 0xc;
}

inline
void CTMgr_BlastRIDDetail_Base::SetTitle(CTMgr_BlastRIDDetail_Base::TTitle&& value)
{
    m_Title = std::forward<CTMgr_BlastRIDDetail_Base::TTitle>(value);
    m_set_State[0] |= 0xc;
}

inline
CTMgr_BlastRIDDetail_Base::TTitle& CTMgr_BlastRIDDetail_Base::SetTitle(void)
{
#ifdef _DEBUG
    if (!IsSetTitle()) {
        m_Title = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Title;
}

inline
bool CTMgr_BlastRIDDetail_Base::IsSetQuery_sequences(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CTMgr_BlastRIDDetail_Base::CanGetQuery_sequences(void) const
{
    return true;
}

inline
const CTMgr_BlastRIDDetail_Base::TQuery_sequences& CTMgr_BlastRIDDetail_Base::GetQuery_sequences(void) const
{
    return m_Query_sequences;
}

inline
CTMgr_BlastRIDDetail_Base::TQuery_sequences& CTMgr_BlastRIDDetail_Base::SetQuery_sequences(void)
{
    m_set_State[0] |= 0x10;
    return m_Query_sequences;
}

inline
bool CTMgr_BlastRIDDetail_Base::IsSetCreated(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CTMgr_BlastRIDDetail_Base::CanGetCreated(void) const
{
    return IsSetCreated();
}

inline
void CTMgr_BlastRIDDetail_Base::ResetCreated(void)
{
    m_Created = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CTMgr_BlastRIDDetail_Base::TCreated CTMgr_BlastRIDDetail_Base::GetCreated(void) const
{
    if (!CanGetCreated()) {
        ThrowUnassigned(3);
    }
    return m_Created;
}

inline
void CTMgr_BlastRIDDetail_Base::SetCreated(CTMgr_BlastRIDDetail_Base::TCreated value)
{
    m_Created = value;
    m_set_State[0] |= 0xc0;
}

inline
CTMgr_BlastRIDDetail_Base::TCreated& CTMgr_BlastRIDDetail_Base::SetCreated(void)
{
#ifdef _DEBUG
    if (!IsSetCreated()) {
        memset(&m_Created,UnassignedByte(),sizeof(m_Created));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Created;
}

inline
bool CTMgr_BlastRIDDetail_Base::IsSetDatabase(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CTMgr_BlastRIDDetail_Base::CanGetDatabase(void) const
{
    return IsSetDatabase();
}

inline
const CTMgr_BlastRIDDetail_Base::TDatabase& CTMgr_BlastRIDDetail_Base::GetDatabase(void) const
{
    if (!CanGetDatabase()) {
        ThrowUnassigned(4);
    }
    return m_Database;
}

inline
void CTMgr_BlastRIDDetail_Base::SetDatabase(const CTMgr_BlastRIDDetail_Base::TDatabase& value)
{
    m_Database = value;
    m_set_State[0] |= 0x300;
}

inline
void CTMgr_BlastRIDDetail_Base::SetDatabase(CTMgr_BlastRIDDetail_Base::TDatabase&& value)
{
    m_Database = std::forward<CTMgr_BlastRIDDetail_Base::TDatabase>(value);
    m_set_State[0] |= 0x300;
}

inline
CTMgr_BlastRIDDetail_Base::TDatabase& CTMgr_BlastRIDDetail_Base::SetDatabase(void)
{
#ifdef _DEBUG
    if (!IsSetDatabase()) {
        m_Database = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Database;
}

inline
bool CTMgr_BlastRIDDetail_Base::IsSetProgram(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CTMgr_BlastRIDDetail_Base::CanGetProgram(void) const
{
    return IsSetProgram();
}

inline
const CTMgr_BlastRIDDetail_Base::TProgram& CTMgr_BlastRIDDetail_Base::GetProgram(void) const
{
    if (!CanGetProgram()) {
        ThrowUnassigned(5);
    }
    return m_Program;
}

inline
void CTMgr_BlastRIDDetail_Base::SetProgram(const CTMgr_BlastRIDDetail_Base::TProgram& value)
{
    m_Program = value;
    m_set_State[0] |= 0xc00;
}

inline
void CTMgr_BlastRIDDetail_Base::SetProgram(CTMgr_BlastRIDDetail_Base::TProgram&& value)
{
    m_Program = std::forward<CTMgr_BlastRIDDetail_Base::TProgram>(value);
    m_set_State[0] |= 0xc00;
}

inline
CTMgr_BlastRIDDetail_Base::TProgram& CTMgr_BlastRIDDetail_Base::SetProgram(void)
{
#ifdef _DEBUG
    if (!IsSetProgram()) {
        m_Program = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Program;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_TRACKMGR_TMGR_BLASTRIDDETAIL_BASE_HPP
