/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Taxon1_info_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'taxon1.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_TAXON1_TAXON1_INFO_BASE_HPP
#define OBJECTS_TAXON1_TAXON1_INFO_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_TAXON1_EXPORT CTaxon1_info_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTaxon1_info_Base(void);
    // destructor
    virtual ~CTaxon1_info_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef NCBI_NS_NCBI::TIntId TIval1;
    typedef NCBI_NS_NCBI::TIntId TIval2;
    typedef string TSval;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_ival1,
        e_ival2,
        e_sval
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef NCBI_NS_NCBI::TIntId TIval1
    ///  Check whether the Ival1 data member has been assigned a value.
    bool IsSetIval1(void) const;
    /// Check whether it is safe or not to call GetIval1 method.
    bool CanGetIval1(void) const;
    void ResetIval1(void);
    TIval1 GetIval1(void) const;
    void SetIval1(TIval1 value);
    TIval1& SetIval1(void);

    /// mandatory
    /// typedef NCBI_NS_NCBI::TIntId TIval2
    ///  Check whether the Ival2 data member has been assigned a value.
    bool IsSetIval2(void) const;
    /// Check whether it is safe or not to call GetIval2 method.
    bool CanGetIval2(void) const;
    void ResetIval2(void);
    TIval2 GetIval2(void) const;
    void SetIval2(TIval2 value);
    TIval2& SetIval2(void);

    /// optional
    /// typedef string TSval
    ///  Check whether the Sval data member has been assigned a value.
    bool IsSetSval(void) const;
    /// Check whether it is safe or not to call GetSval method.
    bool CanGetSval(void) const;
    void ResetSval(void);
    const TSval& GetSval(void) const;
    void SetSval(const TSval& value);
    void SetSval(TSval&& value);
    TSval& SetSval(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTaxon1_info_Base(const CTaxon1_info_Base&);
    CTaxon1_info_Base& operator=(const CTaxon1_info_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::TIntId m_Ival1;
    NCBI_NS_NCBI::TIntId m_Ival2;
    string m_Sval;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTaxon1_info_Base::IsSetIval1(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CTaxon1_info_Base::CanGetIval1(void) const
{
    return IsSetIval1();
}

inline
void CTaxon1_info_Base::ResetIval1(void)
{
    m_Ival1 = 0;
    m_set_State[0] &= ~0x3;
}

inline
CTaxon1_info_Base::TIval1 CTaxon1_info_Base::GetIval1(void) const
{
    if (!CanGetIval1()) {
        ThrowUnassigned(0);
    }
    return m_Ival1;
}

inline
void CTaxon1_info_Base::SetIval1(CTaxon1_info_Base::TIval1 value)
{
    m_Ival1 = value;
    m_set_State[0] |= 0x3;
}

inline
CTaxon1_info_Base::TIval1& CTaxon1_info_Base::SetIval1(void)
{
#ifdef _DEBUG
    if (!IsSetIval1()) {
        memset(&m_Ival1,UnassignedByte(),sizeof(m_Ival1));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Ival1;
}

inline
bool CTaxon1_info_Base::IsSetIval2(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CTaxon1_info_Base::CanGetIval2(void) const
{
    return IsSetIval2();
}

inline
void CTaxon1_info_Base::ResetIval2(void)
{
    m_Ival2 = 0;
    m_set_State[0] &= ~0xc;
}

inline
CTaxon1_info_Base::TIval2 CTaxon1_info_Base::GetIval2(void) const
{
    if (!CanGetIval2()) {
        ThrowUnassigned(1);
    }
    return m_Ival2;
}

inline
void CTaxon1_info_Base::SetIval2(CTaxon1_info_Base::TIval2 value)
{
    m_Ival2 = value;
    m_set_State[0] |= 0xc;
}

inline
CTaxon1_info_Base::TIval2& CTaxon1_info_Base::SetIval2(void)
{
#ifdef _DEBUG
    if (!IsSetIval2()) {
        memset(&m_Ival2,UnassignedByte(),sizeof(m_Ival2));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Ival2;
}

inline
bool CTaxon1_info_Base::IsSetSval(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CTaxon1_info_Base::CanGetSval(void) const
{
    return IsSetSval();
}

inline
const CTaxon1_info_Base::TSval& CTaxon1_info_Base::GetSval(void) const
{
    if (!CanGetSval()) {
        ThrowUnassigned(2);
    }
    return m_Sval;
}

inline
void CTaxon1_info_Base::SetSval(const CTaxon1_info_Base::TSval& value)
{
    m_Sval = value;
    m_set_State[0] |= 0x30;
}

inline
void CTaxon1_info_Base::SetSval(CTaxon1_info_Base::TSval&& value)
{
    m_Sval = std::forward<CTaxon1_info_Base::TSval>(value);
    m_set_State[0] |= 0x30;
}

inline
CTaxon1_info_Base::TSval& CTaxon1_info_Base::SetSval(void)
{
#ifdef _DEBUG
    if (!IsSetSval()) {
        m_Sval = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Sval;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_TAXON1_TAXON1_INFO_BASE_HPP
