/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ID2S_Sequence_Piece_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqsplit.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQSPLIT_ID2S_SEQUENCE_PIECE_BASE_HPP
#define OBJECTS_SEQSPLIT_ID2S_SEQUENCE_PIECE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSeq_literal;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_ID2_EXPORT CID2S_Sequence_Piece_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CID2S_Sequence_Piece_Base(void);
    // destructor
    virtual ~CID2S_Sequence_Piece_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef TSeqPos TStart;
    typedef list< CRef< CSeq_literal > > TData;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_start,
        e_data
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// start position on sequence
    /// mandatory
    /// typedef TSeqPos TStart
    ///  Check whether the Start data member has been assigned a value.
    bool IsSetStart(void) const;
    /// Check whether it is safe or not to call GetStart method.
    bool CanGetStart(void) const;
    void ResetStart(void);
    TStart GetStart(void) const;
    void SetStart(TStart value);
    TStart& SetStart(void);

    /// mandatory
    /// typedef list< CRef< CSeq_literal > > TData
    ///  Check whether the Data data member has been assigned a value.
    bool IsSetData(void) const;
    /// Check whether it is safe or not to call GetData method.
    bool CanGetData(void) const;
    void ResetData(void);
    const TData& GetData(void) const;
    TData& SetData(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CID2S_Sequence_Piece_Base(const CID2S_Sequence_Piece_Base&);
    CID2S_Sequence_Piece_Base& operator=(const CID2S_Sequence_Piece_Base&);

    // data
    Uint4 m_set_State[1];
    TSeqPos m_Start;
    list< CRef< CSeq_literal > > m_Data;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CID2S_Sequence_Piece_Base::IsSetStart(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CID2S_Sequence_Piece_Base::CanGetStart(void) const
{
    return IsSetStart();
}

inline
void CID2S_Sequence_Piece_Base::ResetStart(void)
{
    m_Start = 0;
    m_set_State[0] &= ~0x3;
}

inline
CID2S_Sequence_Piece_Base::TStart CID2S_Sequence_Piece_Base::GetStart(void) const
{
    if (!CanGetStart()) {
        ThrowUnassigned(0);
    }
    return m_Start;
}

inline
void CID2S_Sequence_Piece_Base::SetStart(CID2S_Sequence_Piece_Base::TStart value)
{
    m_Start = value;
    m_set_State[0] |= 0x3;
}

inline
CID2S_Sequence_Piece_Base::TStart& CID2S_Sequence_Piece_Base::SetStart(void)
{
#ifdef _DEBUG
    if (!IsSetStart()) {
        memset(&m_Start,UnassignedByte(),sizeof(m_Start));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Start;
}

inline
bool CID2S_Sequence_Piece_Base::IsSetData(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CID2S_Sequence_Piece_Base::CanGetData(void) const
{
    return true;
}

inline
const CID2S_Sequence_Piece_Base::TData& CID2S_Sequence_Piece_Base::GetData(void) const
{
    return m_Data;
}

inline
CID2S_Sequence_Piece_Base::TData& CID2S_Sequence_Piece_Base::SetData(void)
{
    m_set_State[0] |= 0x4;
    return m_Data;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQSPLIT_ID2S_SEQUENCE_PIECE_BASE_HPP
