/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PDB_seq_id_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqloc.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQLOC_PDB_SEQ_ID_BASE_HPP
#define OBJECTS_SEQLOC_PDB_SEQ_ID_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <objects/seqloc/PDB_mol_id.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDate;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// 
class NCBI_SEQLOC_EXPORT CPDB_seq_id_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPDB_seq_id_Base(void);
    // destructor
    virtual ~CPDB_seq_id_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CPDB_mol_id TMol;
    typedef int TChain;
    typedef CDate TRel;
    typedef string TChain_id;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_mol,
        e_chain,
        e_rel,
        e_chain_id
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// the molecule name
    /// mandatory
    /// typedef CPDB_mol_id TMol
    ///  Check whether the Mol data member has been assigned a value.
    bool IsSetMol(void) const;
    /// Check whether it is safe or not to call GetMol method.
    bool CanGetMol(void) const;
    void ResetMol(void);
    const TMol& GetMol(void) const;
    void SetMol(const TMol& value);
    TMol& SetMol(void);

    /// Deprecated:  'chain' can't support multiple character
    /// PDB chain identifiers (introduced in 2015).
    /// 'chain-id' stores chain identifiers of any length.
    /// optional with default 32
    /// typedef int TChain
    ///  Check whether the Chain data member has been assigned a value.
    bool IsSetChain(void) const;
    /// Check whether it is safe or not to call GetChain method.
    bool CanGetChain(void) const;
    void ResetChain(void);
    void SetDefaultChain(void);
    TChain GetChain(void) const;
    void SetChain(TChain value);
    TChain& SetChain(void);

    /// release date, month and year
    /// optional
    /// typedef CDate TRel
    ///  Check whether the Rel data member has been assigned a value.
    bool IsSetRel(void) const;
    /// Check whether it is safe or not to call GetRel method.
    bool CanGetRel(void) const;
    void ResetRel(void);
    const TRel& GetRel(void) const;
    void SetRel(TRel& value);
    TRel& SetRel(void);

    /// chain identifier; length-independent generalization of 'chain' 
    /// optional
    /// typedef string TChain_id
    ///  Check whether the Chain_id data member has been assigned a value.
    bool IsSetChain_id(void) const;
    /// Check whether it is safe or not to call GetChain_id method.
    bool CanGetChain_id(void) const;
    void ResetChain_id(void);
    const TChain_id& GetChain_id(void) const;
    void SetChain_id(const TChain_id& value);
    void SetChain_id(TChain_id&& value);
    TChain_id& SetChain_id(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPDB_seq_id_Base(const CPDB_seq_id_Base&);
    CPDB_seq_id_Base& operator=(const CPDB_seq_id_Base&);

    // data
    Uint4 m_set_State[1];
    CPDB_mol_id m_Mol;
    int m_Chain;
    CRef< TRel > m_Rel;
    string m_Chain_id;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPDB_seq_id_Base::IsSetMol(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPDB_seq_id_Base::CanGetMol(void) const
{
    return IsSetMol();
}

inline
const CPDB_seq_id_Base::TMol& CPDB_seq_id_Base::GetMol(void) const
{
    if (!CanGetMol()) {
        ThrowUnassigned(0);
    }
    return m_Mol;
}

inline
void CPDB_seq_id_Base::SetMol(const CPDB_seq_id_Base::TMol& value)
{
    m_Mol = value;
    m_set_State[0] |= 0x3;
}

inline
CPDB_seq_id_Base::TMol& CPDB_seq_id_Base::SetMol(void)
{
    m_set_State[0] |= 0x1;
    return m_Mol;
}

inline
bool CPDB_seq_id_Base::IsSetChain(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPDB_seq_id_Base::CanGetChain(void) const
{
    return true;
}

inline
void CPDB_seq_id_Base::ResetChain(void)
{
    m_Chain = 32;
    m_set_State[0] &= ~0xc;
}

inline
void CPDB_seq_id_Base::SetDefaultChain(void)
{
    ResetChain();
}

inline
CPDB_seq_id_Base::TChain CPDB_seq_id_Base::GetChain(void) const
{
    return m_Chain;
}

inline
void CPDB_seq_id_Base::SetChain(CPDB_seq_id_Base::TChain value)
{
    m_Chain = value;
    m_set_State[0] |= 0xc;
}

inline
CPDB_seq_id_Base::TChain& CPDB_seq_id_Base::SetChain(void)
{
#ifdef _DEBUG
    if (!IsSetChain()) {
        memset(&m_Chain,UnassignedByte(),sizeof(m_Chain));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Chain;
}

inline
bool CPDB_seq_id_Base::IsSetRel(void) const
{
    return m_Rel.NotEmpty();
}

inline
bool CPDB_seq_id_Base::CanGetRel(void) const
{
    return IsSetRel();
}

inline
const CPDB_seq_id_Base::TRel& CPDB_seq_id_Base::GetRel(void) const
{
    if (!CanGetRel()) {
        ThrowUnassigned(2);
    }
    return (*m_Rel);
}

inline
bool CPDB_seq_id_Base::IsSetChain_id(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CPDB_seq_id_Base::CanGetChain_id(void) const
{
    return IsSetChain_id();
}

inline
const CPDB_seq_id_Base::TChain_id& CPDB_seq_id_Base::GetChain_id(void) const
{
    if (!CanGetChain_id()) {
        ThrowUnassigned(3);
    }
    return m_Chain_id;
}

inline
void CPDB_seq_id_Base::SetChain_id(const CPDB_seq_id_Base::TChain_id& value)
{
    m_Chain_id = value;
    m_set_State[0] |= 0xc0;
}

inline
void CPDB_seq_id_Base::SetChain_id(CPDB_seq_id_Base::TChain_id&& value)
{
    m_Chain_id = std::forward<CPDB_seq_id_Base::TChain_id>(value);
    m_set_State[0] |= 0xc0;
}

inline
CPDB_seq_id_Base::TChain_id& CPDB_seq_id_Base::SetChain_id(void)
{
#ifdef _DEBUG
    if (!IsSetChain_id()) {
        m_Chain_id = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Chain_id;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQLOC_PDB_SEQ_ID_BASE_HPP
