/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Clone_seq_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqfeat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQFEAT_CLONE_SEQ_BASE_HPP
#define OBJECTS_SEQFEAT_CLONE_SEQ_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDbtag;
class CSeq_loc;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQFEAT_EXPORT CClone_seq_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CClone_seq_Base(void);
    // destructor
    virtual ~CClone_seq_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum EType {
        eType_insert =   0,
        eType_end    =   1,
        eType_other  = 255
    };
    
    /// Access to EType's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EType)(void);
    
    enum EConfidence {
        eConfidence_multiple      =   0,  ///< Multiple hits
        eConfidence_na            =   1,  ///< Unspecified
        eConfidence_nohit_rep     =   2,  ///< No hits, end flagged repetitive
        eConfidence_nohitnorep    =   3,  ///< No hits, end not flagged repetitive
        eConfidence_other_chrm    =   4,  ///< Hit on different chromosome
        eConfidence_unique        =   5,
        eConfidence_virtual       =   6,  ///< Virtual (hasn't been sequenced)
        eConfidence_multiple_rep  =   7,  ///< Multiple hits, end flagged repetitive
        eConfidence_multiplenorep =   8,  ///< Multiple hits, end not flagged repetitive
        eConfidence_no_hit        =   9,  ///< No hits
        eConfidence_other         = 255
    };
    
    /// Access to EConfidence's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EConfidence)(void);
    
    enum ESupport {
        eSupport_prototype      = 0,  ///< sequence used to place clone
        eSupport_supporting     = 1,  ///< sequence supports placement
        eSupport_supports_other = 2,  ///< supports a different placement
        eSupport_non_supporting = 3  ///< does not support any placement
    };
    
    /// Access to ESupport's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(ESupport)(void);
    
    // types
    typedef int TType;
    typedef int TConfidence;
    typedef CSeq_loc TLocation;
    typedef CSeq_loc TSeq;
    typedef CDbtag TAlign_id;
    typedef int TSupport;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_type,
        e_confidence,
        e_location,
        e_seq,
        e_align_id,
        e_support
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 7> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// optional
    /// typedef int TConfidence
    ///  Check whether the Confidence data member has been assigned a value.
    bool IsSetConfidence(void) const;
    /// Check whether it is safe or not to call GetConfidence method.
    bool CanGetConfidence(void) const;
    void ResetConfidence(void);
    TConfidence GetConfidence(void) const;
    void SetConfidence(TConfidence value);
    TConfidence& SetConfidence(void);

    /// location on sequence
    /// mandatory
    /// typedef CSeq_loc TLocation
    ///  Check whether the Location data member has been assigned a value.
    bool IsSetLocation(void) const;
    /// Check whether it is safe or not to call GetLocation method.
    bool CanGetLocation(void) const;
    void ResetLocation(void);
    const TLocation& GetLocation(void) const;
    void SetLocation(TLocation& value);
    TLocation& SetLocation(void);

    /// clone sequence location
    /// optional
    /// typedef CSeq_loc TSeq
    ///  Check whether the Seq data member has been assigned a value.
    bool IsSetSeq(void) const;
    /// Check whether it is safe or not to call GetSeq method.
    bool CanGetSeq(void) const;
    void ResetSeq(void);
    const TSeq& GetSeq(void) const;
    void SetSeq(TSeq& value);
    TSeq& SetSeq(void);

    /// internal alignment identifier
    /// optional
    /// typedef CDbtag TAlign_id
    ///  Check whether the Align_id data member has been assigned a value.
    bool IsSetAlign_id(void) const;
    /// Check whether it is safe or not to call GetAlign_id method.
    bool CanGetAlign_id(void) const;
    void ResetAlign_id(void);
    const TAlign_id& GetAlign_id(void) const;
    void SetAlign_id(TAlign_id& value);
    TAlign_id& SetAlign_id(void);

    /// optional
    /// typedef int TSupport
    ///  Check whether the Support data member has been assigned a value.
    bool IsSetSupport(void) const;
    /// Check whether it is safe or not to call GetSupport method.
    bool CanGetSupport(void) const;
    void ResetSupport(void);
    TSupport GetSupport(void) const;
    void SetSupport(TSupport value);
    TSupport& SetSupport(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CClone_seq_Base(const CClone_seq_Base&);
    CClone_seq_Base& operator=(const CClone_seq_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Type;
    int m_Confidence;
    CRef< TLocation > m_Location;
    CRef< TSeq > m_Seq;
    CRef< TAlign_id > m_Align_id;
    int m_Support;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CClone_seq_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CClone_seq_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CClone_seq_Base::ResetType(void)
{
    m_Type = (EType)(0);
    m_set_State[0] &= ~0x3;
}

inline
CClone_seq_Base::TType CClone_seq_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(0);
    }
    return m_Type;
}

inline
void CClone_seq_Base::SetType(CClone_seq_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0x3;
}

inline
CClone_seq_Base::TType& CClone_seq_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Type;
}

inline
bool CClone_seq_Base::IsSetConfidence(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CClone_seq_Base::CanGetConfidence(void) const
{
    return IsSetConfidence();
}

inline
void CClone_seq_Base::ResetConfidence(void)
{
    m_Confidence = (EConfidence)(0);
    m_set_State[0] &= ~0xc;
}

inline
CClone_seq_Base::TConfidence CClone_seq_Base::GetConfidence(void) const
{
    if (!CanGetConfidence()) {
        ThrowUnassigned(1);
    }
    return m_Confidence;
}

inline
void CClone_seq_Base::SetConfidence(CClone_seq_Base::TConfidence value)
{
    m_Confidence = value;
    m_set_State[0] |= 0xc;
}

inline
CClone_seq_Base::TConfidence& CClone_seq_Base::SetConfidence(void)
{
#ifdef _DEBUG
    if (!IsSetConfidence()) {
        memset(&m_Confidence,UnassignedByte(),sizeof(m_Confidence));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Confidence;
}

inline
bool CClone_seq_Base::IsSetLocation(void) const
{
    return m_Location.NotEmpty();
}

inline
bool CClone_seq_Base::CanGetLocation(void) const
{
    return true;
}

inline
const CClone_seq_Base::TLocation& CClone_seq_Base::GetLocation(void) const
{
    if ( !m_Location ) {
        const_cast<CClone_seq_Base*>(this)->ResetLocation();
    }
    return (*m_Location);
}

inline
CClone_seq_Base::TLocation& CClone_seq_Base::SetLocation(void)
{
    if ( !m_Location ) {
        ResetLocation();
    }
    return (*m_Location);
}

inline
bool CClone_seq_Base::IsSetSeq(void) const
{
    return m_Seq.NotEmpty();
}

inline
bool CClone_seq_Base::CanGetSeq(void) const
{
    return IsSetSeq();
}

inline
const CClone_seq_Base::TSeq& CClone_seq_Base::GetSeq(void) const
{
    if (!CanGetSeq()) {
        ThrowUnassigned(3);
    }
    return (*m_Seq);
}

inline
bool CClone_seq_Base::IsSetAlign_id(void) const
{
    return m_Align_id.NotEmpty();
}

inline
bool CClone_seq_Base::CanGetAlign_id(void) const
{
    return IsSetAlign_id();
}

inline
const CClone_seq_Base::TAlign_id& CClone_seq_Base::GetAlign_id(void) const
{
    if (!CanGetAlign_id()) {
        ThrowUnassigned(4);
    }
    return (*m_Align_id);
}

inline
bool CClone_seq_Base::IsSetSupport(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CClone_seq_Base::CanGetSupport(void) const
{
    return IsSetSupport();
}

inline
void CClone_seq_Base::ResetSupport(void)
{
    m_Support = (ESupport)(0);
    m_set_State[0] &= ~0xc00;
}

inline
CClone_seq_Base::TSupport CClone_seq_Base::GetSupport(void) const
{
    if (!CanGetSupport()) {
        ThrowUnassigned(5);
    }
    return m_Support;
}

inline
void CClone_seq_Base::SetSupport(CClone_seq_Base::TSupport value)
{
    m_Support = value;
    m_set_State[0] |= 0xc00;
}

inline
CClone_seq_Base::TSupport& CClone_seq_Base::SetSupport(void)
{
#ifdef _DEBUG
    if (!IsSetSupport()) {
        memset(&m_Support,UnassignedByte(),sizeof(m_Support));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Support;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQFEAT_CLONE_SEQ_BASE_HPP
