/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file EMBL_block_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqblock.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQBLOCK_EMBL_BLOCK_BASE_HPP
#define OBJECTS_SEQBLOCK_EMBL_BLOCK_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDate;
class CEMBL_xref;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQBLOCK_EXPORT CEMBL_block_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CEMBL_block_Base(void);
    // destructor
    virtual ~CEMBL_block_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum EClass {
        eClass_not_set     =   0,
        eClass_standard    =   1,
        eClass_unannotated =   2,
        eClass_other       = 255
    };
    
    /// Access to EClass's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EClass)(void);
    
    enum EDiv {
        eDiv_fun   =   0,
        eDiv_inv   =   1,
        eDiv_mam   =   2,
        eDiv_org   =   3,
        eDiv_phg   =   4,
        eDiv_pln   =   5,
        eDiv_pri   =   6,
        eDiv_pro   =   7,
        eDiv_rod   =   8,
        eDiv_syn   =   9,
        eDiv_una   =  10,
        eDiv_vrl   =  11,
        eDiv_vrt   =  12,
        eDiv_pat   =  13,
        eDiv_est   =  14,
        eDiv_sts   =  15,
        eDiv_other = 255
    };
    
    /// Access to EDiv's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EDiv)(void);
    
    // types
    typedef EClass TClass;
    typedef EDiv TDiv;
    typedef CDate TCreation_date;
    typedef CDate TUpdate_date;
    typedef list< string > TExtra_acc;
    typedef list< string > TKeywords;
    typedef list< CRef< CEMBL_xref > > TXref;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_class,
        e_div,
        e_creation_date,
        e_update_date,
        e_extra_acc,
        e_keywords,
        e_xref
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 8> TmemberIndex;

    // getters
    // setters

    /// optional with default eClass_standard
    /// typedef EClass TClass
    ///  Check whether the Class data member has been assigned a value.
    bool IsSetClass(void) const;
    /// Check whether it is safe or not to call GetClass method.
    bool CanGetClass(void) const;
    void ResetClass(void);
    void SetDefaultClass(void);
    TClass GetClass(void) const;
    void SetClass(TClass value);
    TClass& SetClass(void);

    /// optional
    /// typedef EDiv TDiv
    ///  Check whether the Div data member has been assigned a value.
    bool IsSetDiv(void) const;
    /// Check whether it is safe or not to call GetDiv method.
    bool CanGetDiv(void) const;
    void ResetDiv(void);
    TDiv GetDiv(void) const;
    void SetDiv(TDiv value);
    TDiv& SetDiv(void);

    /// mandatory
    /// typedef CDate TCreation_date
    ///  Check whether the Creation_date data member has been assigned a value.
    bool IsSetCreation_date(void) const;
    /// Check whether it is safe or not to call GetCreation_date method.
    bool CanGetCreation_date(void) const;
    void ResetCreation_date(void);
    const TCreation_date& GetCreation_date(void) const;
    void SetCreation_date(TCreation_date& value);
    TCreation_date& SetCreation_date(void);

    /// mandatory
    /// typedef CDate TUpdate_date
    ///  Check whether the Update_date data member has been assigned a value.
    bool IsSetUpdate_date(void) const;
    /// Check whether it is safe or not to call GetUpdate_date method.
    bool CanGetUpdate_date(void) const;
    void ResetUpdate_date(void);
    const TUpdate_date& GetUpdate_date(void) const;
    void SetUpdate_date(TUpdate_date& value);
    TUpdate_date& SetUpdate_date(void);

    /// optional
    /// typedef list< string > TExtra_acc
    ///  Check whether the Extra_acc data member has been assigned a value.
    bool IsSetExtra_acc(void) const;
    /// Check whether it is safe or not to call GetExtra_acc method.
    bool CanGetExtra_acc(void) const;
    void ResetExtra_acc(void);
    const TExtra_acc& GetExtra_acc(void) const;
    TExtra_acc& SetExtra_acc(void);

    /// optional
    /// typedef list< string > TKeywords
    ///  Check whether the Keywords data member has been assigned a value.
    bool IsSetKeywords(void) const;
    /// Check whether it is safe or not to call GetKeywords method.
    bool CanGetKeywords(void) const;
    void ResetKeywords(void);
    const TKeywords& GetKeywords(void) const;
    TKeywords& SetKeywords(void);

    /// optional
    /// typedef list< CRef< CEMBL_xref > > TXref
    ///  Check whether the Xref data member has been assigned a value.
    bool IsSetXref(void) const;
    /// Check whether it is safe or not to call GetXref method.
    bool CanGetXref(void) const;
    void ResetXref(void);
    const TXref& GetXref(void) const;
    TXref& SetXref(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CEMBL_block_Base(const CEMBL_block_Base&);
    CEMBL_block_Base& operator=(const CEMBL_block_Base&);

    // data
    Uint4 m_set_State[1];
    EClass m_Class;
    EDiv m_Div;
    CRef< TCreation_date > m_Creation_date;
    CRef< TUpdate_date > m_Update_date;
    list< string > m_Extra_acc;
    list< string > m_Keywords;
    list< CRef< CEMBL_xref > > m_Xref;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CEMBL_block_Base::IsSetClass(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CEMBL_block_Base::CanGetClass(void) const
{
    return true;
}

inline
void CEMBL_block_Base::ResetClass(void)
{
    m_Class = eClass_standard;
    m_set_State[0] &= ~0x3;
}

inline
void CEMBL_block_Base::SetDefaultClass(void)
{
    ResetClass();
}

inline
CEMBL_block_Base::TClass CEMBL_block_Base::GetClass(void) const
{
    return m_Class;
}

inline
void CEMBL_block_Base::SetClass(CEMBL_block_Base::TClass value)
{
    m_Class = value;
    m_set_State[0] |= 0x3;
}

inline
CEMBL_block_Base::TClass& CEMBL_block_Base::SetClass(void)
{
#ifdef _DEBUG
    if (!IsSetClass()) {
        memset(&m_Class,UnassignedByte(),sizeof(m_Class));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Class;
}

inline
bool CEMBL_block_Base::IsSetDiv(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CEMBL_block_Base::CanGetDiv(void) const
{
    return IsSetDiv();
}

inline
void CEMBL_block_Base::ResetDiv(void)
{
    m_Div = (EDiv)(0);
    m_set_State[0] &= ~0xc;
}

inline
CEMBL_block_Base::TDiv CEMBL_block_Base::GetDiv(void) const
{
    if (!CanGetDiv()) {
        ThrowUnassigned(1);
    }
    return m_Div;
}

inline
void CEMBL_block_Base::SetDiv(CEMBL_block_Base::TDiv value)
{
    m_Div = value;
    m_set_State[0] |= 0xc;
}

inline
CEMBL_block_Base::TDiv& CEMBL_block_Base::SetDiv(void)
{
#ifdef _DEBUG
    if (!IsSetDiv()) {
        memset(&m_Div,UnassignedByte(),sizeof(m_Div));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Div;
}

inline
bool CEMBL_block_Base::IsSetCreation_date(void) const
{
    return m_Creation_date.NotEmpty();
}

inline
bool CEMBL_block_Base::CanGetCreation_date(void) const
{
    return true;
}

inline
const CEMBL_block_Base::TCreation_date& CEMBL_block_Base::GetCreation_date(void) const
{
    if ( !m_Creation_date ) {
        const_cast<CEMBL_block_Base*>(this)->ResetCreation_date();
    }
    return (*m_Creation_date);
}

inline
CEMBL_block_Base::TCreation_date& CEMBL_block_Base::SetCreation_date(void)
{
    if ( !m_Creation_date ) {
        ResetCreation_date();
    }
    return (*m_Creation_date);
}

inline
bool CEMBL_block_Base::IsSetUpdate_date(void) const
{
    return m_Update_date.NotEmpty();
}

inline
bool CEMBL_block_Base::CanGetUpdate_date(void) const
{
    return true;
}

inline
const CEMBL_block_Base::TUpdate_date& CEMBL_block_Base::GetUpdate_date(void) const
{
    if ( !m_Update_date ) {
        const_cast<CEMBL_block_Base*>(this)->ResetUpdate_date();
    }
    return (*m_Update_date);
}

inline
CEMBL_block_Base::TUpdate_date& CEMBL_block_Base::SetUpdate_date(void)
{
    if ( !m_Update_date ) {
        ResetUpdate_date();
    }
    return (*m_Update_date);
}

inline
bool CEMBL_block_Base::IsSetExtra_acc(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CEMBL_block_Base::CanGetExtra_acc(void) const
{
    return true;
}

inline
const CEMBL_block_Base::TExtra_acc& CEMBL_block_Base::GetExtra_acc(void) const
{
    return m_Extra_acc;
}

inline
CEMBL_block_Base::TExtra_acc& CEMBL_block_Base::SetExtra_acc(void)
{
    m_set_State[0] |= 0x100;
    return m_Extra_acc;
}

inline
bool CEMBL_block_Base::IsSetKeywords(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CEMBL_block_Base::CanGetKeywords(void) const
{
    return true;
}

inline
const CEMBL_block_Base::TKeywords& CEMBL_block_Base::GetKeywords(void) const
{
    return m_Keywords;
}

inline
CEMBL_block_Base::TKeywords& CEMBL_block_Base::SetKeywords(void)
{
    m_set_State[0] |= 0x400;
    return m_Keywords;
}

inline
bool CEMBL_block_Base::IsSetXref(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CEMBL_block_Base::CanGetXref(void) const
{
    return true;
}

inline
const CEMBL_block_Base::TXref& CEMBL_block_Base::GetXref(void) const
{
    return m_Xref;
}

inline
CEMBL_block_Base::TXref& CEMBL_block_Base::SetXref(void)
{
    m_set_State[0] |= 0x1000;
    return m_Xref;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQBLOCK_EMBL_BLOCK_BASE_HPP
