/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Annot_id_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seq.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQ_ANNOT_ID_BASE_HPP
#define OBJECTS_SEQ_ANNOT_ID_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDbtag;
class CObject_id;
class CTextannot_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQ_EXPORT CAnnot_id_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CAnnot_id_Base(void);
    // destructor
    virtual ~CAnnot_id_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,  ///< No variant selected
        e_Local,
        e_Ncbi,
        e_General,
        e_Other
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 5 ///< == e_Other+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef CObject_id TLocal;
    typedef NCBI_NS_NCBI::TEntrezId TNcbi;
    typedef CDbtag TGeneral;
    typedef CTextannot_id TOther;

    // getters
    // setters

    // typedef CObject_id TLocal
    bool IsLocal(void) const;
    const TLocal& GetLocal(void) const;
    TLocal& SetLocal(void);
    void SetLocal(TLocal& value);

    // typedef NCBI_NS_NCBI::TEntrezId TNcbi
    bool IsNcbi(void) const;
    TNcbi GetNcbi(void) const;
    TNcbi& SetNcbi(void);
    void SetNcbi(TNcbi value);

    // typedef CDbtag TGeneral
    bool IsGeneral(void) const;
    const TGeneral& GetGeneral(void) const;
    TGeneral& SetGeneral(void);
    void SetGeneral(TGeneral& value);

    // typedef CTextannot_id TOther
    bool IsOther(void) const;
    const TOther& GetOther(void) const;
    TOther& SetOther(void);
    void SetOther(TOther& value);


private:
    // copy constructor and assignment operator
    CAnnot_id_Base(const CAnnot_id_Base& );
    CAnnot_id_Base& operator=(const CAnnot_id_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        ncbi::TIntId m_Ncbi;
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CAnnot_id_Base::E_Choice CAnnot_id_Base::Which(void) const
{
    return m_choice;
}

inline
void CAnnot_id_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CAnnot_id_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CAnnot_id_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CAnnot_id_Base::IsLocal(void) const
{
    return m_choice == e_Local;
}

inline
bool CAnnot_id_Base::IsNcbi(void) const
{
    return m_choice == e_Ncbi;
}

inline
CAnnot_id_Base::TNcbi CAnnot_id_Base::GetNcbi(void) const
{
    CheckSelected(e_Ncbi);
    return reinterpret_cast<const TNcbi&>(m_Ncbi);
}

inline
CAnnot_id_Base::TNcbi& CAnnot_id_Base::SetNcbi(void)
{
    Select(e_Ncbi, NCBI_NS_NCBI::eDoNotResetVariant);
    return reinterpret_cast<TNcbi&>(m_Ncbi);
}

inline
void CAnnot_id_Base::SetNcbi(CAnnot_id_Base::TNcbi value)
{
    Select(e_Ncbi, NCBI_NS_NCBI::eDoNotResetVariant);
    reinterpret_cast<TNcbi&>(m_Ncbi) = value;
}

inline
bool CAnnot_id_Base::IsGeneral(void) const
{
    return m_choice == e_General;
}

inline
bool CAnnot_id_Base::IsOther(void) const
{
    return m_choice == e_Other;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQ_ANNOT_ID_BASE_HPP
