/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_UrnDataType_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcsubstance.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCSUBSTANCE_PC_URNDATATYPE_BASE_HPP
#define OBJECTS_PCSUBSTANCE_PC_URNDATATYPE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/// URN Data Type
///   Provides the ability to use more specific data types than that directly provided by ASN.1.
///   Provides for more specific validation of specified data.
enum EPC_UrnDataType {
    ePC_UrnDataType_string      =   1,  ///< Basic Data Types  String                             [maps to a VisibleString]
    ePC_UrnDataType_stringlist  =   2,  ///< List of Strings                    [maps to VisibleString list]
    ePC_UrnDataType_int         =   3,  ///< 32-Bit Signed Integer              [maps to an INTEGER]
    ePC_UrnDataType_intvec      =   4,  ///< Vector of 32-Bit Signed Integer    [maps to INTEGER vector]
    ePC_UrnDataType_uint        =   5,  ///< 32-Bit Unsigned Integer            [maps to an INTEGER]
    ePC_UrnDataType_uintvec     =   6,  ///< Vector of 32-Bit Unsigned Integer  [maps to INTEGER vector]
    ePC_UrnDataType_double      =   7,  ///< 64-Bit Float                       [maps to a REAL]
    ePC_UrnDataType_doublevec   =   8,  ///< Vector of Double                   [maps to REAL vector]
    ePC_UrnDataType_bool        =   9,  ///< Boolean or Binary value            [maps to a BOOLEAN]
    ePC_UrnDataType_boolvec     =  10,  ///< Boolean Vector                     [maps to BOOLEAN vector]
    ePC_UrnDataType_uint64      =  11,  ///< Specialized Data Types  64-Bit Unsigned Integer (Hex form) [maps to a VisibleString]
    ePC_UrnDataType_binary      =  12,  ///< Binary Data Blob                   [maps to an OCTET STRING]
    ePC_UrnDataType_url         =  13,  ///< URL                                [maps to a VisibleString]
    ePC_UrnDataType_unicode     =  14,  ///< UniCode String                     [maps to a VisibleString]
    ePC_UrnDataType_date        =  15,  ///< ISO8601 Date                       [maps to a Date]
    ePC_UrnDataType_fingerprint =  16,  ///< Binary Fingerprint (Gzip'ped bit   [maps to an OCTET STRING]    list w/ 4-Byte prefix denoting bit list length)
    ePC_UrnDataType_unknown     = 255  ///< Unknown Data Type               [maps to a set of VisibleString]
};

/// Access to EPC_UrnDataType's attributes (values, names) as defined in spec
NCBI_PCSUBSTANCE_EXPORT const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EPC_UrnDataType)(void);


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCSUBSTANCE_PC_URNDATATYPE_BASE_HPP
