/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_Source_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcsubstance.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCSUBSTANCE_PC_SOURCE_BASE_HPP
#define OBJECTS_PCSUBSTANCE_PC_SOURCE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CPC_DBTracking;
class CPC_MMDBSource;
class CPub;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Describes Substance Source, if from another database
class NCBI_PCSUBSTANCE_EXPORT CPC_Source_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPC_Source_Base(void);
    // destructor
    virtual ~CPC_Source_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,  ///< No variant selected
        e_Individual,   ///< Individual Submission
        e_Db,           ///< External DB Submission
        e_Mmdb          ///< MMDB Submission (deprecated)
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 4 ///< == e_Mmdb+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef CPub TIndividual;
    typedef CPC_DBTracking TDb;
    typedef CPC_MMDBSource TMmdb;

    // getters
    // setters

    // typedef CPub TIndividual
    bool IsIndividual(void) const;
    const TIndividual& GetIndividual(void) const;
    TIndividual& SetIndividual(void);
    void SetIndividual(TIndividual& value);

    // typedef CPC_DBTracking TDb
    bool IsDb(void) const;
    const TDb& GetDb(void) const;
    TDb& SetDb(void);
    void SetDb(TDb& value);

    // typedef CPC_MMDBSource TMmdb
    bool IsMmdb(void) const;
    const TMmdb& GetMmdb(void) const;
    TMmdb& SetMmdb(void);
    void SetMmdb(TMmdb& value);


private:
    // copy constructor and assignment operator
    CPC_Source_Base(const CPC_Source_Base& );
    CPC_Source_Base& operator=(const CPC_Source_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    NCBI_NS_NCBI::CSerialObject *m_object;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CPC_Source_Base::E_Choice CPC_Source_Base::Which(void) const
{
    return m_choice;
}

inline
void CPC_Source_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CPC_Source_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CPC_Source_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CPC_Source_Base::IsIndividual(void) const
{
    return m_choice == e_Individual;
}

inline
bool CPC_Source_Base::IsDb(void) const
{
    return m_choice == e_Db;
}

inline
bool CPC_Source_Base::IsMmdb(void) const
{
    return m_choice == e_Mmdb;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCSUBSTANCE_PC_SOURCE_BASE_HPP
