/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_Conformer_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcsubstance.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCSUBSTANCE_PC_CONFORMER_BASE_HPP
#define OBJECTS_PCSUBSTANCE_PC_CONFORMER_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <vector>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CPC_DrawAnnotations;
class CPC_InfoData;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Drawing/Conformer Definition (in Parallel Arrays, synchronized to aid integer list)
///   3D coordinates are specified in a right-handed coordinate system. For 2D plots, Y axis leads upwards.
class NCBI_PCSUBSTANCE_EXPORT CPC_Conformer_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPC_Conformer_Base(void);
    // destructor
    virtual ~CPC_Conformer_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef vector< double > TX;
    typedef vector< double > TY;
    typedef vector< double > TZ;
    typedef CPC_DrawAnnotations TStyle;
    typedef list< CRef< CPC_InfoData > > TData;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_x,
        e_y,
        e_z,
        e_style,
        e_data
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    ///  [Note: Parallel Arrays must be kept Synchronized]
    /// X Coordinates (vector)
    /// mandatory
    /// typedef vector< double > TX
    ///  Check whether the X data member has been assigned a value.
    bool IsSetX(void) const;
    /// Check whether it is safe or not to call GetX method.
    bool CanGetX(void) const;
    void ResetX(void);
    const TX& GetX(void) const;
    TX& SetX(void);

    /// Y Coordinates (vector)
    /// mandatory
    /// typedef vector< double > TY
    ///  Check whether the Y data member has been assigned a value.
    bool IsSetY(void) const;
    /// Check whether it is safe or not to call GetY method.
    bool CanGetY(void) const;
    void ResetY(void);
    const TY& GetY(void) const;
    TY& SetY(void);

    /// Z Coordinates (vector)
    /// optional
    /// typedef vector< double > TZ
    ///  Check whether the Z data member has been assigned a value.
    bool IsSetZ(void) const;
    /// Check whether it is safe or not to call GetZ method.
    bool CanGetZ(void) const;
    void ResetZ(void);
    const TZ& GetZ(void) const;
    TZ& SetZ(void);

    /// Structure Annotations
    /// optional
    /// typedef CPC_DrawAnnotations TStyle
    ///  Check whether the Style data member has been assigned a value.
    bool IsSetStyle(void) const;
    /// Check whether it is safe or not to call GetStyle method.
    bool CanGetStyle(void) const;
    void ResetStyle(void);
    const TStyle& GetStyle(void) const;
    void SetStyle(TStyle& value);
    TStyle& SetStyle(void);

    /// Data Associated with this Conformer
    /// optional
    /// typedef list< CRef< CPC_InfoData > > TData
    ///  Check whether the Data data member has been assigned a value.
    bool IsSetData(void) const;
    /// Check whether it is safe or not to call GetData method.
    bool CanGetData(void) const;
    void ResetData(void);
    const TData& GetData(void) const;
    TData& SetData(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPC_Conformer_Base(const CPC_Conformer_Base&);
    CPC_Conformer_Base& operator=(const CPC_Conformer_Base&);

    // data
    Uint4 m_set_State[1];
    vector< double > m_X;
    vector< double > m_Y;
    vector< double > m_Z;
    CRef< TStyle > m_Style;
    list< CRef< CPC_InfoData > > m_Data;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPC_Conformer_Base::IsSetX(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPC_Conformer_Base::CanGetX(void) const
{
    return true;
}

inline
const CPC_Conformer_Base::TX& CPC_Conformer_Base::GetX(void) const
{
    return m_X;
}

inline
CPC_Conformer_Base::TX& CPC_Conformer_Base::SetX(void)
{
    m_set_State[0] |= 0x1;
    return m_X;
}

inline
bool CPC_Conformer_Base::IsSetY(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPC_Conformer_Base::CanGetY(void) const
{
    return true;
}

inline
const CPC_Conformer_Base::TY& CPC_Conformer_Base::GetY(void) const
{
    return m_Y;
}

inline
CPC_Conformer_Base::TY& CPC_Conformer_Base::SetY(void)
{
    m_set_State[0] |= 0x4;
    return m_Y;
}

inline
bool CPC_Conformer_Base::IsSetZ(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CPC_Conformer_Base::CanGetZ(void) const
{
    return true;
}

inline
const CPC_Conformer_Base::TZ& CPC_Conformer_Base::GetZ(void) const
{
    return m_Z;
}

inline
CPC_Conformer_Base::TZ& CPC_Conformer_Base::SetZ(void)
{
    m_set_State[0] |= 0x10;
    return m_Z;
}

inline
bool CPC_Conformer_Base::IsSetStyle(void) const
{
    return m_Style.NotEmpty();
}

inline
bool CPC_Conformer_Base::CanGetStyle(void) const
{
    return IsSetStyle();
}

inline
const CPC_Conformer_Base::TStyle& CPC_Conformer_Base::GetStyle(void) const
{
    if (!CanGetStyle()) {
        ThrowUnassigned(3);
    }
    return (*m_Style);
}

inline
bool CPC_Conformer_Base::IsSetData(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CPC_Conformer_Base::CanGetData(void) const
{
    return true;
}

inline
const CPC_Conformer_Base::TData& CPC_Conformer_Base::GetData(void) const
{
    return m_Data;
}

inline
CPC_Conformer_Base::TData& CPC_Conformer_Base::SetData(void)
{
    m_set_State[0] |= 0x100;
    return m_Data;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCSUBSTANCE_PC_CONFORMER_BASE_HPP
