/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_AssayDescription_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcassay2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCASSAY2_PC_ASSAYDESCRIPTION_BASE_HPP
#define OBJECTS_PCASSAY2_PC_ASSAYDESCRIPTION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <vector>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CPC_ID;
class CPC_Source;
#ifndef BEGIN_pcassay2_SCOPE
#  define BEGIN_pcassay2_SCOPE BEGIN_SCOPE(pcassay2)
#  define END_pcassay2_SCOPE END_SCOPE(pcassay2)
#endif
BEGIN_pcassay2_SCOPE // namespace ncbi::objects::pcassay2::

class CPC_AnnotatedXRef;
class CPC_AssayDRAttr;
class CPC_AssayTargetInfo;
class CPC_CategorizedComment;
class CPC_ResultType;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Assay Description provided by an Organization that describes the assay/protocol performed and defines the
///   measured end-points and parameters to be stored.  An Assay Description is not a database table.  You can
///   define as many Result Definitions as needed and they need not be used by all Substances tested.
/// Assay Descriptions can be modified on both description text and Result Definitions after initial submission
/// as desired, and such udpates will be tracked in PubChem
class CPC_AssayDescription_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPC_AssayDescription_Base(void);
    // destructor
    virtual ~CPC_AssayDescription_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /// Assay Outcome Qualifier
    enum EActivity_outcome_method {
        eActivity_outcome_method_other        = 0,  ///<   All Other Type
        eActivity_outcome_method_screening    = 1,  ///<   Primary Screen Assay
        eActivity_outcome_method_confirmatory = 2,  ///<   Confirmatory Assay
        eActivity_outcome_method_summary      = 3  ///<   Probe Summary Assay
    };
    
    /// Access to EActivity_outcome_method's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EActivity_outcome_method)(void);
    
    enum ESubstance_type {
        eSubstance_type_small_molecule =   1,
        eSubstance_type_nucleotide     =   2,
        eSubstance_type_other          = 255
    };
    
    /// Access to ESubstance_type's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(ESubstance_type)(void);
    
    /// to distinguish projects funded through MLSCN, MLPCN or other
    enum EProject_category {
        eProject_category_mlscn                =   1,  ///< assay depositions from MLSCN screen center
        eProject_category_mlpcn                =   2,  ///< assay depositions from MLPCN screen center
        eProject_category_mlscn_ap             =   3,  ///< assay depositions from MLSCN assay provider
        eProject_category_mlpcn_ap             =   4,  ///< assay depositions from MLPCN assay provider
        eProject_category_journal_article      =   5,  ///< to be deprecated and replaced by option 7, 8 & 9
        eProject_category_assay_vendor         =   6,  ///< assay depositions from assay vendors
        eProject_category_literature_extracted =   7,  ///< data from literature, extracted by curators
        eProject_category_literature_author    =   8,  ///< data from literature, submitted by author of articles
        eProject_category_literature_publisher =   9,  ///< data from literature, submitted by journals/publishers
        eProject_category_rnaigi               =  10,  ///< RNAi screenings from RNAi Global Initiative
        eProject_category_other                = 255
    };
    
    /// Access to EProject_category's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EProject_category)(void);
    
    // types
    typedef objects::CPC_ID TAid;
    typedef objects::CPC_Source TAid_source;
    typedef CStringUTF8 TName;
    typedef list< CStringUTF8 > TDescription;
    typedef list< CStringUTF8 > TProtocol;
    typedef list< CStringUTF8 > TComment;
    typedef list< CRef< CPC_AnnotatedXRef > > TXref;
    typedef vector< CRef< CPC_ResultType > > TResults;
    typedef int TRevision;
    typedef list< CRef< CPC_AssayTargetInfo > > TTarget;
    typedef int TActivity_outcome_method;
    typedef list< CRef< CPC_AssayDRAttr > > TDr;
    typedef int TSubstance_type;
    typedef list< string > TGrant_number;
    typedef int TProject_category;
    typedef list< string > TAssay_group;
    typedef list< CRef< CPC_CategorizedComment > > TCategorized_comment;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_aid,
        e_aid_source,
        e_name,
        e_description,
        e_protocol,
        e_comment,
        e_xref,
        e_results,
        e_revision,
        e_target,
        e_activity_outcome_method,
        e_dr,
        e_substance_type,
        e_grant_number,
        e_project_category,
        e_assay_group,
        e_categorized_comment
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 18> TmemberIndex;

    // getters
    // setters

    /// Internal/External Tracking Information
    /// Assay Description ID/Version  [Either valid ID
    ///   or, if "aid-source" is used, a "0" dummy value]
    ///   Note: Version is for internal use (only?)
    ///   Note: A valid ID is greater than "0"
    /// mandatory
    /// typedef objects::CPC_ID TAid
    ///  Check whether the Aid data member has been assigned a value.
    bool IsSetAid(void) const;
    /// Check whether it is safe or not to call GetAid method.
    bool CanGetAid(void) const;
    void ResetAid(void);
    const TAid& GetAid(void) const;
    void SetAid(TAid& value);
    TAid& SetAid(void);

    /// External Identifier for this Assay Description
    ///   Note: May be used in-lieu of "aid"
    ///   Note: This is non-optional if "aid" ID is "0"
    /// optional
    /// typedef objects::CPC_Source TAid_source
    ///  Check whether the Aid_source data member has been assigned a value.
    bool IsSetAid_source(void) const;
    /// Check whether it is safe or not to call GetAid_source method.
    bool CanGetAid_source(void) const;
    void ResetAid_source(void);
    const TAid_source& GetAid_source(void) const;
    void SetAid_source(TAid_source& value);
    TAid_source& SetAid_source(void);

    /// Assay Description Information
    /// Short Assay Name (for display purposes)
    /// mandatory
    /// typedef CStringUTF8 TName
    ///  Check whether the Name data member has been assigned a value.
    bool IsSetName(void) const;
    /// Check whether it is safe or not to call GetName method.
    bool CanGetName(void) const;
    void ResetName(void);
    const TName& GetName(void) const;
    void SetName(const TName& value);
    void SetName(TName&& value);
    TName& SetName(void);

    /// Description of Assay
    /// optional
    /// typedef list< CStringUTF8 > TDescription
    ///  Check whether the Description data member has been assigned a value.
    bool IsSetDescription(void) const;
    /// Check whether it is safe or not to call GetDescription method.
    bool CanGetDescription(void) const;
    void ResetDescription(void);
    const TDescription& GetDescription(void) const;
    TDescription& SetDescription(void);

    /// Procedure used to generate results
    /// optional
    /// typedef list< CStringUTF8 > TProtocol
    ///  Check whether the Protocol data member has been assigned a value.
    bool IsSetProtocol(void) const;
    /// Check whether it is safe or not to call GetProtocol method.
    bool CanGetProtocol(void) const;
    void ResetProtocol(void);
    const TProtocol& GetProtocol(void) const;
    TProtocol& SetProtocol(void);

    /// Comments or additional information
    /// optional
    /// typedef list< CStringUTF8 > TComment
    ///  Check whether the Comment data member has been assigned a value.
    bool IsSetComment(void) const;
    /// Check whether it is safe or not to call GetComment method.
    bool CanGetComment(void) const;
    void ResetComment(void);
    const TComment& GetComment(void) const;
    TComment& SetComment(void);

    /// Annotated Cross-Reference Information
    /// optional
    /// typedef list< CRef< CPC_AnnotatedXRef > > TXref
    ///  Check whether the Xref data member has been assigned a value.
    bool IsSetXref(void) const;
    /// Check whether it is safe or not to call GetXref method.
    bool CanGetXref(void) const;
    void ResetXref(void);
    const TXref& GetXref(void) const;
    TXref& SetXref(void);

    /// Allowed Assay Result Types
    /// Result Definitions (vector)
    /// optional
    /// typedef vector< CRef< CPC_ResultType > > TResults
    ///  Check whether the Results data member has been assigned a value.
    bool IsSetResults(void) const;
    /// Check whether it is safe or not to call GetResults method.
    bool CanGetResults(void) const;
    void ResetResults(void);
    const TResults& GetResults(void) const;
    TResults& SetResults(void);

    /// Additional Information
    /// pub               SEQUENCE OF Pub                 OPTIONAL, Depositor provided publications for this assay (never used)
    /// Revision identifier for textual description
    /// optional
    /// typedef int TRevision
    ///  Check whether the Revision data member has been assigned a value.
    bool IsSetRevision(void) const;
    /// Check whether it is safe or not to call GetRevision method.
    bool CanGetRevision(void) const;
    void ResetRevision(void);
    TRevision GetRevision(void) const;
    void SetRevision(TRevision value);
    TRevision& SetRevision(void);

    /// Target information
    /// optional
    /// typedef list< CRef< CPC_AssayTargetInfo > > TTarget
    ///  Check whether the Target data member has been assigned a value.
    bool IsSetTarget(void) const;
    /// Check whether it is safe or not to call GetTarget method.
    bool CanGetTarget(void) const;
    void ResetTarget(void);
    const TTarget& GetTarget(void) const;
    TTarget& SetTarget(void);

    /// optional
    /// typedef int TActivity_outcome_method
    ///  Check whether the Activity_outcome_method data member has been assigned a value.
    bool IsSetActivity_outcome_method(void) const;
    /// Check whether it is safe or not to call GetActivity_outcome_method method.
    bool CanGetActivity_outcome_method(void) const;
    void ResetActivity_outcome_method(void);
    TActivity_outcome_method GetActivity_outcome_method(void) const;
    void SetActivity_outcome_method(TActivity_outcome_method value);
    TActivity_outcome_method& SetActivity_outcome_method(void);

    /// Dose-Response Attribution
    /// optional
    /// typedef list< CRef< CPC_AssayDRAttr > > TDr
    ///  Check whether the Dr data member has been assigned a value.
    bool IsSetDr(void) const;
    /// Check whether it is safe or not to call GetDr method.
    bool CanGetDr(void) const;
    void ResetDr(void);
    const TDr& GetDr(void) const;
    TDr& SetDr(void);

    /// to distinguish the type of substance used in the screening
    /// optional
    /// typedef int TSubstance_type
    ///  Check whether the Substance_type data member has been assigned a value.
    bool IsSetSubstance_type(void) const;
    /// Check whether it is safe or not to call GetSubstance_type method.
    bool CanGetSubstance_type(void) const;
    void ResetSubstance_type(void);
    TSubstance_type GetSubstance_type(void) const;
    void SetSubstance_type(TSubstance_type value);
    TSubstance_type& SetSubstance_type(void);

    /// Grant and project category information
    /// grant proposal number
    /// required for 'MLSCN' & 'MLPCN' projects
    /// optional
    /// typedef list< string > TGrant_number
    ///  Check whether the Grant_number data member has been assigned a value.
    bool IsSetGrant_number(void) const;
    /// Check whether it is safe or not to call GetGrant_number method.
    bool CanGetGrant_number(void) const;
    void ResetGrant_number(void);
    const TGrant_number& GetGrant_number(void) const;
    TGrant_number& SetGrant_number(void);

    /// optional
    /// typedef int TProject_category
    ///  Check whether the Project_category data member has been assigned a value.
    bool IsSetProject_category(void) const;
    /// Check whether it is safe or not to call GetProject_category method.
    bool CanGetProject_category(void) const;
    void ResetProject_category(void);
    TProject_category GetProject_category(void) const;
    void SetProject_category(TProject_category value);
    TProject_category& SetProject_category(void);

    /// annotation for assay gruop information, e.g. this
    /// assay belongs to a group of assay associated by
    /// a unique name, e.g. the value assigned to 'assay-group',
    /// assays belonging to this group can be
    /// retrieved using this unique name
    /// it is depositor's responsibility to make the name
    /// distinct if necessary
    /// this can be used as the mechanism to specify 'related bioassays'
    /// before hand so it is not necessary to update the descriptions of
    /// related assays when new group member submitted to PubChem
    /// optional
    /// typedef list< string > TAssay_group
    ///  Check whether the Assay_group data member has been assigned a value.
    bool IsSetAssay_group(void) const;
    /// Check whether it is safe or not to call GetAssay_group method.
    bool CanGetAssay_group(void) const;
    void ResetAssay_group(void);
    const TAssay_group& GetAssay_group(void) const;
    TAssay_group& SetAssay_group(void);

    /// is-mlp-late-stage       BOOLEAN OPTIONAL,                   verification for 'late-stage-data' deposition (never used)
    /// to report categorized description/comment by associating with a category title
    /// optional
    /// typedef list< CRef< CPC_CategorizedComment > > TCategorized_comment
    ///  Check whether the Categorized_comment data member has been assigned a value.
    bool IsSetCategorized_comment(void) const;
    /// Check whether it is safe or not to call GetCategorized_comment method.
    bool CanGetCategorized_comment(void) const;
    void ResetCategorized_comment(void);
    const TCategorized_comment& GetCategorized_comment(void) const;
    TCategorized_comment& SetCategorized_comment(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPC_AssayDescription_Base(const CPC_AssayDescription_Base&);
    CPC_AssayDescription_Base& operator=(const CPC_AssayDescription_Base&);

    // data
    Uint4 m_set_State[2];
    CRef< TAid > m_Aid;
    CRef< TAid_source > m_Aid_source;
    CStringUTF8 m_Name;
    list< CStringUTF8 > m_Description;
    list< CStringUTF8 > m_Protocol;
    list< CStringUTF8 > m_Comment;
    list< CRef< CPC_AnnotatedXRef > > m_Xref;
    vector< CRef< CPC_ResultType > > m_Results;
    int m_Revision;
    list< CRef< CPC_AssayTargetInfo > > m_Target;
    int m_Activity_outcome_method;
    list< CRef< CPC_AssayDRAttr > > m_Dr;
    int m_Substance_type;
    list< string > m_Grant_number;
    int m_Project_category;
    list< string > m_Assay_group;
    list< CRef< CPC_CategorizedComment > > m_Categorized_comment;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPC_AssayDescription_Base::IsSetAid(void) const
{
    return m_Aid.NotEmpty();
}

inline
bool CPC_AssayDescription_Base::CanGetAid(void) const
{
    return true;
}

inline
const CPC_AssayDescription_Base::TAid& CPC_AssayDescription_Base::GetAid(void) const
{
    if ( !m_Aid ) {
        const_cast<CPC_AssayDescription_Base*>(this)->ResetAid();
    }
    return (*m_Aid);
}

inline
CPC_AssayDescription_Base::TAid& CPC_AssayDescription_Base::SetAid(void)
{
    if ( !m_Aid ) {
        ResetAid();
    }
    return (*m_Aid);
}

inline
bool CPC_AssayDescription_Base::IsSetAid_source(void) const
{
    return m_Aid_source.NotEmpty();
}

inline
bool CPC_AssayDescription_Base::CanGetAid_source(void) const
{
    return IsSetAid_source();
}

inline
const CPC_AssayDescription_Base::TAid_source& CPC_AssayDescription_Base::GetAid_source(void) const
{
    if (!CanGetAid_source()) {
        ThrowUnassigned(1);
    }
    return (*m_Aid_source);
}

inline
bool CPC_AssayDescription_Base::IsSetName(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CPC_AssayDescription_Base::CanGetName(void) const
{
    return IsSetName();
}

inline
const CPC_AssayDescription_Base::TName& CPC_AssayDescription_Base::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(2);
    }
    return m_Name;
}

inline
void CPC_AssayDescription_Base::SetName(const CPC_AssayDescription_Base::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0x30;
}

inline
void CPC_AssayDescription_Base::SetName(CPC_AssayDescription_Base::TName&& value)
{
    m_Name = std::forward<CPC_AssayDescription_Base::TName>(value);
    m_set_State[0] |= 0x30;
}

inline
CPC_AssayDescription_Base::TName& CPC_AssayDescription_Base::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedStringUTF8();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Name;
}

inline
bool CPC_AssayDescription_Base::IsSetDescription(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CPC_AssayDescription_Base::CanGetDescription(void) const
{
    return true;
}

inline
const CPC_AssayDescription_Base::TDescription& CPC_AssayDescription_Base::GetDescription(void) const
{
    return m_Description;
}

inline
CPC_AssayDescription_Base::TDescription& CPC_AssayDescription_Base::SetDescription(void)
{
    m_set_State[0] |= 0x40;
    return m_Description;
}

inline
bool CPC_AssayDescription_Base::IsSetProtocol(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CPC_AssayDescription_Base::CanGetProtocol(void) const
{
    return true;
}

inline
const CPC_AssayDescription_Base::TProtocol& CPC_AssayDescription_Base::GetProtocol(void) const
{
    return m_Protocol;
}

inline
CPC_AssayDescription_Base::TProtocol& CPC_AssayDescription_Base::SetProtocol(void)
{
    m_set_State[0] |= 0x100;
    return m_Protocol;
}

inline
bool CPC_AssayDescription_Base::IsSetComment(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CPC_AssayDescription_Base::CanGetComment(void) const
{
    return true;
}

inline
const CPC_AssayDescription_Base::TComment& CPC_AssayDescription_Base::GetComment(void) const
{
    return m_Comment;
}

inline
CPC_AssayDescription_Base::TComment& CPC_AssayDescription_Base::SetComment(void)
{
    m_set_State[0] |= 0x400;
    return m_Comment;
}

inline
bool CPC_AssayDescription_Base::IsSetXref(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CPC_AssayDescription_Base::CanGetXref(void) const
{
    return true;
}

inline
const CPC_AssayDescription_Base::TXref& CPC_AssayDescription_Base::GetXref(void) const
{
    return m_Xref;
}

inline
CPC_AssayDescription_Base::TXref& CPC_AssayDescription_Base::SetXref(void)
{
    m_set_State[0] |= 0x1000;
    return m_Xref;
}

inline
bool CPC_AssayDescription_Base::IsSetResults(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CPC_AssayDescription_Base::CanGetResults(void) const
{
    return true;
}

inline
const CPC_AssayDescription_Base::TResults& CPC_AssayDescription_Base::GetResults(void) const
{
    return m_Results;
}

inline
CPC_AssayDescription_Base::TResults& CPC_AssayDescription_Base::SetResults(void)
{
    m_set_State[0] |= 0x4000;
    return m_Results;
}

inline
bool CPC_AssayDescription_Base::IsSetRevision(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CPC_AssayDescription_Base::CanGetRevision(void) const
{
    return IsSetRevision();
}

inline
void CPC_AssayDescription_Base::ResetRevision(void)
{
    m_Revision = 0;
    m_set_State[0] &= ~0x30000;
}

inline
CPC_AssayDescription_Base::TRevision CPC_AssayDescription_Base::GetRevision(void) const
{
    if (!CanGetRevision()) {
        ThrowUnassigned(8);
    }
    return m_Revision;
}

inline
void CPC_AssayDescription_Base::SetRevision(CPC_AssayDescription_Base::TRevision value)
{
    m_Revision = value;
    m_set_State[0] |= 0x30000;
}

inline
CPC_AssayDescription_Base::TRevision& CPC_AssayDescription_Base::SetRevision(void)
{
#ifdef _DEBUG
    if (!IsSetRevision()) {
        memset(&m_Revision,UnassignedByte(),sizeof(m_Revision));
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Revision;
}

inline
bool CPC_AssayDescription_Base::IsSetTarget(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CPC_AssayDescription_Base::CanGetTarget(void) const
{
    return true;
}

inline
const CPC_AssayDescription_Base::TTarget& CPC_AssayDescription_Base::GetTarget(void) const
{
    return m_Target;
}

inline
CPC_AssayDescription_Base::TTarget& CPC_AssayDescription_Base::SetTarget(void)
{
    m_set_State[0] |= 0x40000;
    return m_Target;
}

inline
bool CPC_AssayDescription_Base::IsSetActivity_outcome_method(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CPC_AssayDescription_Base::CanGetActivity_outcome_method(void) const
{
    return IsSetActivity_outcome_method();
}

inline
void CPC_AssayDescription_Base::ResetActivity_outcome_method(void)
{
    m_Activity_outcome_method = (EActivity_outcome_method)(0);
    m_set_State[0] &= ~0x300000;
}

inline
CPC_AssayDescription_Base::TActivity_outcome_method CPC_AssayDescription_Base::GetActivity_outcome_method(void) const
{
    if (!CanGetActivity_outcome_method()) {
        ThrowUnassigned(10);
    }
    return m_Activity_outcome_method;
}

inline
void CPC_AssayDescription_Base::SetActivity_outcome_method(CPC_AssayDescription_Base::TActivity_outcome_method value)
{
    m_Activity_outcome_method = value;
    m_set_State[0] |= 0x300000;
}

inline
CPC_AssayDescription_Base::TActivity_outcome_method& CPC_AssayDescription_Base::SetActivity_outcome_method(void)
{
#ifdef _DEBUG
    if (!IsSetActivity_outcome_method()) {
        memset(&m_Activity_outcome_method,UnassignedByte(),sizeof(m_Activity_outcome_method));
    }
#endif
    m_set_State[0] |= 0x100000;
    return m_Activity_outcome_method;
}

inline
bool CPC_AssayDescription_Base::IsSetDr(void) const
{
    return ((m_set_State[0] & 0xc00000) != 0);
}

inline
bool CPC_AssayDescription_Base::CanGetDr(void) const
{
    return true;
}

inline
const CPC_AssayDescription_Base::TDr& CPC_AssayDescription_Base::GetDr(void) const
{
    return m_Dr;
}

inline
CPC_AssayDescription_Base::TDr& CPC_AssayDescription_Base::SetDr(void)
{
    m_set_State[0] |= 0x400000;
    return m_Dr;
}

inline
bool CPC_AssayDescription_Base::IsSetSubstance_type(void) const
{
    return ((m_set_State[0] & 0x3000000) != 0);
}

inline
bool CPC_AssayDescription_Base::CanGetSubstance_type(void) const
{
    return IsSetSubstance_type();
}

inline
void CPC_AssayDescription_Base::ResetSubstance_type(void)
{
    m_Substance_type = (ESubstance_type)(0);
    m_set_State[0] &= ~0x3000000;
}

inline
CPC_AssayDescription_Base::TSubstance_type CPC_AssayDescription_Base::GetSubstance_type(void) const
{
    if (!CanGetSubstance_type()) {
        ThrowUnassigned(12);
    }
    return m_Substance_type;
}

inline
void CPC_AssayDescription_Base::SetSubstance_type(CPC_AssayDescription_Base::TSubstance_type value)
{
    m_Substance_type = value;
    m_set_State[0] |= 0x3000000;
}

inline
CPC_AssayDescription_Base::TSubstance_type& CPC_AssayDescription_Base::SetSubstance_type(void)
{
#ifdef _DEBUG
    if (!IsSetSubstance_type()) {
        memset(&m_Substance_type,UnassignedByte(),sizeof(m_Substance_type));
    }
#endif
    m_set_State[0] |= 0x1000000;
    return m_Substance_type;
}

inline
bool CPC_AssayDescription_Base::IsSetGrant_number(void) const
{
    return ((m_set_State[0] & 0xc000000) != 0);
}

inline
bool CPC_AssayDescription_Base::CanGetGrant_number(void) const
{
    return true;
}

inline
const CPC_AssayDescription_Base::TGrant_number& CPC_AssayDescription_Base::GetGrant_number(void) const
{
    return m_Grant_number;
}

inline
CPC_AssayDescription_Base::TGrant_number& CPC_AssayDescription_Base::SetGrant_number(void)
{
    m_set_State[0] |= 0x4000000;
    return m_Grant_number;
}

inline
bool CPC_AssayDescription_Base::IsSetProject_category(void) const
{
    return ((m_set_State[0] & 0x30000000) != 0);
}

inline
bool CPC_AssayDescription_Base::CanGetProject_category(void) const
{
    return IsSetProject_category();
}

inline
void CPC_AssayDescription_Base::ResetProject_category(void)
{
    m_Project_category = (EProject_category)(0);
    m_set_State[0] &= ~0x30000000;
}

inline
CPC_AssayDescription_Base::TProject_category CPC_AssayDescription_Base::GetProject_category(void) const
{
    if (!CanGetProject_category()) {
        ThrowUnassigned(14);
    }
    return m_Project_category;
}

inline
void CPC_AssayDescription_Base::SetProject_category(CPC_AssayDescription_Base::TProject_category value)
{
    m_Project_category = value;
    m_set_State[0] |= 0x30000000;
}

inline
CPC_AssayDescription_Base::TProject_category& CPC_AssayDescription_Base::SetProject_category(void)
{
#ifdef _DEBUG
    if (!IsSetProject_category()) {
        memset(&m_Project_category,UnassignedByte(),sizeof(m_Project_category));
    }
#endif
    m_set_State[0] |= 0x10000000;
    return m_Project_category;
}

inline
bool CPC_AssayDescription_Base::IsSetAssay_group(void) const
{
    return ((m_set_State[0] & 0xc0000000) != 0);
}

inline
bool CPC_AssayDescription_Base::CanGetAssay_group(void) const
{
    return true;
}

inline
const CPC_AssayDescription_Base::TAssay_group& CPC_AssayDescription_Base::GetAssay_group(void) const
{
    return m_Assay_group;
}

inline
CPC_AssayDescription_Base::TAssay_group& CPC_AssayDescription_Base::SetAssay_group(void)
{
    m_set_State[0] |= 0x40000000;
    return m_Assay_group;
}

inline
bool CPC_AssayDescription_Base::IsSetCategorized_comment(void) const
{
    return ((m_set_State[1] & 0x3) != 0);
}

inline
bool CPC_AssayDescription_Base::CanGetCategorized_comment(void) const
{
    return true;
}

inline
const CPC_AssayDescription_Base::TCategorized_comment& CPC_AssayDescription_Base::GetCategorized_comment(void) const
{
    return m_Categorized_comment;
}

inline
CPC_AssayDescription_Base::TCategorized_comment& CPC_AssayDescription_Base::SetCategorized_comment(void)
{
    m_set_State[1] |= 0x1;
    return m_Categorized_comment;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_pcassay2_SCOPE // namespace ncbi::objects::pcassay2::

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCASSAY2_PC_ASSAYDESCRIPTION_BASE_HPP
