/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file MSLibrarySettings_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'omssa.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_OMSSA_MSLIBRARYSETTINGS_BASE_HPP
#define OBJECTS_OMSSA_MSLIBRARYSETTINGS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Library search settings
class NCBI_OMSSA_EXPORT CMSLibrarySettings_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMSLibrarySettings_Base(void);
    // destructor
    virtual ~CMSLibrarySettings_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef list< string > TLibnames;
    typedef bool TPresearch;
    typedef bool TUseomssascore;
    typedef bool TUsereplicatescore;
    typedef bool TQtofscore;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_libnames,
        e_presearch,
        e_useomssascore,
        e_usereplicatescore,
        e_qtofscore
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// names of search libraries
    /// mandatory
    /// typedef list< string > TLibnames
    ///  Check whether the Libnames data member has been assigned a value.
    bool IsSetLibnames(void) const;
    /// Check whether it is safe or not to call GetLibnames method.
    bool CanGetLibnames(void) const;
    void ResetLibnames(void);
    const TLibnames& GetLibnames(void) const;
    TLibnames& SetLibnames(void);

    /// should there be a restriction on precursor mass?
    /// mandatory
    /// typedef bool TPresearch
    ///  Check whether the Presearch data member has been assigned a value.
    bool IsSetPresearch(void) const;
    /// Check whether it is safe or not to call GetPresearch method.
    bool CanGetPresearch(void) const;
    void ResetPresearch(void);
    TPresearch GetPresearch(void) const;
    void SetPresearch(TPresearch value);
    TPresearch& SetPresearch(void);

    /// use the omssa score?
    /// mandatory
    /// typedef bool TUseomssascore
    ///  Check whether the Useomssascore data member has been assigned a value.
    bool IsSetUseomssascore(void) const;
    /// Check whether it is safe or not to call GetUseomssascore method.
    bool CanGetUseomssascore(void) const;
    void ResetUseomssascore(void);
    TUseomssascore GetUseomssascore(void) const;
    void SetUseomssascore(TUseomssascore value);
    TUseomssascore& SetUseomssascore(void);

    /// use the number of replicates score?
    /// mandatory
    /// typedef bool TUsereplicatescore
    ///  Check whether the Usereplicatescore data member has been assigned a value.
    bool IsSetUsereplicatescore(void) const;
    /// Check whether it is safe or not to call GetUsereplicatescore method.
    bool CanGetUsereplicatescore(void) const;
    void ResetUsereplicatescore(void);
    TUsereplicatescore GetUsereplicatescore(void) const;
    void SetUsereplicatescore(TUsereplicatescore value);
    TUsereplicatescore& SetUsereplicatescore(void);

    /// use the qtof score?
    /// mandatory
    /// typedef bool TQtofscore
    ///  Check whether the Qtofscore data member has been assigned a value.
    bool IsSetQtofscore(void) const;
    /// Check whether it is safe or not to call GetQtofscore method.
    bool CanGetQtofscore(void) const;
    void ResetQtofscore(void);
    TQtofscore GetQtofscore(void) const;
    void SetQtofscore(TQtofscore value);
    TQtofscore& SetQtofscore(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMSLibrarySettings_Base(const CMSLibrarySettings_Base&);
    CMSLibrarySettings_Base& operator=(const CMSLibrarySettings_Base&);

    // data
    Uint4 m_set_State[1];
    list< string > m_Libnames;
    bool m_Presearch;
    bool m_Useomssascore;
    bool m_Usereplicatescore;
    bool m_Qtofscore;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMSLibrarySettings_Base::IsSetLibnames(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMSLibrarySettings_Base::CanGetLibnames(void) const
{
    return true;
}

inline
const CMSLibrarySettings_Base::TLibnames& CMSLibrarySettings_Base::GetLibnames(void) const
{
    return m_Libnames;
}

inline
CMSLibrarySettings_Base::TLibnames& CMSLibrarySettings_Base::SetLibnames(void)
{
    m_set_State[0] |= 0x1;
    return m_Libnames;
}

inline
bool CMSLibrarySettings_Base::IsSetPresearch(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMSLibrarySettings_Base::CanGetPresearch(void) const
{
    return IsSetPresearch();
}

inline
void CMSLibrarySettings_Base::ResetPresearch(void)
{
    m_Presearch = 0;
    m_set_State[0] &= ~0xc;
}

inline
CMSLibrarySettings_Base::TPresearch CMSLibrarySettings_Base::GetPresearch(void) const
{
    if (!CanGetPresearch()) {
        ThrowUnassigned(1);
    }
    return m_Presearch;
}

inline
void CMSLibrarySettings_Base::SetPresearch(CMSLibrarySettings_Base::TPresearch value)
{
    m_Presearch = value;
    m_set_State[0] |= 0xc;
}

inline
CMSLibrarySettings_Base::TPresearch& CMSLibrarySettings_Base::SetPresearch(void)
{
#ifdef _DEBUG
    if (!IsSetPresearch()) {
        memset(&m_Presearch,UnassignedByte(),sizeof(m_Presearch));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Presearch;
}

inline
bool CMSLibrarySettings_Base::IsSetUseomssascore(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMSLibrarySettings_Base::CanGetUseomssascore(void) const
{
    return IsSetUseomssascore();
}

inline
void CMSLibrarySettings_Base::ResetUseomssascore(void)
{
    m_Useomssascore = 0;
    m_set_State[0] &= ~0x30;
}

inline
CMSLibrarySettings_Base::TUseomssascore CMSLibrarySettings_Base::GetUseomssascore(void) const
{
    if (!CanGetUseomssascore()) {
        ThrowUnassigned(2);
    }
    return m_Useomssascore;
}

inline
void CMSLibrarySettings_Base::SetUseomssascore(CMSLibrarySettings_Base::TUseomssascore value)
{
    m_Useomssascore = value;
    m_set_State[0] |= 0x30;
}

inline
CMSLibrarySettings_Base::TUseomssascore& CMSLibrarySettings_Base::SetUseomssascore(void)
{
#ifdef _DEBUG
    if (!IsSetUseomssascore()) {
        memset(&m_Useomssascore,UnassignedByte(),sizeof(m_Useomssascore));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Useomssascore;
}

inline
bool CMSLibrarySettings_Base::IsSetUsereplicatescore(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CMSLibrarySettings_Base::CanGetUsereplicatescore(void) const
{
    return IsSetUsereplicatescore();
}

inline
void CMSLibrarySettings_Base::ResetUsereplicatescore(void)
{
    m_Usereplicatescore = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CMSLibrarySettings_Base::TUsereplicatescore CMSLibrarySettings_Base::GetUsereplicatescore(void) const
{
    if (!CanGetUsereplicatescore()) {
        ThrowUnassigned(3);
    }
    return m_Usereplicatescore;
}

inline
void CMSLibrarySettings_Base::SetUsereplicatescore(CMSLibrarySettings_Base::TUsereplicatescore value)
{
    m_Usereplicatescore = value;
    m_set_State[0] |= 0xc0;
}

inline
CMSLibrarySettings_Base::TUsereplicatescore& CMSLibrarySettings_Base::SetUsereplicatescore(void)
{
#ifdef _DEBUG
    if (!IsSetUsereplicatescore()) {
        memset(&m_Usereplicatescore,UnassignedByte(),sizeof(m_Usereplicatescore));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Usereplicatescore;
}

inline
bool CMSLibrarySettings_Base::IsSetQtofscore(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CMSLibrarySettings_Base::CanGetQtofscore(void) const
{
    return IsSetQtofscore();
}

inline
void CMSLibrarySettings_Base::ResetQtofscore(void)
{
    m_Qtofscore = 0;
    m_set_State[0] &= ~0x300;
}

inline
CMSLibrarySettings_Base::TQtofscore CMSLibrarySettings_Base::GetQtofscore(void) const
{
    if (!CanGetQtofscore()) {
        ThrowUnassigned(4);
    }
    return m_Qtofscore;
}

inline
void CMSLibrarySettings_Base::SetQtofscore(CMSLibrarySettings_Base::TQtofscore value)
{
    m_Qtofscore = value;
    m_set_State[0] |= 0x300;
}

inline
CMSLibrarySettings_Base::TQtofscore& CMSLibrarySettings_Base::SetQtofscore(void)
{
#ifdef _DEBUG
    if (!IsSetQtofscore()) {
        memset(&m_Qtofscore,UnassignedByte(),sizeof(m_Qtofscore));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Qtofscore;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_OMSSA_MSLIBRARYSETTINGS_BASE_HPP
