/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file MSChargeHandle_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'omssa.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_OMSSA_MSCHARGEHANDLE_BASE_HPP
#define OBJECTS_OMSSA_MSCHARGEHANDLE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/omssa/MSCalcCharge.hpp>
#include <objects/omssa/MSCalcPlusOne.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// How to handle precursor charge
class NCBI_OMSSA_EXPORT CMSChargeHandle_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMSChargeHandle_Base(void);
    // destructor
    virtual ~CMSChargeHandle_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TCalcplusone;
    typedef int TCalccharge;
    typedef int TMincharge;
    typedef int TMaxcharge;
    typedef int TConsidermult;
    typedef double TPlusone;
    typedef int TMaxproductcharge;
    typedef bool TProdlesspre;
    typedef int TNegative;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_calcplusone,
        e_calccharge,
        e_mincharge,
        e_maxcharge,
        e_considermult,
        e_plusone,
        e_maxproductcharge,
        e_prodlesspre,
        e_negative
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 10> TmemberIndex;

    // getters
    // setters

    /// do we guess charge one?
    /// optional with default 1
    /// typedef int TCalcplusone
    ///  Check whether the Calcplusone data member has been assigned a value.
    bool IsSetCalcplusone(void) const;
    /// Check whether it is safe or not to call GetCalcplusone method.
    bool CanGetCalcplusone(void) const;
    void ResetCalcplusone(void);
    void SetDefaultCalcplusone(void);
    TCalcplusone GetCalcplusone(void) const;
    void SetCalcplusone(TCalcplusone value);
    TCalcplusone& SetCalcplusone(void);

    /// how do we handle charges?
    /// optional with default 2
    /// typedef int TCalccharge
    ///  Check whether the Calccharge data member has been assigned a value.
    bool IsSetCalccharge(void) const;
    /// Check whether it is safe or not to call GetCalccharge method.
    bool CanGetCalccharge(void) const;
    void ResetCalccharge(void);
    void SetDefaultCalccharge(void);
    TCalccharge GetCalccharge(void) const;
    void SetCalccharge(TCalccharge value);
    TCalccharge& SetCalccharge(void);

    /// if userange, what is the min?
    /// optional with default 2
    /// typedef int TMincharge
    ///  Check whether the Mincharge data member has been assigned a value.
    bool IsSetMincharge(void) const;
    /// Check whether it is safe or not to call GetMincharge method.
    bool CanGetMincharge(void) const;
    void ResetMincharge(void);
    void SetDefaultMincharge(void);
    TMincharge GetMincharge(void) const;
    void SetMincharge(TMincharge value);
    TMincharge& SetMincharge(void);

    /// if userange, what is the max?
    /// optional with default 3
    /// typedef int TMaxcharge
    ///  Check whether the Maxcharge data member has been assigned a value.
    bool IsSetMaxcharge(void) const;
    /// Check whether it is safe or not to call GetMaxcharge method.
    bool CanGetMaxcharge(void) const;
    void ResetMaxcharge(void);
    void SetDefaultMaxcharge(void);
    TMaxcharge GetMaxcharge(void) const;
    void SetMaxcharge(TMaxcharge value);
    TMaxcharge& SetMaxcharge(void);

    /// at which precursor charge to consider +2 ions?
    /// optional with default 3
    /// typedef int TConsidermult
    ///  Check whether the Considermult data member has been assigned a value.
    bool IsSetConsidermult(void) const;
    /// Check whether it is safe or not to call GetConsidermult method.
    bool CanGetConsidermult(void) const;
    void ResetConsidermult(void);
    void SetDefaultConsidermult(void);
    TConsidermult GetConsidermult(void) const;
    void SetConsidermult(TConsidermult value);
    TConsidermult& SetConsidermult(void);

    /// what % of peaks below precursor needed to call as +1
    /// mandatory
    /// typedef double TPlusone
    ///  Check whether the Plusone data member has been assigned a value.
    bool IsSetPlusone(void) const;
    /// Check whether it is safe or not to call GetPlusone method.
    bool CanGetPlusone(void) const;
    void ResetPlusone(void);
    TPlusone GetPlusone(void) const;
    void SetPlusone(TPlusone value);
    TPlusone& SetPlusone(void);

    /// maximum product ion charge
    /// optional
    /// typedef int TMaxproductcharge
    ///  Check whether the Maxproductcharge data member has been assigned a value.
    bool IsSetMaxproductcharge(void) const;
    /// Check whether it is safe or not to call GetMaxproductcharge method.
    bool CanGetMaxproductcharge(void) const;
    void ResetMaxproductcharge(void);
    TMaxproductcharge GetMaxproductcharge(void) const;
    void SetMaxproductcharge(TMaxproductcharge value);
    TMaxproductcharge& SetMaxproductcharge(void);

    /// product charge always less thanor equal to precursor?
    /// optional
    /// typedef bool TProdlesspre
    ///  Check whether the Prodlesspre data member has been assigned a value.
    bool IsSetProdlesspre(void) const;
    /// Check whether it is safe or not to call GetProdlesspre method.
    bool CanGetProdlesspre(void) const;
    void ResetProdlesspre(void);
    TProdlesspre GetProdlesspre(void) const;
    void SetProdlesspre(TProdlesspre value);
    TProdlesspre& SetProdlesspre(void);

    /// negative ion search if -1, positive ion if 1
    /// optional with default 1
    /// typedef int TNegative
    ///  Check whether the Negative data member has been assigned a value.
    bool IsSetNegative(void) const;
    /// Check whether it is safe or not to call GetNegative method.
    bool CanGetNegative(void) const;
    void ResetNegative(void);
    void SetDefaultNegative(void);
    TNegative GetNegative(void) const;
    void SetNegative(TNegative value);
    TNegative& SetNegative(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMSChargeHandle_Base(const CMSChargeHandle_Base&);
    CMSChargeHandle_Base& operator=(const CMSChargeHandle_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Calcplusone;
    int m_Calccharge;
    int m_Mincharge;
    int m_Maxcharge;
    int m_Considermult;
    double m_Plusone;
    int m_Maxproductcharge;
    bool m_Prodlesspre;
    int m_Negative;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMSChargeHandle_Base::IsSetCalcplusone(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMSChargeHandle_Base::CanGetCalcplusone(void) const
{
    return true;
}

inline
void CMSChargeHandle_Base::ResetCalcplusone(void)
{
    m_Calcplusone = 1;
    m_set_State[0] &= ~0x3;
}

inline
void CMSChargeHandle_Base::SetDefaultCalcplusone(void)
{
    ResetCalcplusone();
}

inline
CMSChargeHandle_Base::TCalcplusone CMSChargeHandle_Base::GetCalcplusone(void) const
{
    return m_Calcplusone;
}

inline
void CMSChargeHandle_Base::SetCalcplusone(CMSChargeHandle_Base::TCalcplusone value)
{
    m_Calcplusone = value;
    m_set_State[0] |= 0x3;
}

inline
CMSChargeHandle_Base::TCalcplusone& CMSChargeHandle_Base::SetCalcplusone(void)
{
#ifdef _DEBUG
    if (!IsSetCalcplusone()) {
        memset(&m_Calcplusone,UnassignedByte(),sizeof(m_Calcplusone));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Calcplusone;
}

inline
bool CMSChargeHandle_Base::IsSetCalccharge(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMSChargeHandle_Base::CanGetCalccharge(void) const
{
    return true;
}

inline
void CMSChargeHandle_Base::ResetCalccharge(void)
{
    m_Calccharge = 2;
    m_set_State[0] &= ~0xc;
}

inline
void CMSChargeHandle_Base::SetDefaultCalccharge(void)
{
    ResetCalccharge();
}

inline
CMSChargeHandle_Base::TCalccharge CMSChargeHandle_Base::GetCalccharge(void) const
{
    return m_Calccharge;
}

inline
void CMSChargeHandle_Base::SetCalccharge(CMSChargeHandle_Base::TCalccharge value)
{
    m_Calccharge = value;
    m_set_State[0] |= 0xc;
}

inline
CMSChargeHandle_Base::TCalccharge& CMSChargeHandle_Base::SetCalccharge(void)
{
#ifdef _DEBUG
    if (!IsSetCalccharge()) {
        memset(&m_Calccharge,UnassignedByte(),sizeof(m_Calccharge));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Calccharge;
}

inline
bool CMSChargeHandle_Base::IsSetMincharge(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMSChargeHandle_Base::CanGetMincharge(void) const
{
    return true;
}

inline
void CMSChargeHandle_Base::ResetMincharge(void)
{
    m_Mincharge = 2;
    m_set_State[0] &= ~0x30;
}

inline
void CMSChargeHandle_Base::SetDefaultMincharge(void)
{
    ResetMincharge();
}

inline
CMSChargeHandle_Base::TMincharge CMSChargeHandle_Base::GetMincharge(void) const
{
    return m_Mincharge;
}

inline
void CMSChargeHandle_Base::SetMincharge(CMSChargeHandle_Base::TMincharge value)
{
    m_Mincharge = value;
    m_set_State[0] |= 0x30;
}

inline
CMSChargeHandle_Base::TMincharge& CMSChargeHandle_Base::SetMincharge(void)
{
#ifdef _DEBUG
    if (!IsSetMincharge()) {
        memset(&m_Mincharge,UnassignedByte(),sizeof(m_Mincharge));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Mincharge;
}

inline
bool CMSChargeHandle_Base::IsSetMaxcharge(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CMSChargeHandle_Base::CanGetMaxcharge(void) const
{
    return true;
}

inline
void CMSChargeHandle_Base::ResetMaxcharge(void)
{
    m_Maxcharge = 3;
    m_set_State[0] &= ~0xc0;
}

inline
void CMSChargeHandle_Base::SetDefaultMaxcharge(void)
{
    ResetMaxcharge();
}

inline
CMSChargeHandle_Base::TMaxcharge CMSChargeHandle_Base::GetMaxcharge(void) const
{
    return m_Maxcharge;
}

inline
void CMSChargeHandle_Base::SetMaxcharge(CMSChargeHandle_Base::TMaxcharge value)
{
    m_Maxcharge = value;
    m_set_State[0] |= 0xc0;
}

inline
CMSChargeHandle_Base::TMaxcharge& CMSChargeHandle_Base::SetMaxcharge(void)
{
#ifdef _DEBUG
    if (!IsSetMaxcharge()) {
        memset(&m_Maxcharge,UnassignedByte(),sizeof(m_Maxcharge));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Maxcharge;
}

inline
bool CMSChargeHandle_Base::IsSetConsidermult(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CMSChargeHandle_Base::CanGetConsidermult(void) const
{
    return true;
}

inline
void CMSChargeHandle_Base::ResetConsidermult(void)
{
    m_Considermult = 3;
    m_set_State[0] &= ~0x300;
}

inline
void CMSChargeHandle_Base::SetDefaultConsidermult(void)
{
    ResetConsidermult();
}

inline
CMSChargeHandle_Base::TConsidermult CMSChargeHandle_Base::GetConsidermult(void) const
{
    return m_Considermult;
}

inline
void CMSChargeHandle_Base::SetConsidermult(CMSChargeHandle_Base::TConsidermult value)
{
    m_Considermult = value;
    m_set_State[0] |= 0x300;
}

inline
CMSChargeHandle_Base::TConsidermult& CMSChargeHandle_Base::SetConsidermult(void)
{
#ifdef _DEBUG
    if (!IsSetConsidermult()) {
        memset(&m_Considermult,UnassignedByte(),sizeof(m_Considermult));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Considermult;
}

inline
bool CMSChargeHandle_Base::IsSetPlusone(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CMSChargeHandle_Base::CanGetPlusone(void) const
{
    return IsSetPlusone();
}

inline
void CMSChargeHandle_Base::ResetPlusone(void)
{
    m_Plusone = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CMSChargeHandle_Base::TPlusone CMSChargeHandle_Base::GetPlusone(void) const
{
    if (!CanGetPlusone()) {
        ThrowUnassigned(5);
    }
    return m_Plusone;
}

inline
void CMSChargeHandle_Base::SetPlusone(CMSChargeHandle_Base::TPlusone value)
{
    m_Plusone = value;
    m_set_State[0] |= 0xc00;
}

inline
CMSChargeHandle_Base::TPlusone& CMSChargeHandle_Base::SetPlusone(void)
{
#ifdef _DEBUG
    if (!IsSetPlusone()) {
        memset(&m_Plusone,UnassignedByte(),sizeof(m_Plusone));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Plusone;
}

inline
bool CMSChargeHandle_Base::IsSetMaxproductcharge(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CMSChargeHandle_Base::CanGetMaxproductcharge(void) const
{
    return IsSetMaxproductcharge();
}

inline
void CMSChargeHandle_Base::ResetMaxproductcharge(void)
{
    m_Maxproductcharge = 0;
    m_set_State[0] &= ~0x3000;
}

inline
CMSChargeHandle_Base::TMaxproductcharge CMSChargeHandle_Base::GetMaxproductcharge(void) const
{
    if (!CanGetMaxproductcharge()) {
        ThrowUnassigned(6);
    }
    return m_Maxproductcharge;
}

inline
void CMSChargeHandle_Base::SetMaxproductcharge(CMSChargeHandle_Base::TMaxproductcharge value)
{
    m_Maxproductcharge = value;
    m_set_State[0] |= 0x3000;
}

inline
CMSChargeHandle_Base::TMaxproductcharge& CMSChargeHandle_Base::SetMaxproductcharge(void)
{
#ifdef _DEBUG
    if (!IsSetMaxproductcharge()) {
        memset(&m_Maxproductcharge,UnassignedByte(),sizeof(m_Maxproductcharge));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Maxproductcharge;
}

inline
bool CMSChargeHandle_Base::IsSetProdlesspre(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CMSChargeHandle_Base::CanGetProdlesspre(void) const
{
    return IsSetProdlesspre();
}

inline
void CMSChargeHandle_Base::ResetProdlesspre(void)
{
    m_Prodlesspre = 0;
    m_set_State[0] &= ~0xc000;
}

inline
CMSChargeHandle_Base::TProdlesspre CMSChargeHandle_Base::GetProdlesspre(void) const
{
    if (!CanGetProdlesspre()) {
        ThrowUnassigned(7);
    }
    return m_Prodlesspre;
}

inline
void CMSChargeHandle_Base::SetProdlesspre(CMSChargeHandle_Base::TProdlesspre value)
{
    m_Prodlesspre = value;
    m_set_State[0] |= 0xc000;
}

inline
CMSChargeHandle_Base::TProdlesspre& CMSChargeHandle_Base::SetProdlesspre(void)
{
#ifdef _DEBUG
    if (!IsSetProdlesspre()) {
        memset(&m_Prodlesspre,UnassignedByte(),sizeof(m_Prodlesspre));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Prodlesspre;
}

inline
bool CMSChargeHandle_Base::IsSetNegative(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CMSChargeHandle_Base::CanGetNegative(void) const
{
    return true;
}

inline
void CMSChargeHandle_Base::ResetNegative(void)
{
    m_Negative = 1;
    m_set_State[0] &= ~0x30000;
}

inline
void CMSChargeHandle_Base::SetDefaultNegative(void)
{
    ResetNegative();
}

inline
CMSChargeHandle_Base::TNegative CMSChargeHandle_Base::GetNegative(void) const
{
    return m_Negative;
}

inline
void CMSChargeHandle_Base::SetNegative(CMSChargeHandle_Base::TNegative value)
{
    m_Negative = value;
    m_set_State[0] |= 0x30000;
}

inline
CMSChargeHandle_Base::TNegative& CMSChargeHandle_Base::SetNegative(void)
{
#ifdef _DEBUG
    if (!IsSetNegative()) {
        memset(&m_Negative,UnassignedByte(),sizeof(m_Negative));
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Negative;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_OMSSA_MSCHARGEHANDLE_BASE_HPP
